package io.github.openbagtwo.lighterend.datagen;

import io.github.openbagtwo.lighterend.misc.Wood.WoodSet;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks.Material;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_3481;
import net.minecraft.class_7225;
import net.minecraft.class_7225.class_7874;

public class BlockTagProvider extends FabricTagProvider.BlockTagProvider {

  protected BlockTagProvider(
      FabricDataOutput output, CompletableFuture<class_7874> future
  ) {
    super(output, future);
  }

  @Override
  protected void method_10514(class_7225.class_7874 lookup) {

    method_10512(class_3481.field_15490).add(LighterEndBlocks.AURORA_CRYSTAL);
    method_10512(class_3481.field_42607).add(LighterEndBlocks.END_MOSS);

    for (Material material : Arrays.asList(
        LighterEndBlocks.VIOLECITE,
        LighterEndBlocks.AZURE_JADESTONE,
        LighterEndBlocks.SANDY_JADESTONE,
        LighterEndBlocks.VIRID_JADESTONE,
        LighterEndBlocks.UMBRALITH,
        LighterEndBlocks.BORNITE
    )) {
      for (class_2248 block : material.blocks) {
        method_10512(class_3481.field_33715).add(block);
        method_10512(class_3481.field_15504)
            .add(
                material.baseWall,
                material.brickWall,
                material.polishedWall,
                material.tileWall
            );
        method_10512(class_3481.field_44590).add(material.button);
        method_10512(class_3481.field_24077).add(material.pressurePlate);
      }
    }

    for (WoodSet wood : Arrays.asList(
        LighterEndBlocks.TENANEA,
        LighterEndBlocks.UMBRELLA,
        LighterEndBlocks.LOTUS,
        LighterEndBlocks.GLOWSHROOM,
        LighterEndBlocks.DRAGON
    )) {
      for (class_2248 block : wood.blocks) {
        method_10512(class_3481.field_33713).add(block);
      }
      method_10512(class_3481.field_33713).add(wood.wallSign, wood.wallHangingSign);
      method_10512(class_3481.field_15471).add(wood.planks);
      method_10512(class_3481.field_15499).add(wood.button);
      method_10512(class_3481.field_15494).add(wood.door);
      method_10512(class_3481.field_15502).add(wood.stairs);
      method_10512(class_3481.field_15468).add(wood.slab);
      method_10512(class_3481.field_17619).add(wood.fence);
      method_10512(class_3481.field_25147).add(wood.gate);
      method_10512(class_3481.field_15477).add(wood.pressurePlate);
      method_10512(class_3481.field_23210).add(
          wood.log,
          wood.strippedLog,
          wood.wood,
          wood.strippedWood
      );  // this also adds them to #minecraft:logs
      method_10512(class_3481.field_15491).add(wood.trapdoor);
      method_10512(class_3481.field_15472).add(wood.sign);
      method_10512(class_3481.field_15492).add(wood.wallSign);
      method_10512(class_3481.field_40103).add(wood.hangingSign);
      method_10512(class_3481.field_40104).add(wood.wallHangingSign);
      method_10512(class_3481.field_22414).add(wood.ladder);
    }

    method_10512(class_3481.field_33715)
        .add(
            LighterEndBlocks.ENDER_BLOCK,
            LighterEndBlocks.MISSING_TILE,
            LighterEndBlocks.DRAGON_BONE_BLOCK,
            LighterEndBlocks.DRAGON_BONE_STAIRS,
            LighterEndBlocks.DRAGON_BONE_SLAB,
            LighterEndBlocks.END_MOSS,
            LighterEndBlocks.END_FURNACE,
            LighterEndBlocks.END_SMOKER,
            LighterEndBlocks.GOLD_CHANDELIER,
            LighterEndBlocks.IRON_CHANDELIER,
            LighterEndBlocks.EMERALD_ICE,
            LighterEndBlocks.FERROUS_ICE,
            LighterEndBlocks.AUROUS_ICE,
            LighterEndBlocks.END_STONE_QUARTZ_ORE,
            LighterEndBlocks.END_STONE_REDSTONE_ORE,
            LighterEndBlocks.UMBRALITH_QUARTZ_ORE,
            LighterEndBlocks.UMBRALITH_REDSTONE_ORE,
            LighterEndBlocks.BRIMSTONE,
            LighterEndBlocks.HYDROTHERMAL_VENT
        );

    method_10512(class_3481.field_33719)
        .add(LighterEndBlocks.ENDER_BLOCK)
        .add(LighterEndBlocks.HYDROTHERMAL_VENT);

    method_10512(class_3481.field_33718)
        .add(
            LighterEndBlocks.END_STONE_QUARTZ_ORE,
            LighterEndBlocks.END_STONE_REDSTONE_ORE,
            LighterEndBlocks.UMBRALITH_QUARTZ_ORE,
            LighterEndBlocks.UMBRALITH_REDSTONE_ORE
        );

    method_10512(class_3481.field_15460).add(
        LighterEndBlocks.END_MOSS
    );
    method_10512(class_3481.field_15460).method_26792(LighterEndTags.FURS);

    method_10512(class_3481.field_35567).add(LighterEndBlocks.END_MOSS);
    method_10512(class_3481.field_44470).add(LighterEndBlocks.END_MOSS);
    method_10512(class_3481.field_37399).add(LighterEndBlocks.END_MOSS);

    method_10512(class_3481.field_20339).add(
        LighterEndBlocks.CREEPING_MOSS,
        LighterEndBlocks.UMBRELLA_FERN,
        LighterEndBlocks.TALL_UMBRELLA_FERN,
        LighterEndBlocks.TENANEA_FLOWER,
        LighterEndBlocks.END_LOTUS_FLOWER
    );

    method_10512(class_3481.field_33713).add(
        LighterEndBlocks.LUMECORN_STEM,
        LighterEndBlocks.END_LOTUS_STEM,
        LighterEndBlocks.UMBRELLA_TREE_CLUSTER,
        LighterEndBlocks.UMBRELLA_TREE_CLUSTER_EMPTY,
        LighterEndBlocks.GLOWSHROOM_CAP,
        LighterEndBlocks.GLOWSHROOM_HYMENOPHORE,
        LighterEndBlocks.END_LOTUS_STEM,
        LighterEndBlocks.AGAVE,
        LighterEndBlocks.AGAVE_BULB
    );

    method_10512(class_3481.field_15462).add(
        LighterEndBlocks.TENANEA_SAPLING,
        LighterEndBlocks.UMBRELLA_TREE_SAPLING,
        LighterEndBlocks.GLOWSHROOM_SAPLING,
        LighterEndBlocks.DRAGON_SAPLING
    );
    method_10512(class_3481.field_15503).add(
        LighterEndBlocks.TENANEA_LEAVES,
        LighterEndBlocks.GLOWSHROOM_FUR,
        LighterEndBlocks.AGAVE_FUR,
        LighterEndBlocks.DRAGON_LEAVES
    );

    method_10512(class_3481.field_15470).add(
        LighterEndBlocks.POTTED_TENANEA_SAPLING,
        LighterEndBlocks.POTTED_UMBRELLA_SAPLING,
        LighterEndBlocks.POTTED_GLOWSHROOM_SAPLING
    );

    method_10512(class_3481.field_49051).add(
        LighterEndBlocks.OBELISK
    );
    method_10512(class_3481.field_17753).add(
        LighterEndBlocks.OBELISK
    );
    method_10512(class_3481.field_33757).add(
        LighterEndBlocks.OBELISK
    );
    method_10512(class_3481.field_33863).add(
        LighterEndBlocks.OBELISK
    );
    method_10512(class_3481.field_17754).add(
        LighterEndBlocks.OBELISK
    );

    method_10512(class_3481.field_15467).add(
        LighterEndBlocks.EMERALD_ICE,
        LighterEndBlocks.FERROUS_ICE
    );

    method_10512(class_3481.field_25588).add(LighterEndBlocks.BRIMSTONE);

    method_10512(LighterEndTags.END_MOSS_REPLACEABLE)
        .add(
            class_2246.field_10471,
            class_2246.field_23869,
            class_2246.field_22091,
            class_2246.field_10264,
            class_2246.field_10396,
            class_2246.field_10111,
            class_2246.field_10488,
            class_2246.field_10614,
            LighterEndBlocks.UMBRALITH.baseBlock,
            LighterEndBlocks.BRIMSTONE
        );
    method_10512(LighterEndTags.END_SOIL)
        .add(
            LighterEndBlocks.END_MOSS,
            LighterEndBlocks.UMBRALITH.baseBlock,
            LighterEndBlocks.BRIMSTONE,
            LighterEndBlocks.BORNITE.baseBlock
        );
    method_10512(LighterEndTags.END_STONES)
        .add(
            class_2246.field_10471,
            class_2246.field_23869,
            class_2246.field_22091,
            class_2246.field_10264,
            class_2246.field_10396,
            class_2246.field_10111,
            class_2246.field_10488,
            class_2246.field_10614,
            LighterEndBlocks.VIOLECITE.baseBlock,
            LighterEndBlocks.AZURE_JADESTONE.baseBlock,
            LighterEndBlocks.SANDY_JADESTONE.baseBlock,
            LighterEndBlocks.VIRID_JADESTONE.baseBlock,
            LighterEndBlocks.UMBRALITH.baseBlock,
            LighterEndBlocks.BRIMSTONE,
            LighterEndBlocks.BORNITE.baseBlock
        );
    method_10512(LighterEndTags.AQUATIC_END_SOIL)
        .add(
            class_2246.field_10471,
            class_2246.field_23869,
            class_2246.field_10102,
            class_2246.field_9979,
            class_2246.field_10534,
            class_2246.field_10344,
            class_2246.field_10255,
            class_2246.field_10566,
            class_2246.field_10253,
            class_2246.field_37576,
            LighterEndBlocks.UMBRALITH.baseBlock,
            LighterEndBlocks.END_MOSS,  // though pretty sure this won't survive underwater
            LighterEndBlocks.BRIMSTONE,
            LighterEndBlocks.BORNITE.baseBlock
        );
    method_10512(LighterEndTags.AQUATIC_END_VEGETATION)
        .add(
            LighterEndBlocks.CHARNIA_CYAN,
            LighterEndBlocks.CHARNIA_GREEN,
            LighterEndBlocks.CHARNIA_LIGHT_BLUE,
            LighterEndBlocks.CHARNIA_ORANGE,
            LighterEndBlocks.CHARNIA_PURPLE,
            LighterEndBlocks.CHARNIA_RED
        );
    method_10512(LighterEndTags.FURS)
        .add(
            LighterEndBlocks.AGAVE_FUR,
            LighterEndBlocks.GLOWSHROOM_FUR
        );
    method_10512(LighterEndTags.SLIME_SPAWNABLE).method_26792(LighterEndTags.END_STONES);
    method_10512(LighterEndTags.SLIME_SPAWNABLE).method_26792(LighterEndTags.END_SOIL);
    method_10512(LighterEndTags.GROWS_SULPHUR_CRYSTALS).add(LighterEndBlocks.BRIMSTONE);


  }

}
