package io.github.openbagtwo.lighterend.datagen;

import io.github.openbagtwo.lighterend.misc.Wood.WoodSet;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks.Material;
import io.github.openbagtwo.lighterend.registries.LighterEndEquipment;
import io.github.openbagtwo.lighterend.registries.LighterEndItems;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1802;
import net.minecraft.class_3489;
import net.minecraft.class_7225;
import net.minecraft.class_7225.class_7874;

public class ItemTagProvider extends FabricTagProvider.ItemTagProvider {

  public ItemTagProvider(
      FabricDataOutput output,
      CompletableFuture<class_7874> future
  ) {
    super(output, future);
  }

  @Override
  protected void method_10514(class_7225.class_7874 lookup) {
    for (WoodSet wood : Arrays.asList(
        LighterEndBlocks.TENANEA,
        LighterEndBlocks.UMBRELLA,
        LighterEndBlocks.LOTUS,
        LighterEndBlocks.GLOWSHROOM,
        LighterEndBlocks.DRAGON
    )) {
      method_10512(LighterEndTags.LOG_TAGS.get(wood.baseName)).add(
          wood.log.method_8389(),
          wood.strippedLog.method_8389(),
          wood.wood.method_8389(),
          wood.strippedWood.method_8389()
      );
      method_10512(LighterEndTags.STRIPPED_LOG_TAGS.get(wood.baseName)).add(
          wood.strippedLog.method_8389(),
          wood.strippedWood.method_8389()
      );
      method_10512(class_3489.field_23212).method_26792(
          LighterEndTags.LOG_TAGS.get(wood.baseName)
      );
      method_10512(class_3489.field_15537).add(wood.planks.method_8389());
      method_10512(class_3489.field_15555).add(wood.button.method_8389());
      method_10512(class_3489.field_15552).add(wood.door.method_8389());
      method_10512(class_3489.field_15557).add(wood.stairs.method_8389());
      method_10512(class_3489.field_15534).add(wood.slab.method_8389());
      method_10512(class_3489.field_17620).add(wood.fence.method_8389());
      method_10512(class_3489.field_40858).add(wood.gate.method_8389());
      method_10512(class_3489.field_15540).add(wood.pressurePlate.method_8389());
      method_10512(class_3489.field_15550).add(wood.trapdoor.method_8389());
      method_10512(class_3489.field_15533).add(wood.sign.method_8389());
      method_10512(class_3489.field_40108).add(wood.hangingSign.method_8389());

    }
    for (Material material : Arrays.asList(
        LighterEndBlocks.VIOLECITE,
        LighterEndBlocks.AZURE_JADESTONE,
        LighterEndBlocks.SANDY_JADESTONE,
        LighterEndBlocks.VIRID_JADESTONE,
        LighterEndBlocks.UMBRALITH,
        LighterEndBlocks.BORNITE
    )) {
      method_10512(class_3489.field_44592).add(material.button.method_8389());
    }
    method_10512(class_3489.field_49943).add(LighterEndBlocks.LUMECORN_SEED.method_8389());
    method_10512(class_3489.field_49942).add(LighterEndBlocks.TENANEA_FLOWER.method_8389());
    method_10512(class_3489.field_15558).add(
        LighterEndBlocks.TENANEA_LEAVES.method_8389(),
        LighterEndItems.GLOWSHROOM_FUR,
        LighterEndItems.AGAVE_FUR,
        LighterEndBlocks.DRAGON_LEAVES.method_8389()
    );

    method_10512(class_3489.field_15527).add(LighterEndItems.RAW_END_FISH);

    method_10512(class_3489.field_48803).add(
        LighterEndEquipment.SILK_ELYTRA
    );

    method_10512(class_3489.field_48296).add(
        LighterEndEquipment.SILK_ELYTRA
    );  // this makes silk elytra trimmable

    method_10512(class_3489.field_54554).method_26792(LighterEndTags.FUR_ITEMS);

    method_10512(class_3489.field_54213).add(LighterEndItems.END_POWDER);

    method_10512(class_3489.field_49932).add(
        LighterEndItems.CRAB_MEAT,
        LighterEndItems.CRAB_CAKE
    );

    method_10512(class_3489.field_26988).add(
        LighterEndItems.CRAB_MEAT,
        LighterEndItems.CRAB_CAKE
    );

    method_10512(LighterEndTags.REPAIRS_SILK_ARMOR).add(LighterEndItems.SILK);

    method_10512(class_3489.field_41891).add(
        LighterEndItems.AURORA_CRYSTAL_SHARD
    );

    method_10512(LighterEndTags.FLETCHINGS).add(
        class_1802.field_8153,
        LighterEndBlocks.CHARNIA_CYAN.method_8389(),
        LighterEndBlocks.CHARNIA_GREEN.method_8389(),
        LighterEndBlocks.CHARNIA_LIGHT_BLUE.method_8389(),
        LighterEndBlocks.CHARNIA_ORANGE.method_8389(),
        LighterEndBlocks.CHARNIA_PURPLE.method_8389(),
        LighterEndBlocks.CHARNIA_RED.method_8389()
    );
    method_10512(LighterEndTags.FLETCHINGS).method_26792(LighterEndTags.FUR_ITEMS);

    method_10512(LighterEndTags.FUR_ITEMS).add(
        LighterEndItems.GLOWSHROOM_FUR,
        LighterEndItems.AGAVE_FUR
    );

    method_10512(LighterEndTags.POLYPORES).add(
        LighterEndBlocks.AURANT_POLYPORE.method_8389(),
        LighterEndBlocks.PURPLE_POLYPORE.method_8389()
    );

    method_10512(LighterEndTags.MOOSHROOM_FOOD).add(
        LighterEndItems.LUMECORN_EAR
    );
  }


}
