package io.github.openbagtwo.lighterend.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import io.github.openbagtwo.lighterend.world.gen.LighterEndWorldGen;
import net.minecraft.class_2378;
import net.minecraft.class_3754;
import net.minecraft.class_5284;
import net.minecraft.class_5363;
import net.minecraft.class_6686;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(MinecraftServer.class)
public abstract class SurfaceGenMixin {

  @Inject(at = @At("TAIL"), method = "createWorlds(Lnet/minecraft/server/WorldGenerationProgressListener;)V")
  private void addSurfaceRules(CallbackInfo ci,
      @Local class_2378<class_5363> registry) {
    class_5363 stem = registry.method_29107(class_5363.field_25414);

    if (stem != null && stem.comp_1013() instanceof class_3754 generator) {
      class_5284 settings = generator.method_41541().comp_349();
      ChunkGeneratorSettingsAccessor accessor = (ChunkGeneratorSettingsAccessor) (Object) settings;

      accessor.setSurfaceRule(
          class_6686.method_39050(LighterEndWorldGen.updateSurfaceRules(), settings.comp_478()));
    }
  }
}
