package io.github.openbagtwo.lighterend.mobs.renderers;

import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.mobs.EndFish;
import io.github.openbagtwo.lighterend.mobs.EntityModels;
import io.github.openbagtwo.lighterend.mobs.models.EndFishModel;
import io.github.openbagtwo.lighterend.mobs.states.EndFishRenderState;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4606;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_927;

public class EndFishRenderer extends
    class_927<EndFish, EndFishRenderState, EndFishModel> {

  private static final List<class_2960> TEXTURES = Arrays.asList(
      LighterEnd.of("textures/entity/end_fish/end_fish_0.png"),
      LighterEnd.of("textures/entity/end_fish/end_fish_1.png"),
      LighterEnd.of("textures/entity/end_fish/end_fish_2.png"),
      LighterEnd.of("textures/entity/end_fish/end_fish_3.png"),
      LighterEnd.of("textures/entity/end_fish/end_fish_4.png"),
      LighterEnd.of("textures/entity/end_fish/end_fish_5.png"),
      LighterEnd.of("textures/entity/end_fish/end_fish_6.png"),
      LighterEnd.of("textures/entity/end_fish/end_fish_7.png")
  );
  private static final List<class_1921> GLOW = Arrays.asList(
      class_1921.method_23026(
          LighterEnd.of("textures/entity/end_fish/end_fish_0_glow.png")),
      class_1921.method_23026(
          LighterEnd.of("textures/entity/end_fish/end_fish_1_glow.png")),
      class_1921.method_23026(
          LighterEnd.of("textures/entity/end_fish/end_fish_2_glow.png")),
      class_1921.method_23026(
          LighterEnd.of("textures/entity/end_fish/end_fish_3_glow.png")),
      class_1921.method_23026(
          LighterEnd.of("textures/entity/end_fish/end_fish_4_glow.png")),
      class_1921.method_23026(
          LighterEnd.of("textures/entity/end_fish/end_fish_5_glow.png")),
      class_1921.method_23026(
          LighterEnd.of("textures/entity/end_fish/end_fish_6_glow.png")),
      class_1921.method_23026(
          LighterEnd.of("textures/entity/end_fish/end_fish_7_glow.png"))
  );

  public EndFishRenderer(class_5617.class_5618 ctx) {
    super(ctx, new EndFishModel(ctx.method_32167(EntityModels.END_FISH_MODEL)), 0.5F);
    this.method_4046(new class_4606<>(this) {
      @Override
      public class_1921 method_23193() {
        return GLOW.get(0);
      }

      @Override
      public void render(
          class_4587 matrices,
          class_4597 vertexConsumers,
          int light,
          EndFishRenderState state,
          float limbAngle,
          float limbDistance
      ) {
        class_4588 vertexConsumer = vertexConsumers.getBuffer(
            GLOW.get(state.variant % GLOW.size())
        );
        this.method_17165()
            .method_62100(
                matrices,
                vertexConsumer,
                15728640,
                class_4608.field_21444,
                0xffffffff
            );
      }
    });
  }

  @Override
  public EndFishRenderState method_55269() {
    return new EndFishRenderState();
  }

  @Override
  public class_2960 getTexture(EndFishRenderState state) {
    return TEXTURES.get(state.variant % TEXTURES.size());
  }

  @Override
  public void updateRenderState(EndFish fish, EndFishRenderState state, float f) {
    super.method_62355(fish, state, f);
    state.variant = fish.getVariant();
  }
}
