package io.github.openbagtwo.lighterend.particles;

import io.github.openbagtwo.lighterend.blocks.TenaneaFlowerRenderer;
import net.minecraft.class_2338;
import net.minecraft.class_2400;
import net.minecraft.class_322;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;

public class TenaneaPetal extends class_4003 {

  private static class_322 provider;

  private double preVX;
  private double preVY;
  private double preVZ;
  private double nextVX;
  private double nextVY;
  private double nextVZ;

  protected TenaneaPetal(
      class_638 world,
      double x,
      double y,
      double z,
      double r,
      double g,
      double b,
      class_4002 sprites
  ) {
    super(world, x, y, z, r, g, b);
    this.method_18140(sprites);

    if (provider == null) {
      provider = TenaneaFlowerRenderer.getBlockColor();
    }
    int color = provider.getColor(null, null, new class_2338((int) x, (int) y, (int) z), 0);
    this.field_3861 = ((color >> 16) & 255) / 255F;
    this.field_3842 = ((color >> 8) & 255) / 255F;
    this.field_3859 = ((color) & 255) / 255F;

    this.field_3847 = class_3532.method_15395(this.field_3840, 120, 200);
    this.field_17867 = class_3532.method_15344(this.field_3840, 0.05F, 0.15F);
    this.method_3083(0);

    this.preVX = 0;
    this.preVY = 0;
    this.preVZ = 0;

    this.nextVX = this.field_3840.method_43059() * 0.02;
    this.nextVY = -this.field_3840.method_43058() * 0.02 - 0.02;
    this.nextVZ = this.field_3840.method_43059() * 0.02;
  }

  @Override
  public int method_3068(float tint) {
    return 15728880;
  }

  @Override
  public void method_3070() {
    int ticks = this.field_3866 & 63;
    if (ticks == 0) {
      this.preVX = this.nextVX;
      this.preVY = this.nextVY;
      this.preVZ = this.nextVZ;
      this.nextVX = this.field_3840.method_43059() * 0.02;
      this.nextVY = -this.field_3840.method_43058() * 0.02 - 0.02;
      this.nextVZ = this.field_3840.method_43059() * 0.02;
    }
    double delta = ticks / 63.0;

    if (this.field_3866 <= 40) {
      this.method_3083(this.field_3866 / 40F);
    } else if (this.field_3866 >= this.field_3847 - 40) {
      this.method_3083((this.field_3847 - this.field_3866) / 40F);
    }

    if (this.field_3866 >= this.field_3847) {
      this.method_3085();
    }

    this.field_3852 = class_3532.method_16436(delta, preVX, nextVX);
    this.field_3869 = class_3532.method_16436(delta, preVY, nextVY);
    this.field_3850 = class_3532.method_16436(delta, preVZ, nextVZ);

    super.method_3070();
  }

  @Override
  public class_3999 method_18122() {
    return class_3999.field_17829;
  }

  public static class Factory implements class_707<class_2400> {

    private final class_4002 sprites;

    public Factory(class_4002 sprites) {
      this.sprites = sprites;
    }

    @Override
    public class_703 createParticle(
        class_2400 type,
        class_638 world,
        double x,
        double y,
        double z,
        double vX,
        double vY,
        double vZ
    ) {
      return new TenaneaPetal(world, x, y, z, 1, 1, 1, sprites);
    }
  }

}
