package io.github.openbagtwo.lighterend.registries;

import io.github.openbagtwo.lighterend.LighterEnd;
import io.github.openbagtwo.lighterend.world.biomes.BlossomingForest;
import io.github.openbagtwo.lighterend.world.biomes.FoggyMushroomlands;
import io.github.openbagtwo.lighterend.world.biomes.GlowingGrasslands;
import io.github.openbagtwo.lighterend.world.biomes.Megalake;
import io.github.openbagtwo.lighterend.world.biomes.ShadowForest;
import io.github.openbagtwo.lighterend.world.biomes.Starfield;
import io.github.openbagtwo.lighterend.world.biomes.SulphurSprings;
import io.github.openbagtwo.lighterend.world.biomes.UmbraValley;
import io.github.openbagtwo.lighterend.world.biomes.UmbrellaJungle;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import net.minecraft.class_7891;
import net.minecraft.class_7924;

public class LighterEndBiomes {

  public static final class_5321<class_1959> BLOSSOM_FOREST = register("blossom_forest");
  public static final class_5321<class_1959> UMBRELLA_JUNGLE = register("umbrella_jungle");
  public static final class_5321<class_1959> GLOWING_GRASSLAND = register("glowing_grassland");
  public static final class_5321<class_1959> MEGALAKE = register("megalake");
  public static final class_5321<class_1959> UMBRA_VALLEY = register("umbra_valley");
  public static final class_5321<class_1959> FOGGY_MUSHROOMLANDS = register("mushroomlands");
  public static final class_5321<class_1959> STARFIELD = register("starfield");
  public static final class_5321<class_1959> SULPHUR_SPRINGS = register("sulphur_springs");
  public static final class_5321<class_1959> SHADOW_FOREST = register("shadow_forest");

  public static void bootstrap(class_7891<class_1959> context) {
    context.method_46838(BLOSSOM_FOREST, BlossomingForest.create(context));
    context.method_46838(UMBRELLA_JUNGLE, UmbrellaJungle.create(context));
    context.method_46838(GLOWING_GRASSLAND, GlowingGrasslands.create(context));
    context.method_46838(MEGALAKE, Megalake.create(context));
    context.method_46838(UMBRA_VALLEY, UmbraValley.create(context));
    context.method_46838(FOGGY_MUSHROOMLANDS, FoggyMushroomlands.create(context));
    context.method_46838(STARFIELD, Starfield.create(context));
    context.method_46838(SULPHUR_SPRINGS, SulphurSprings.create(context));
    context.method_46838(SHADOW_FOREST, ShadowForest.create(context));
  }

  private static class_5321<class_1959> register(String name) {
    class_5321<class_1959> key = class_5321.method_29179(class_7924.field_41236, LighterEnd.of(name));
    return key;
  }

}
