package io.github.openbagtwo.lighterend.utils.math.sdf.operators;

public class SDFFlatWave extends SDFDisplace {

  private int rayCount = 1;
  private float intensity;
  private float angle;

  public SDFFlatWave() {
    setFunction((pos) -> {
      return (float) Math.cos(Math.atan2(pos.x(), pos.z()) * rayCount + angle) * intensity;
    });
  }

  public SDFFlatWave setRaysCount(int count) {
    this.rayCount = count;
    return this;
  }

  public SDFFlatWave setAngle(float angle) {
    this.angle = angle;
    return this;
  }

  public SDFFlatWave setIntensity(float intensity) {
    this.intensity = intensity;
    return this;
  }
}
