package io.github.openbagtwo.lighterend.world.features;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6017;
import org.jetbrains.annotations.Nullable;

public class BuriedBlob extends class_3031<BuriedBlob.Config> {

  public BuriedBlob() {
    super(Config.CODEC);
  }

  @Override
  public boolean method_13151(class_5821<BuriedBlob.Config> context) {
    Config config = context.method_33656();
    class_5281 structureWorldAccess = context.method_33652();
    class_5819 random = context.method_33654();
    class_2248 block = config.target.method_26204();
    var blockPos = moveDownToTarget(
        structureWorldAccess,
        context.method_33655().method_25503()
            .method_27158(
                class_2350.class_2351.field_11052,
                structureWorldAccess.method_31607() + 1,
                structureWorldAccess.method_31600()
            ),
        block
    );
    if (blockPos == null) {
      return false;
    } else {
      blockPos.method_10104(class_2350.field_11033, config.depth);
      int i = config.getRadius().method_35008(random);
      int j = config.getRadius().method_35008(random);
      int k = config.getRadius().method_35008(random);
      int l = Math.max(i, Math.max(j, k));
      boolean bl = false;

      for (class_2338 blockPos2 : class_2338.method_25996(blockPos, i, j, k)) {
        if (blockPos2.method_19455(blockPos) > l) {
          break;
        }

        class_2680 blockState = structureWorldAccess.method_8320(blockPos2);
        if (blockState.method_27852(block)) {
          this.method_13153(structureWorldAccess, blockPos2, config.state);
          bl = true;
        }
      }

      return bl;
    }
  }

  @Nullable
  private static class_2338.class_2339 moveDownToTarget(
      class_1936 world,
      class_2338.class_2339 mutablePos,
      class_2248 target
  ) {
    while (mutablePos.method_10264() > world.method_31607() + 1) {
      class_2680 blockState = world.method_8320(mutablePos);
      if (blockState.method_27852(target)) {
        return mutablePos;
      }
      mutablePos.method_10098(class_2350.field_11033);
    }

    return null;
  }

  public static class Config implements class_3037 {

    public static final Codec<Config> CODEC = RecordCodecBuilder.create(
        instance -> instance.group(
                class_2680.field_24734.fieldOf("target").forGetter(config -> config.target),
                class_2680.field_24734.fieldOf("state").forGetter(config -> config.state),
                class_6017.method_35004(0, 12).fieldOf("radius")
                    .forGetter(config -> config.radius),
                Codec.INT.fieldOf("depth").forGetter(config -> config.depth)
            )
            .apply(instance, Config::new)
    );

    public final class_2680 target;
    public final class_2680 state;
    private final class_6017 radius;
    private final int depth;

    public Config(class_2680 target, class_2680 state, class_6017 radius, int depth) {
      this.target = target;
      this.state = state;
      this.radius = radius;
      this.depth = depth;
    }

    public class_6017 getRadius() {
      return this.radius;
    }
  }
}
