package io.github.openbagtwo.lighterend.world.features;

import static net.minecraft.class_2902.class_2903.field_13202;
import static net.minecraft.class_2902.class_2903.field_13194;

import io.github.openbagtwo.lighterend.BlockFixer;
import io.github.openbagtwo.lighterend.blocks.HydrothermalVent;
import io.github.openbagtwo.lighterend.blocks.TubeWorm;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import io.github.openbagtwo.lighterend.utils.Flags;
import io.github.openbagtwo.lighterend.utils.MiscUtils;
import io.github.openbagtwo.lighterend.utils.math.sdf.SDF;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFCoordsModify;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFDisplace;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFInvert;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFRotate;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFScale3D;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFSmoothUnion;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFSubtract;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFTranslate;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFUnion;
import io.github.openbagtwo.lighterend.utils.math.sdf.primitives.SDFCappedCone;
import io.github.openbagtwo.lighterend.utils.math.sdf.primitives.SDFFlatland;
import io.github.openbagtwo.lighterend.utils.math.sdf.primitives.SDFSphere;
import io.github.openbagtwo.lighterend.world.gen.noise.OpenSimplexNoise;
import java.util.function.Function;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2338.class_2339;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_7833;

public class Geyser extends class_3031<class_3111> {

  protected static final Function<class_2680, Boolean> REPLACE1;
  protected static final Function<class_2680, Boolean> REPLACE2;
  private static final Function<class_2680, Boolean> IGNORE;

  public Geyser() {
    super(class_3111.field_24893);
  }

  @Override
  public boolean method_13151(class_5821<class_3111> context) {
    final class_5819 random = context.method_33654();
    final class_5281 world = context.method_33652();
    final class_2338 pos = world.method_8598(field_13194, context.method_33655());
    final class_2794 chunkGenerator = context.method_33653();

    if (pos.method_10264() < 10) {
      return false;
    }

    class_2339 bpos = new class_2339().method_10101(pos);
    bpos.method_33098(bpos.method_10264() - 1);
    class_2680 state = world.method_8320(bpos);
    while (state.method_26164(LighterEndTags.END_STONES)
        || !state.method_26227().method_15769() && bpos.method_10264() > 5) {
      bpos.method_33098(bpos.method_10264() - 1);
      state = world.method_8320(bpos);
    }

    if (pos.method_10264() - bpos.method_10264() < 25) {
      return false;
    }

    int halfHeight = class_3532.method_15395(random, 10, 20);
    float radius1 = halfHeight * 0.5F;
    float radius2 = halfHeight * 0.1F + 0.5F;
    SDF sdf = new SDFCappedCone().setHeight(halfHeight)
        .setRadius1(radius1)
        .setRadius2(radius2)
        .setBlock(LighterEndBlocks.BORNITE.baseBlock);
    sdf = new SDFTranslate().setTranslate(0, halfHeight - 3, 0).setSource(sdf);

    int count = halfHeight;
    for (int i = 0; i < count; i++) {
      int py = i << 1;
      float delta = (float) i / (float) (count - 1);
      float radius = class_3532.method_16439(delta, radius1, radius2) * 1.3F;

      SDF bowl = new SDFCappedCone().setHeight(radius)
          .setRadius1(0)
          .setRadius2(radius)
          .setBlock(LighterEndBlocks.BORNITE.baseBlock);

      SDF brimstone = new SDFCappedCone().setHeight(radius)
          .setRadius1(0)
          .setRadius2(radius)
          .setBlock(LighterEndBlocks.BRIMSTONE);
      brimstone = new SDFTranslate().setTranslate(0, 2F, 0).setSource(brimstone);
      bowl = new SDFSubtract().setSourceA(bowl).setSourceB(brimstone);
      bowl = new SDFUnion().setSourceA(brimstone).setSourceB(bowl);

      SDF water = new SDFCappedCone().setHeight(radius).setRadius1(0).setRadius2(radius)
          .setBlock(class_2246.field_10382);
      water = new SDFTranslate().setTranslate(0, 4, 0).setSource(water);
      bowl = new SDFSubtract().setSourceA(bowl).setSourceB(water);
      bowl = new SDFUnion().setSourceA(water).setSourceB(bowl);

      final OpenSimplexNoise noise1 = new OpenSimplexNoise(random.method_43055());
      final OpenSimplexNoise noise2 = new OpenSimplexNoise(random.method_43055());

      bowl = new SDFCoordsModify().setFunction((vec) -> {
        float dx = (float) noise1.eval(vec.x() * 0.1, vec.y() * 0.1, vec.z() * 0.1);
        float dz = (float) noise2.eval(vec.x() * 0.1, vec.y() * 0.1, vec.z() * 0.1);
        vec.set(vec.x() + dx, vec.y(), vec.z() + dz);
      }).setSource(bowl);

      SDF cut = new SDFFlatland().setBlock(class_2246.field_10124);
      cut = new SDFInvert().setSource(cut);
      cut = new SDFTranslate().setTranslate(0, radius - 2, 0).setSource(cut);
      bowl = new SDFSubtract().setSourceA(bowl).setSourceB(cut);

      bowl = new SDFTranslate().setTranslate(radius, py - radius, 0).setSource(bowl);
      bowl = new SDFRotate().setRotation(class_7833.field_40716, i * 4F).setSource(bowl);
      sdf = new SDFUnion().setSourceA(sdf).setSourceB(bowl);
    }
    sdf.setReplaceFunction(REPLACE2).fillRecursive(world, pos);

    radius2 = radius2 * 0.5F;
    if (radius2 < 0.7F) {
      radius2 = 0.7F;
    }
    final OpenSimplexNoise noise = new OpenSimplexNoise(random.method_43055());

    SDF.Primitive obj1;
    SDF.Primitive obj2;

    obj1 = new SDFCappedCone().setHeight(halfHeight + 5).setRadius1(radius1 * 0.5F)
        .setRadius2(radius2);
    sdf = new SDFTranslate().setTranslate(0, halfHeight - 13, 0).setSource(obj1);
    sdf = new SDFDisplace().setFunction((vec) -> (float) noise.eval(
        vec.x() * 0.3F,
        vec.y() * 0.3F,
        vec.z() * 0.3F
    ) * 0.5F).setSource(sdf);

    obj2 = new SDFSphere().setRadius(radius1);
    SDF cave = new SDFScale3D().setScale(1.5F, 1, 1.5F).setSource(obj2);
    cave = new SDFDisplace().setFunction((vec) -> (float) noise.eval(
        vec.x() * 0.1F,
        vec.y() * 0.1F,
        vec.z() * 0.1F
    ) * 2F).setSource(cave);
    cave = new SDFTranslate().setTranslate(0, -halfHeight - 10, 0).setSource(cave);

    sdf = new SDFSmoothUnion().setRadius(5).setSourceA(cave).setSourceB(sdf);

    obj1.setBlock(class_2246.field_10382);
    obj2.setBlock(class_2246.field_10382);
    sdf.setReplaceFunction(REPLACE2);
    sdf.fillRecursive(world, pos);

    obj1.setBlock(LighterEndBlocks.BRIMSTONE);
    obj2.setBlock(LighterEndBlocks.BRIMSTONE);
    new SDFDisplace().setFunction((vec) -> -2F)
        .setSource(sdf)
        .setReplaceFunction(REPLACE1)
        .fillRecursiveIgnore(world, pos, IGNORE);

    obj1.setBlock(LighterEndBlocks.BORNITE.baseBlock);
    obj2.setBlock(LighterEndBlocks.BORNITE.baseBlock);
    new SDFDisplace().setFunction((vec) -> -4F)
        .setSource(cave)
        .setReplaceFunction(REPLACE1)
        .fillRecursiveIgnore(world, pos, IGNORE);

    obj1.setBlock(class_2246.field_10471);
    obj2.setBlock(class_2246.field_10471);
    new SDFDisplace().setFunction((vec) -> -6F)
        .setSource(cave)
        .setReplaceFunction(REPLACE1)
        .fillRecursiveIgnore(world, pos, IGNORE);

    world.method_8652(pos, class_2246.field_10382.method_9564(), Flags.SILENT);
    class_2339 mut = new class_2339().method_10101(pos);
    count = world.method_8624(field_13202, pos.method_10263(), pos.method_10260()) - pos.method_10264();
    for (int i = 0; i < count; i++) {
      world.method_8652(mut, class_2246.field_10382.method_9564(), Flags.SILENT);
      for (class_2350 dir : class_2350.class_2353.field_11062) {
        world.method_8652(mut.method_10093(dir), class_2246.field_10382.method_9564(), Flags.SILENT);
      }
      mut.method_33098(mut.method_10264() + 1);
    }

    for (int i = 0; i < 150; i++) {
      mut.method_10101(pos)
          .method_10100(
              class_3532.method_15357(random.method_43059() * 4 + 0.5),
              -halfHeight - 10,
              class_3532.method_15357(random.method_43059() * 4 + 0.5)
          );
      float distRaw = (float) Math.sqrt(
          Math.pow(mut.method_10263() - pos.method_10263(), 2) + Math.pow(mut.method_10260() - pos.method_10260(), 2)
      );
      int dist = class_3532.method_15375(6 - distRaw) + random.method_43048(2);
      if (dist >= 0) {
        state = world.method_8320(mut);
        while (
            !state.method_26227().method_15769()
                || state.method_26164(LighterEndTags.AQUATIC_END_VEGETATION)
        ) {
          mut.method_33098(mut.method_10264() - 1);
          state = world.method_8320(mut);
        }
        if (state.method_26164(LighterEndTags.END_STONES) && !world.method_8320(mut.method_10084())
            .method_27852(LighterEndBlocks.HYDROTHERMAL_VENT)) {
          for (int j = 0; j <= dist; j++) {
            world.method_8652(
                mut,
                LighterEndBlocks.BORNITE.baseBlock.method_9564(),
                Flags.SILENT
            );
            for (class_2350 dir : class_2350.class_2353.field_11062.method_43342(random)) {
              class_2338 p = mut.method_10093(dir);
              if (random.method_43056() && world.method_8320(p).method_27852(class_2246.field_10382)) {
                world.method_8652(
                    p,
                    LighterEndBlocks.TUBE_WORM.method_9564().method_11657(TubeWorm.FACING, dir),
                    Flags.SILENT
                );
              }
            }
            mut.method_33098(mut.method_10264() + 1);
          }
          state = LighterEndBlocks.HYDROTHERMAL_VENT.method_9564()
              .method_11657(HydrothermalVent.ACTIVATED, distRaw < 2)
              .method_11657(HydrothermalVent.WATERLOGGED, true);
          world.method_8652(mut, state, Flags.SILENT);
          mut.method_33098(mut.method_10264() + 1);
          state = world.method_8320(mut);
          while (state.method_27852(class_2246.field_10382)) {
            world.method_8652(
                mut,
                LighterEndBlocks.VENT_BUBBLE_COLUMN.method_9564(),
                Flags.SILENT
            );
            mut.method_33098(mut.method_10264() + 1);
            state = world.method_8320(mut);
          }
        }
      }
    }

    for (int i = 0; i < 10; i++) {
      mut.method_10101(pos)
          .method_10100(
              class_3532.method_15357(random.method_43059() * 0.7 + 0.5),
              -halfHeight - 10,
              class_3532.method_15357(random.method_43059() * 0.7 + 0.5)
          );
      float distRaw = (float) Math.sqrt(
          Math.pow(mut.method_10263() - pos.method_10263(), 2) + Math.pow(mut.method_10260() - pos.method_10260(), 2)
      );
      int dist = class_3532.method_15375(6 - distRaw) + random.method_43048(2);
      if (dist >= 0) {
        state = world.method_8320(mut);
        while (state.method_27852(class_2246.field_10382)) {
          mut.method_33098(mut.method_10264() - 1);
          state = world.method_8320(mut);
        }
        if (state.method_26164(LighterEndTags.END_STONES)) {
          for (int j = 0; j <= dist; j++) {
            world.method_8652(
                mut,
                LighterEndBlocks.BORNITE.baseBlock.method_9564(),
                Flags.SILENT
            );
            mut.method_33098(mut.method_10264() + 1);
          }
          state = LighterEndBlocks.HYDROTHERMAL_VENT.method_9564()
              .method_11657(HydrothermalVent.ACTIVATED, distRaw < 2)
              .method_11657(HydrothermalVent.WATERLOGGED, true);
          world.method_8652(mut, state, Flags.SILENT);
          mut.method_33098(mut.method_10264() + 1);
          state = world.method_8320(mut);
          while (state.method_27852(class_2246.field_10382)) {
            world.method_8652(
                mut,
                LighterEndBlocks.VENT_BUBBLE_COLUMN.method_9564(),
                Flags.SILENT
            );
            mut.method_33098(mut.method_10264() + 1);
            state = world.method_8320(mut);
          }
        }
      }
    }

    class_5821<class_3111> featureContext = new class_5821<>(
        null,
        world,
        chunkGenerator,
        random,
        pos,
        new class_3111()
    );
    (new SulphurLake()).method_13151(featureContext);

    double distance = radius1 * 1.7;
    class_2338 start = pos.method_10069((int) -distance, (int) (-halfHeight - 15 - distance), (int) -distance);
    class_2338 end = pos.method_10069((int) distance, (int) (-halfHeight - 5 + distance), (int) distance);
    BlockFixer.fixBlocks(world, start, end);

    return true;
  }

  static {
    REPLACE1 = (state) -> state.method_26215() || (state.method_26164(LighterEndTags.END_STONES));

    REPLACE2 = (state) -> {
      if (state.method_26164(LighterEndTags.END_STONES) || state.method_27852(LighterEndBlocks.HYDROTHERMAL_VENT)
          || state.method_27852(LighterEndBlocks.SULPHUR_CRYSTAL)) {
        return true;
      }
      return MiscUtils.replaceableOrPlant(state);
    };

    IGNORE = (state) -> state.method_27852(class_2246.field_10382)
        || state.method_27852(class_2246.field_10543)
        || state.method_27852(LighterEndBlocks.BORNITE.baseBlock)
        || state.method_27852(LighterEndBlocks.BRIMSTONE);
  }

}
