package io.github.openbagtwo.lighterend.world.features;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.openbagtwo.lighterend.blocks.Polypore;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.utils.Flags;
import io.github.openbagtwo.lighterend.utils.PosInfo;
import io.github.openbagtwo.lighterend.world.features.PurplePolypores.Config;
import net.minecraft.class_2338;
import net.minecraft.class_2338.class_2339;
import net.minecraft.class_2350;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class PurplePolypores extends class_3031<Config> {

  public PurplePolypores() {
    super(Config.CODEC);
  }

  @Override
  public boolean method_13151(class_5821<Config> featureConfig) {
    Config cfg = featureConfig.method_33656();
    final class_5819 random = featureConfig.method_33654();
    final class_2338 center = featureConfig.method_33655();
    final class_5281 world = featureConfig.method_33652();
    int maxY = world.method_8624(class_2902.class_2903.field_13202, center.method_10263(), center.method_10260());
    int minY = PosInfo.upRay(world, new class_2338(center.method_10263(), 0, center.method_10260()), maxY);
    if (maxY < 10 || maxY < minY) {
      return false;
    }
    int py = class_3532.method_15395(random, minY, maxY);

    class_2339 mut = new class_2339();
    for (int x = -cfg.radius; x <= cfg.radius; x++) {
      mut.method_33097(center.method_10263() + x);
      for (int y = -cfg.radius; y <= cfg.radius; y++) {
        mut.method_33098(py + y);
        for (int z = -cfg.radius; z <= cfg.radius; z++) {
          mut.method_33099(center.method_10260() + z);
          if (random.method_43048(4) == 0 && world.method_22347(mut)) {
            for (class_2350 dir : class_2350.class_2353.field_11062.method_43342(random)) {
              if (world.method_8320(mut.method_10093(dir.method_10153())).method_26164(class_3481.field_15475)) {
                world.method_8652(
                    mut,
                    LighterEndBlocks.PURPLE_POLYPORE.method_9564().method_11657(Polypore.FACING, dir),
                    Flags.SILENT
                );
                break;
              }
            }
          }
        }
      }
    }
    return true;
  }

  public static class Config implements class_3037 {

    public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance
        .group(
            Codec.INT.fieldOf("radius").forGetter(o -> o.radius)
        )
        .apply(instance, Config::new));

    public final int radius;

    public Config(int radius) {
      this.radius = radius;
    }
  }

}
