package io.github.openbagtwo.lighterend.world.features;

import static net.minecraft.class_2902.class_2903;

import com.google.common.collect.Sets;
import io.github.openbagtwo.lighterend.blocks.Brimstone;
import io.github.openbagtwo.lighterend.blocks.SulphurCrystal;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import io.github.openbagtwo.lighterend.utils.Flags;
import io.github.openbagtwo.lighterend.utils.GlobalState;
import io.github.openbagtwo.lighterend.world.gen.noise.OpenSimplexNoise;
import java.util.Set;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2338.class_2339;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2902.class_2903;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3532;
import net.minecraft.class_3612;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class SulphurLake extends class_3031<class_3111> {

  private static final OpenSimplexNoise NOISE = new OpenSimplexNoise(15152);

  public SulphurLake() {
    super(class_3111.field_24893);
  }

  @Override
  public boolean method_13151(class_5821<class_3111> context) {
    class_2338 blockPos = context.method_33655();
    final class_5281 world = context.method_33652();
    blockPos = world.method_8598(class_2903.field_13194, blockPos);

    if (blockPos.method_10264() < 57) {
      return false;
    }

    final class_5819 random = context.method_33654();
    final class_2339 POS = GlobalState.stateForThread().POS;
    double radius = class_3532.method_15366(random, 10., 20.);
    int dist2 = class_3532.method_15357(radius * 1.5);

    int minX = blockPos.method_10263() - dist2;
    int maxX = blockPos.method_10263() + dist2;
    int minZ = blockPos.method_10260() - dist2;
    int maxZ = blockPos.method_10260() + dist2;

    Set<class_2338> brimstone = Sets.newHashSet();
    for (int x = minX; x <= maxX; x++) {
      POS.method_33097(x);
      int x2 = x - blockPos.method_10263();
      x2 *= x2;
      for (int z = minZ; z <= maxZ; z++) {
        POS.method_33099(z);
        int z2 = z - blockPos.method_10260();
        z2 *= z2;
        double r = radius * (NOISE.eval(x * 0.2, z * 0.2) * 0.25 + 0.75);
        double r2 = r * 1.5;
        r *= r;
        r2 *= r2;
        int dist = x2 + z2;
        if (dist <= r) {
          POS.method_33098(world.method_8624(class_2903.field_13194, x, z) - 1);
          if (world.method_8320(POS).method_26164(LighterEndTags.END_STONES)) {
            if (isBorder(world, POS)) {
              if (random.method_43048(8) > 0) {
                brimstone.add(POS.method_10062());
                if (random.method_43056()) {
                  brimstone.add(POS.method_10074());
                  if (random.method_43056()) {
                    brimstone.add(POS.method_10087(2));
                  }
                }
              } else {
                if (!isAbsoluteBorder(world, POS)) {
                  world.method_8652(POS, class_2246.field_10382.method_9564(), Flags.SILENT);

                  world.method_64312(POS, class_3612.field_15910, 0);
                  brimstone.add(POS.method_10074());
                  if (random.method_43056()) {
                    brimstone.add(POS.method_10087(2));
                    if (random.method_43056()) {
                      brimstone.add(POS.method_10087(3));
                    }
                  }
                } else {
                  brimstone.add(POS.method_10062());
                  if (random.method_43056()) {
                    brimstone.add(POS.method_10074());
                  }
                }
              }
            } else {
              world.method_8652(POS, class_2246.field_10382.method_9564(), Flags.SILENT);
              brimstone.remove(POS);
              for (class_2350 dir : class_2350.class_2353.field_11062) {
                class_2338 offsetted = POS.method_10093(dir);
                if (world.method_8320(offsetted).method_26164(LighterEndTags.END_STONES)) {
                  brimstone.add(offsetted);
                }
              }
              if (isDeepWater(world, POS)) {
                world.method_8652(POS.method_10098(class_2350.field_11033), class_2246.field_10382.method_9564(),
                    Flags.SILENT);
                brimstone.remove(POS);
                for (class_2350 dir : class_2350.class_2353.field_11062) {
                  class_2338 offseted = POS.method_10093(dir);
                  if (world.method_8320(offseted).method_26164(LighterEndTags.END_STONES)) {
                    brimstone.add(offseted);
                  }
                }
              }
              brimstone.add(POS.method_10074());
              if (random.method_43056()) {
                brimstone.add(POS.method_10087(2));
                if (random.method_43056()) {
                  brimstone.add(POS.method_10087(3));
                }
              }
            }
          }
        } else if (dist < r2) {
          POS.method_33098(world.method_8624(class_2903.field_13194, x, z) - 1);
          if (world.method_8320(POS).method_26164(LighterEndTags.END_STONES)) {
            brimstone.add(POS.method_10062());
            if (random.method_43056()) {
              brimstone.add(POS.method_10074());
              if (random.method_43056()) {
                brimstone.add(POS.method_10087(2));
              }
            }
          }
        }
      }
    }

    brimstone.forEach((bpos) -> {
      placeBrimstone(world, bpos, random);
    });

    return true;
  }

  protected static boolean isBorder(class_5281 world, class_2338 pos) {
    int y = pos.method_10264() + 1;
    for (class_2350 dir : class_2350.values()) {
      if (world.method_8624(
          class_2903.field_13194,
          pos.method_10263() + dir.method_10148(),
          pos.method_10260() + dir.method_10165()
      ) < y) {
        return true;
      }
    }
    return false;
  }

  protected static boolean isAbsoluteBorder(class_5281 world, class_2338 pos) {
    int y = pos.method_10264() - 2;
    for (class_2350 dir : class_2350.values()) {
      if (world.method_8624(
          class_2903.field_13194,
          pos.method_10263() + dir.method_10148() * 3,
          pos.method_10260() + dir.method_10165() * 3
      ) < y) {
        return true;
      }
    }
    return false;
  }

  protected static boolean isDeepWater(class_5281 world, class_2338 pos) {
    int y = pos.method_10264() + 1;
    for (class_2350 dir : class_2350.values()) {
      if (world.method_8624(
          class_2903.field_13194,
          pos.method_10263() + dir.method_10148(),
          pos.method_10260() + dir.method_10165()
      ) < y
          || world.method_8624(
          class_2903.field_13194,
          pos.method_10263() + dir.method_10148() * 2,
          pos.method_10260() + dir.method_10165() * 2
      ) < y || world.method_8624(
          class_2903.field_13194,
          pos.method_10263() + dir.method_10148() * 3,
          pos.method_10260() + dir.method_10165() * 3
      ) < y) {
        return false;
      }
    }
    return true;
  }

  protected static void placeBrimstone(class_5281 world, class_2338 pos, class_5819 random) {
    class_2680 state = getBrimstone(world, pos);
    world.method_8652(pos, state, Flags.SILENT);
    if (state.method_11654(Brimstone.ACTIVATED)) {
      makeShards(world, pos, random);
    }
  }

  protected static class_2680 getBrimstone(class_5281 world, class_2338 pos) {
    for (class_2350 dir : class_2350.values()) {
      if (world.method_8320(pos.method_10093(dir)).method_27852(class_2246.field_10382)) {
        return LighterEndBlocks.BRIMSTONE.method_9564().method_11657(Brimstone.ACTIVATED, true);
      }
    }
    return LighterEndBlocks.BRIMSTONE.method_9564();
  }

  protected static void makeShards(class_5281 world, class_2338 pos, class_5819 random) {
    for (class_2350 dir : class_2350.values()) {
      class_2338 side;
      if (random.method_43048(16) == 0 && world.method_8320((side = pos.method_10093(dir)))
          .method_27852(class_2246.field_10382)) {
        class_2680 state = LighterEndBlocks.SULPHUR_CRYSTAL.method_9564()
            .method_11657(SulphurCrystal.WATERLOGGED, true)
            .method_11657(SulphurCrystal.FACING, dir)
            .method_11657(SulphurCrystal.STAGE, random.method_43048(3));
        world.method_8652(side, state, Flags.SILENT);
      }
    }
  }
}
