package io.github.openbagtwo.lighterend.world.features;

import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import io.github.openbagtwo.lighterend.utils.math.MathUtils;
import io.github.openbagtwo.lighterend.utils.math.sdf.SDF;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFCoordsModify;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFDisplace;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFRotate;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFUnion;
import io.github.openbagtwo.lighterend.utils.math.sdf.primitives.SDFTorus;
import io.github.openbagtwo.lighterend.world.gen.noise.OpenSimplexNoise;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2902.class_2903;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_7833;

public class UmbralithArch extends class_3031<class_3111> {

  public UmbralithArch() {
    super(class_3111.field_24893);
  }

  @Override
  public boolean method_13151(class_5821<class_3111> featurePlaceContext) {
    final class_5281 world = featurePlaceContext.method_33652();
    class_2338 origin = featurePlaceContext.method_33655();
    class_5819 random = featurePlaceContext.method_33654();

    class_2338 pos = world.method_8598(class_2903.field_13194,
        new class_2338((origin.method_10263() & 0xFFFFFFF0) | 7, 0, (origin.method_10260() & 0xFFFFFFF0) | 7));

    if (!world.method_8320(pos.method_10087(5)).method_26164(LighterEndTags.END_STONES)) {
      return false;
    }

    float bigRadius = class_3532.method_15344(random, 10F, 20F);
    float smallRadius = class_3532.method_15344(random, 3F, 7F);
    if (smallRadius + bigRadius > 23) {
      smallRadius = 23 - bigRadius;
    }
    SDF arch = new SDFTorus().setBigRadius(bigRadius).setSmallRadius(smallRadius)
        .setBlock(LighterEndBlocks.UMBRALITH.baseBlock);
    arch = new SDFRotate()
        .setRotation(MathUtils.randomHorizontal(random), (float) Math.PI * 0.5F)
        .setSource(arch);

    final float smallRadiusF = smallRadius;
    OpenSimplexNoise noise = new OpenSimplexNoise(random.method_43055());
    arch = new SDFDisplace().setFunction((vec) -> (float) (Math.abs(noise.eval(
        vec.x() * 0.1,
        vec.y() * 0.1,
        vec.z() * 0.1
    )) * 3F + Math.abs(noise.eval(
        vec.x() * 0.3,
        vec.y() * 0.3 + 100,
        vec.z() * 0.3
    )) * 1.3F) - smallRadiusF * Math.abs(1 - vec.y() / bigRadius)).setSource(arch);

    arch.addPostProcess((info) -> {
      if (info.getStateUp().method_26215()) {
        return LighterEndBlocks.UMBRALITH.baseBlock.method_9564();
      }
      return info.getState();
    });

    float side = (bigRadius + smallRadius + 3F) * 2;
    if (side > 47) {
      side = 47;
    }
    arch.fillArea(world, pos, class_238.method_30048(class_243.method_24953(pos), side, side, side));

    return true;
  }

  public static class Thin extends class_3031<class_3111> {

    public Thin() {
      super(class_3111.field_24893);
    }

    @Override
    public boolean method_13151(class_5821<class_3111> featurePlaceContext) {
      final class_5281 world = featurePlaceContext.method_33652();
      class_2338 origin = featurePlaceContext.method_33655();
      class_5819 random = featurePlaceContext.method_33654();

      class_2338 pos = world.method_8598(class_2903.field_13194,
          new class_2338((origin.method_10263() & 0xFFFFFFF0) | 7, 0, (origin.method_10260() & 0xFFFFFFF0) | 7));

      if (!world.method_8320(pos.method_10087(5)).method_26164(LighterEndTags.END_STONES)) {
        return false;
      }

      SDF sdf = null;
      float bigRadius = class_3532.method_15344(random, 15F, 20F);
      float variation = bigRadius * 0.3F;
      int count = class_3532.method_15395(random, 2, 4);

      for (int i = 0; i < count; i++) {
        float smallRadius = class_3532.method_15344(random, 0.6F, 1.3F);
        SDF arch = new SDFTorus().setBigRadius(bigRadius - random.method_43057() * variation)
            .setSmallRadius(smallRadius)
            .setBlock(LighterEndBlocks.UMBRALITH.baseBlock);
        float angle =
            (i - count * 0.5F) * 0.3F + random.method_43057() * 0.05F + (float) Math.PI * 0.5F;
        arch = new SDFRotate().setRotation(class_7833.field_40714, angle).setSource(arch);
        sdf = sdf == null ? arch : new SDFUnion().setSourceA(sdf).setSourceB(arch);
      }

      sdf = new SDFRotate().setRotation(MathUtils.randomHorizontal(random),
              random.method_43057() * MathUtils.PI2)
          .setSource(sdf);

      OpenSimplexNoise noise = new OpenSimplexNoise(random.method_43055());
      sdf = new SDFCoordsModify().setFunction(vec -> {
        float dx = (float) noise.eval(vec.y() * 0.02, vec.z() * 0.02);
        float dy = (float) noise.eval(vec.x() * 0.02, vec.z() * 0.02);
        float dz = (float) noise.eval(vec.x() * 0.02, vec.y() * 0.02);
        vec.add(dx * 10, dy * 10, dz * 10);
      }).setSource(sdf);
      sdf = new SDFDisplace().setFunction(vec -> {
        float offset = vec.y() / bigRadius - 0.5F;
        return class_3532.method_15363(offset * 3, -10F, 0F);
      }).setSource(sdf);

      float side = (bigRadius + 2.5F) * 2;
      if (side > 47) {
        side = 47;
      }
      sdf.fillArea(world, pos, class_238.method_30048(class_243.method_24953(pos), side, side, side));
      return true;
    }
  }
}
