package io.github.openbagtwo.lighterend.world.features.trees;

import com.google.common.collect.Lists;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import io.github.openbagtwo.lighterend.utils.Flags;
import io.github.openbagtwo.lighterend.utils.MiscUtils;
import io.github.openbagtwo.lighterend.utils.math.MathUtils;
import io.github.openbagtwo.lighterend.utils.math.sdf.SDF;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFDisplace;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFScale;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFScale3D;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFSubtract;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFTranslate;
import io.github.openbagtwo.lighterend.utils.math.sdf.primitives.SDFSphere;
import io.github.openbagtwo.lighterend.world.gen.noise.OpenSimplexNoise;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2338;
import net.minecraft.class_2338.class_2339;
import net.minecraft.class_2350;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.joml.Vector3f;

public class TenaneaTree extends class_3031<class_3111> {

  private static final Function<class_2680, Boolean> REPLACE;
  private static final Function<class_2680, Boolean> IGNORE;
  private static final List<Vector3f> SPLINE;

  public TenaneaTree() {
    super(class_3111.field_24893);
  }

  @Override
  public boolean method_13151(class_5821<class_3111> featureConfig) {

    final class_5819 random = featureConfig.method_33654();
    final class_2338 pos = featureConfig.method_33655();
    final class_5281 world = featureConfig.method_33652();

    if (!world.method_8320(pos.method_10074()).method_26164(LighterEndTags.END_SOIL)) {
      return false;
    }

    float size = class_3532.method_15395(random, 7, 10);
    int count = (int) (size * 0.45F);
    float var = MathUtils.PI2 / (float) (count * 3);
    float start = class_3532.method_15344(random, 0, MathUtils.PI2);
    for (int i = 0; i < count; i++) {
      float angle =
          (float) i / (float) count * MathUtils.PI2 + class_3532.method_15344(random, 0, var) + start;
      List<Vector3f> spline = MathUtils.copySpline(SPLINE);
      MathUtils.rotateSpline(spline, angle);
      MathUtils.scale(spline, size + class_3532.method_15344(random, 0, size * 0.5F));
      MathUtils.offsetParts(spline, random, 1F, 0, 1F);
      MathUtils.fillSpline(spline, world, LighterEndBlocks.TENANEA.wood.method_9564(),
          pos,
          REPLACE);
      Vector3f last = spline.getLast();
      float leavesRadius = (size * 0.3F + class_3532.method_15344(random, 0.8F, 1.5F)) * 1.4F;
      OpenSimplexNoise noise = new OpenSimplexNoise(random.method_43055());
      leavesBall(world, pos.method_10069((int) last.x(), (int) last.y(), (int) last.z()), leavesRadius,
          random, noise);
    }

    return true;
  }

  private void leavesBall(
      class_5281 world,
      class_2338 pos,
      float radius,
      class_5819 random,
      OpenSimplexNoise noise
  ) {
    SDF sphere = new SDFSphere().setRadius(radius)
        .setBlock(LighterEndBlocks.TENANEA_LEAVES.method_9564()
            .method_11657(class_2397.field_11199, 6));
    SDF sub = new SDFScale().setScale(5).setSource(sphere);
    sub = new SDFTranslate().setTranslate(0, -radius * 5, 0).setSource(sub);
    sphere = new SDFSubtract().setSourceA(sphere).setSourceB(sub);
    sphere = new SDFScale3D().setScale(1, 0.75F, 1).setSource(sphere);
    sphere = new SDFDisplace().setFunction((vec) -> (float) noise.eval(
        vec.x() * 0.2,
        vec.y() * 0.2,
        vec.z() * 0.2
    ) * 2F).setSource(sphere);
    sphere = new SDFDisplace().setFunction((vec) -> class_3532.method_15344(random, -1.5F, 1.5F))
        .setSource(sphere);

    class_2339 mut = new class_2339();
    for (class_2350 d1 : class_2350.class_2353.field_11062) {
      class_2338 p = mut.method_10101(pos).method_10098(class_2350.field_11036).method_10098(d1).method_10062();
      world.method_8652(p, LighterEndBlocks.TENANEA.wood.method_9564(), Flags.SILENT);
      for (class_2350 d2 : class_2350.class_2353.field_11062) {
        mut.method_10101(p).method_10098(class_2350.field_11036).method_10098(d2);
        world.method_8652(p, LighterEndBlocks.TENANEA.wood.method_9564(), Flags.SILENT);
      }
    }

    class_2680 top = LighterEndBlocks.TENANEA_FLOWER.method_9564()
        .method_11657(class_2741.field_54794, false);
    class_2680 middle = LighterEndBlocks.TENANEA_FLOWER.method_9564()
        .method_11657(class_2741.field_54794, false);
    class_2680 bottom = LighterEndBlocks.TENANEA_FLOWER.method_9564()
        .method_11657(class_2741.field_54794, true);

    List<class_2338> support = Lists.newArrayList();
    sphere.addPostProcess((info) -> {
      if (random.method_43048(6) == 0 && info.getStateDown().method_26215()) {
        class_2338 d = info.getPos().method_10074();
        support.add(d);
      }
      if (random.method_43048(5) == 0) {
        for (class_2350 dir : class_2350.values()) {
          class_2680 state = info.getState(dir, 2);
          if (state.method_26215()) {
            return info.getState();
          }
        }
        info.setState(LighterEndBlocks.TENANEA.wood.method_9564());
      }

      if (Arrays.asList(LighterEndBlocks.TENANEA.log, LighterEndBlocks.TENANEA.wood)
          .contains(info.getState().method_26204())) {
        for (int x = -6; x < 7; x++) {
          int ax = Math.abs(x);
          mut.method_33097(x + info.getPos().method_10263());
          for (int z = -6; z < 7; z++) {
            int az = Math.abs(z);
            mut.method_33099(z + info.getPos().method_10260());
            for (int y = -6; y < 7; y++) {
              int ay = Math.abs(y);
              int d = ax + ay + az;
              if (d < 7) {
                mut.method_33098(y + info.getPos().method_10264());
                class_2680 state = info.getState(mut);
                if (state.method_26204() instanceof class_2397) {
                  int distance = state.method_11654(class_2397.field_11199);
                  if (d < distance) {
                    info.setState(mut, state.method_11657(class_2397.field_11199, d));
                  }
                }
              }
            }
          }
        }
      }
      return info.getState();
    });
    sphere.fillRecursiveIgnore(world, pos, IGNORE);
    world.method_8652(pos, LighterEndBlocks.TENANEA.wood.method_9564(), Flags.SILENT);

    support.forEach((bpos) -> {
      class_2680 state = world.method_8320(bpos);
      if (state.method_26215()) {
        int count = class_3532.method_15395(random, 3, 8);
        mut.method_10101(bpos);
        if (world.method_8320(mut.method_10084()).method_27852(LighterEndBlocks.TENANEA_LEAVES)) {
          world.method_8652(mut, top, Flags.SILENT);
          for (int i = 1; i < count; i++) {
            mut.method_33098(mut.method_10264() - 1);
            if (world.method_22347(mut.method_10074())) {
              world.method_8652(mut, middle, Flags.SILENT);
            } else {
              break;
            }
          }
          world.method_8652(mut, bottom, Flags.SILENT);
        }
      }
    });
  }

  static {
    REPLACE = (state) -> {
      if (state.method_26204() == LighterEndBlocks.TENANEA_LEAVES) {
        return true;
      }
      return MiscUtils.replaceableOrPlant(state);
    };

    IGNORE = (state) -> Arrays.asList(LighterEndBlocks.TENANEA.log, LighterEndBlocks.TENANEA.wood)
        .contains(state.method_26204());

    SPLINE = Lists.newArrayList(
        new Vector3f(0.00F, 0.00F, 0.00F),
        new Vector3f(0.10F, 0.35F, 0.00F),
        new Vector3f(0.20F, 0.50F, 0.00F),
        new Vector3f(0.30F, 0.55F, 0.00F),
        new Vector3f(0.42F, 0.70F, 0.00F),
        new Vector3f(0.50F, 1.00F, 0.00F)
    );
  }
}
