package io.github.openbagtwo.lighterend.world.features.trees;

import com.google.common.collect.Lists;
import io.github.openbagtwo.lighterend.blocks.UmbrellaMembrane;
import io.github.openbagtwo.lighterend.blocks.UmbrellaTreeCluster;
import io.github.openbagtwo.lighterend.registries.LighterEndBlocks;
import io.github.openbagtwo.lighterend.registries.LighterEndTags;
import io.github.openbagtwo.lighterend.utils.Flags;
import io.github.openbagtwo.lighterend.utils.MiscUtils;
import io.github.openbagtwo.lighterend.utils.math.MathUtils;
import io.github.openbagtwo.lighterend.utils.math.sdf.SDF;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFFlatWave;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFScale;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFScale3D;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFSmoothUnion;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFSubtract;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFTranslate;
import io.github.openbagtwo.lighterend.utils.math.sdf.operators.SDFUnion;
import io.github.openbagtwo.lighterend.utils.math.sdf.primitives.SDFSphere;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2338;
import net.minecraft.class_2338.class_2339;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.joml.Vector3f;

public class UmbrellaTree extends class_3031<class_3111> {

  private static final Function<class_2680, Boolean> REPLACE;
  private static final List<Vector3f> SPLINE;
  private static final List<Vector3f> ROOT;

  public UmbrellaTree() {
    super(class_3111.field_24893);
  }

  @Override
  public boolean method_13151(class_5821<class_3111> featureConfig) {
    final class_5819 random = featureConfig.method_33654();
    final class_2338 pos = featureConfig.method_33655();
    final class_5281 world = featureConfig.method_33652();
    final class_3111 config = featureConfig.method_33656();
    if (!world.method_8320(pos.method_10074()).method_26164(LighterEndTags.END_SOIL)) {
      return false;
    }

    class_2680 wood = LighterEndBlocks.UMBRELLA.wood.method_9564();
    class_2680 membrane = LighterEndBlocks.UMBRELLA_MEMBRANE.method_9564()
        .method_11657(UmbrellaMembrane.COLOR, 1);
    class_2680 center = LighterEndBlocks.UMBRELLA_MEMBRANE.method_9564()
        .method_11657(UmbrellaMembrane.COLOR, 0);
    class_2680 fruit = LighterEndBlocks.UMBRELLA_TREE_CLUSTER.method_9564()
        .method_11657(UmbrellaTreeCluster.NATURAL, true);

    float size = class_3532.method_15344(random, 10, 20);
    int count = (int) (size * 0.15F);
    float var = MathUtils.PI2 / (float) (count * 3);
    float start = class_3532.method_15344(random, 0, MathUtils.PI2);
    SDF sdf = null;
    List<Center> centers = Lists.newArrayList();

    float scale = 1;
    if (config != null) {
      scale = class_3532.method_15344(random, 1F, 1.7F);
    }

    for (int i = 0; i < count; i++) {
      float angle =
          (float) i / (float) count * MathUtils.PI2 + class_3532.method_15344(random, 0, var) + start;
      List<Vector3f> spline = MathUtils.copySpline(SPLINE);
      float sizeXZ = size + class_3532.method_15344(random, 0, size * 0.5F) * 0.7F;
      MathUtils.scale(spline, sizeXZ, sizeXZ * class_3532.method_15344(random, 1F, 2F), sizeXZ);
      MathUtils.rotateSpline(spline, angle);
      MathUtils.offsetParts(spline, random, 0.5F, 0, 0.5F);

      if (MathUtils.canGenerate(spline, pos, world, REPLACE)) {
        float rScale = (scale - 1) * 0.4F + 1;
        SDF branch = MathUtils.buildSDF(spline, 1.2F * rScale, 0.8F * rScale, (bpos) -> wood);

        Vector3f vec = spline.get(spline.size() - 1);
        float radius = size + class_3532.method_15344(random, 0, size * 0.5F) * 0.4F;

        sdf = (sdf == null) ? branch : new SDFUnion().setSourceA(sdf).setSourceB(branch);
        SDF mem = makeMembrane(radius, random, membrane, center);

        float px = class_3532.method_15375(vec.x()) + 0.5F;
        float py = class_3532.method_15375(vec.y()) + 0.5F;
        float pz = class_3532.method_15375(vec.z()) + 0.5F;
        mem = new SDFTranslate().setTranslate(px, py, pz).setSource(mem);
        sdf = new SDFSmoothUnion().setRadius(2).setSourceA(sdf).setSourceB(mem);
        centers.add(new Center(
            pos.method_10263() + (double) (px * scale),
            pos.method_10264() + (double) (py * scale),
            pos.method_10260() + (double) (pz * scale),
            radius * scale
        ));
      }
    }

    if (sdf == null) {
      return false;
    }

    if (scale > 1) {
      sdf = new SDFScale().setScale(scale).setSource(sdf);
    }

    sdf.setReplaceFunction(REPLACE).addPostProcess((info) -> {
      if (
          Arrays.asList(LighterEndBlocks.UMBRELLA.wood, LighterEndBlocks.UMBRELLA.log)
              .contains(info.getStateUp().method_26204())
              && Arrays.asList(LighterEndBlocks.UMBRELLA.wood, LighterEndBlocks.UMBRELLA.log)
              .contains(info.getStateDown().method_26204())
      ) {
        return LighterEndBlocks.UMBRELLA.log.method_9564();
      } else if (info.getState().equals(membrane)) {
        Center min = centers.get(0);
        double d = Double.MAX_VALUE;
        class_2338 bpos = info.getPos();
        for (Center c : centers) {
          double d2 = c.distance(bpos.method_10263(), bpos.method_10260());
          if (d2 < d) {
            d = d2;
            min = c;
          }
        }
        int color = class_3532.method_15357(d / min.radius * 7);
        color = class_3532.method_15340(color, 1, 7);
        return info.getState().method_11657(UmbrellaMembrane.COLOR, color);
      }
      return info.getState();
    }).fillRecursive(world, pos);
    makeRoots(world, pos, (size * 0.5F + 3) * scale, random, wood);

    for (Center c : centers) {
      if (!world.method_8320(new class_2338((int) c.px, (int) c.py, (int) c.pz)).method_26215()) {
        count = class_3532.method_15375(class_3532.method_15344(random, 5F, 10F) * scale);
        float startAngle = random.method_43057() * MathUtils.PI2;
        for (int i = 0; i < count; i++) {
          float angle = (float) i / count * MathUtils.PI2 + startAngle;
          float dist = class_3532.method_15344(random, 1.5F, 2.5F) * scale;
          double px = c.px + Math.sin(angle) * dist;
          double pz = c.pz + Math.cos(angle) * dist;
          makeFruits(world, px, c.py - 1, pz, fruit);
        }
      }
    }

    return true;
  }

  private void makeRoots(class_5281 world, class_2338 pos, float radius, class_5819 random,
      class_2680 wood) {
    int count = (int) (radius * 1.5F);
    for (int i = 0; i < count; i++) {
      float angle = (float) i / (float) count * MathUtils.PI2;
      float scale = radius * class_3532.method_15344(random, 0.85F, 1.15F);

      List<Vector3f> branch = MathUtils.copySpline(ROOT);
      MathUtils.rotateSpline(branch, angle);
      MathUtils.scale(branch, scale);
      Vector3f last = branch.get(branch.size() - 1);
      if (world.method_8320(pos.method_10069((int) last.x(), (int) last.y(), (int) last.z()))
          .method_26164(LighterEndTags.END_STONES)) {
        MathUtils.fillSplineForce(branch, world, wood, pos, REPLACE);
      }
    }
  }

  private SDF makeMembrane(
      float radius,
      class_5819 random,
      class_2680 membrane,
      class_2680 center
  ) {
    SDF sphere = new SDFSphere().setRadius(radius).setBlock(membrane);
    SDF sub = new SDFTranslate().setTranslate(0, -4, 0).setSource(sphere);
    sphere = new SDFSubtract().setSourceA(sphere).setSourceB(sub);
    sphere = new SDFScale3D().setScale(1, 0.5F, 1).setSource(sphere);
    sphere = new SDFTranslate().setTranslate(0, 1 - radius * 0.5F, 0).setSource(sphere);

    float angle = random.method_43057() * MathUtils.PI2;
    int count = (int) class_3532.method_15344(random, radius, radius * 2);
    if (count < 5) {
      count = 5;
    }
    sphere = new SDFFlatWave().setAngle(angle).setRaysCount(count).setIntensity(0.6F)
        .setSource(sphere);

    SDF cent = new SDFSphere().setRadius(2.5F).setBlock(center);
    sphere = new SDFUnion().setSourceA(sphere).setSourceB(cent);

    return sphere;
  }

  private void makeFruits(class_5281 world, double px, double py, double pz,
      class_2680 fruit) {
    class_2339 mut = new class_2339().method_10102(px, py, pz);
    for (int i = 0; i < 8; i++) {
      mut.method_10098(class_2350.field_11033);
      if (world.method_22347(mut)) {
        class_2680 state = world.method_8320(mut.method_10084());
        if (state.method_27852(LighterEndBlocks.UMBRELLA_MEMBRANE)
            && state.method_11654(UmbrellaMembrane.COLOR) < 2) {
          world.method_8652(mut, fruit, Flags.SILENT);
        }
        break;
      }
    }
  }

  static {
    SPLINE = Lists.newArrayList(
        new Vector3f(0.00F, 0.00F, 0.00F),
        new Vector3f(0.10F, 0.35F, 0.00F),
        new Vector3f(0.20F, 0.50F, 0.00F),
        new Vector3f(0.30F, 0.55F, 0.00F),
        new Vector3f(0.42F, 0.70F, 0.00F),
        new Vector3f(0.50F, 1.00F, 0.00F)
    );

    ROOT = Lists.newArrayList(
        new Vector3f(0.1F, 0.70F, 0),
        new Vector3f(0.3F, 0.30F, 0),
        new Vector3f(0.7F, 0.05F, 0),
        new Vector3f(0.8F, -0.20F, 0)
    );
    MathUtils.offset(ROOT, new Vector3f(0, -0.45F, 0));

    REPLACE = (state) -> {
      if (state.method_27852(LighterEndBlocks.UMBRELLA_MEMBRANE)) {
        return true;
      }
      return MiscUtils.replaceableOrPlant(state);
    };
  }

  private static class Center {

    final double px;
    final double py;
    final double pz;
    final float radius;

    Center(double x, double y, double z, float radius) {
      this.px = x;
      this.py = y;
      this.pz = z;
      this.radius = radius;
    }

    double distance(float x, float z) {
      return Math.sqrt(Math.pow(px - x, 2) + Math.pow(pz - z, 2));
    }
  }
}
