package io.github.openbagtwo.lighterend.world.structures;

import com.mojang.serialization.MapCodec;
import io.github.openbagtwo.lighterend.registries.LighterEndStructures;
import io.github.openbagtwo.lighterend.world.structures.pieces.LakePiece;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2902.class_2903;
import net.minecraft.class_3195;
import net.minecraft.class_3532;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6626;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7151;

public class Megalake extends class_3195 {

  public static final MapCodec<Megalake> CODEC = method_42699(Megalake::new);


  public Megalake(class_3195.class_7302 structureSettings) {
    super(structureSettings);
  }

  @Override
  public class_7151<Megalake> method_41618() {
    return LighterEndStructures.MEGALAKE;
  }

  protected void generatePieces(class_6626 structurePiecesBuilder,
      class_3195.class_7149 context) {
    final class_5819 random = context.comp_566();
    final class_1923 chunkPos = context.comp_568();
    final class_2794 chunkGenerator = context.comp_562();
    final class_7138 rState = context.comp_564();

    final class_5539 levelHeightAccessor = context.comp_569();

    int x = chunkPos.method_33939(class_3532.method_15395(random, 4, 12));
    int z = chunkPos.method_33941(class_3532.method_15395(random, 4, 12));
    int y = chunkGenerator.method_16397(x, z, class_2903.field_13194, levelHeightAccessor, rState);

    if (y > 5) {
      class_6880<class_1959> biome = getNoiseBiome(chunkGenerator, rState, x >> 2, y >> 2, z >> 2);

      float radius = class_3532.method_15344(random, 32F, 64F);
      float depth = class_3532.method_15344(random, 7F, 15F);
      LakePiece piece = new LakePiece(new class_2338(x, y, z), radius, depth, random, biome);
      structurePiecesBuilder.method_35462(piece);
    }
  }

  @Override
  public Optional<class_7150> method_38676(class_7149 context) {
    class_2338 pos = getGenerationHeight(
        context.comp_568(),
        context.comp_562(),
        context.comp_569(),
        context.comp_564()
    );
    if (pos.method_10264() >= 10) {
      return Optional.of(new class_3195.class_7150(pos, (structurePiecesBuilder) -> {
        generatePieces(structurePiecesBuilder, context);
      }));
    }
    return Optional.empty();
  }

  protected class_6880<class_1959> getNoiseBiome(class_2794 cg, class_7138 rState, int i, int j,
      int k) {
    return cg.method_12098().method_38109(i, j, k, rState.method_42371());
  }

  private static class_2338 getGenerationHeight(
      class_1923 chunkPos,
      class_2794 chunkGenerator,
      class_5539 levelHeightAccessor,
      class_7138 rState
  ) {
    class_5820 random = new class_5820(chunkPos.field_9181 + chunkPos.field_9180 * 10387313);
    class_2470 blockRotation = class_2470.method_16548(random);

    int offsetX = 5;
    int offsetZ = 5;
    if (blockRotation == class_2470.field_11463) {
      offsetX = -5;
    } else if (blockRotation == class_2470.field_11464) {
      offsetX = -5;
      offsetZ = -5;
    } else if (blockRotation == class_2470.field_11465) {
      offsetZ = -5;
    }

    int blockX = chunkPos.method_33939(7);
    int blockZ = chunkPos.method_33941(7);
    int minZ = Integer.MAX_VALUE;
    class_2338.class_2339 result = new class_2338.class_2339(blockX, Integer.MIN_VALUE, blockZ);
    for (int i = 0; i < 2; i++) {
      for (int j = 0; j < 2; j++) {
        int z = chunkGenerator.method_18028(
            blockX + i * offsetX,
            blockZ + j * offsetZ,
            class_2902.class_2903.field_13194,
            levelHeightAccessor,
            rState
        );
        if (z < minZ) {
          result.method_10103(blockX + i * offsetX, z, blockZ + j * offsetZ);
        }
      }
    }

    return result;
  }

}
