/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.sylcurity.block;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lol.sylvie.sylcurity.messaging.FormattingUtil;
import lol.sylvie.sylcurity.messaging.SecurityMessage;
import lol.sylvie.sylcurity.messaging.SecurityRegistry;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_4844;

public class SecurityBlockEntity
extends class_2586 {
    public static final int MAX_NAME_LENGTH = 32;
    public static final int MAX_TAG_LENGTH = 16;
    public static final int MAX_GROUPS = 8;
    protected String name = FormattingUtil.pos(this.method_11016());
    private UUID owner;
    protected HashMap<String, UUID> trusted = new HashMap();
    protected String channel = "";
    protected ArrayList<String> groups = new ArrayList();
    protected static Codec<List<String>> STRING_LIST_CODEC = Codec.STRING.listOf();
    protected static Codec<Map<String, UUID>> TRUSTED_CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)class_4844.field_40825);

    public SecurityBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public HashMap<String, UUID> getTrusted() {
        return this.trusted;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        if (SecurityRegistry.REGISTRY.containsKey(this.channel)) {
            SecurityRegistry.REGISTRY.get(this.channel).remove((Object)this);
        }
        this.channel = channel;
        SecurityRegistry.REGISTRY.computeIfAbsent(this.channel, c -> new ArrayList()).add(this);
    }

    public ArrayList<String> getGroups() {
        return this.groups;
    }

    public void setGroups(ArrayList<String> groups) {
        this.groups = groups;
    }

    public void accept(SecurityMessage message) {
    }

    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        view.method_71441("name").ifPresent(s -> {
            this.name = s;
        });
        view.method_71426("owner", class_4844.field_40825).ifPresent(u -> {
            this.owner = u;
        });
        view.method_71426("trusted", TRUSTED_CODEC).ifPresent(m -> {
            this.trusted = new HashMap(m);
        });
        view.method_71441("channel").ifPresent(s -> {
            this.channel = s;
        });
        view.method_71426("groups", STRING_LIST_CODEC).ifPresent(g -> {
            this.groups = new ArrayList(g);
        });
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        if (this.name != null) {
            view.method_71469("name", this.name);
        }
        if (this.owner != null) {
            view.method_71468("owner", class_4844.field_40825, (Object)this.owner);
        }
        view.method_71468("trusted", TRUSTED_CODEC, this.trusted);
        if (this.channel != null) {
            view.method_71469("channel", this.channel);
        }
        view.method_71468("groups", STRING_LIST_CODEC, this.groups);
    }

    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        this.setChannel("");
    }

    public boolean checkAccess(UUID uuid) {
        return uuid.equals(this.getOwner()) || this.trusted.containsValue(uuid);
    }

    public boolean checkAccess(class_1657 player) {
        return this.checkAccess(player.method_5667());
    }

    public boolean checkAccessVisibly(class_1657 player) {
        if (this.getOwner() == null) {
            this.setOwner(player.method_5667());
            player.method_7353((class_2561)class_2561.method_43471((String)"menu.sylcurity.ownership_notice").method_27692(class_124.field_1060), true);
        }
        if (!this.checkAccess(player)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"menu.sylcurity.access_error").method_27692(class_124.field_1061), true);
            return false;
        }
        return true;
    }
}

