/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.sylcurity.block.impl.camera;

import com.mojang.authlib.GameProfile;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.ChunkAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.SimpleEntityElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import lol.sylvie.sylcurity.block.ModBlocks;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_11890;
import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2668;
import net.minecraft.class_2680;
import net.minecraft.class_2703;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2824;
import net.minecraft.class_2940;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7718;

public class CameraViewer {
    public static HashMap<UUID, CameraSession> USERS = new HashMap();

    public static boolean inCamera(UUID player) {
        return USERS.containsKey(player);
    }

    public static void open(class_3218 world, class_2338 pos, class_3222 player) {
        USERS.put(player.method_5667(), new CameraSession(world, pos, player));
    }

    public static void close(class_3222 player) {
        UUID playerId = player.method_5667();
        if (!USERS.containsKey(playerId)) {
            return;
        }
        USERS.get(playerId).cleanup();
        USERS.remove(playerId);
    }

    public static void initialize() {
        ServerTickEvents.START_WORLD_TICK.register(serverWorld -> {
            for (class_3222 player : serverWorld.method_18456()) {
                if (!USERS.containsKey(player.method_5667())) continue;
                CameraSession session = USERS.get(player.method_5667());
                session.tick();
            }
        });
        ServerPlayerEvents.LEAVE.register(player -> {
            if (!USERS.containsKey(player.method_5667())) {
                return;
            }
            CameraViewer.close(player);
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(minecraftServer -> {
            for (CameraSession session : USERS.values()) {
                session.cleanup();
            }
        });
    }

    public static class CameraSession {
        private final class_3218 world;
        private final class_2338 pos;
        private final class_3218 initialWorld;
        private final class_243 initialPos;
        private final class_3222 player;
        private final ElementHolder holder;
        private final HolderAttachment attachment;

        public CameraSession(class_3218 world, class_2338 pos, class_3222 player) {
            this.world = world;
            this.pos = pos;
            this.initialWorld = player.method_51469();
            this.initialPos = player.method_73189();
            this.player = player;
            this.holder = new ElementHolder();
            this.holder.addElement((VirtualElement)new PlayerEntityElement(player));
            this.attachment = ChunkAttachment.of((ElementHolder)this.holder, (class_3218)this.initialWorld, (class_243)this.initialPos);
            this.updateGameMode(class_1934.field_9219);
            player.method_6092(new class_1293(class_1294.field_5925, -1, 255, true, false, false));
        }

        private void updateGameMode(class_1934 target) {
            class_1934 previous = this.player.method_68876();
            this.player.field_13974.method_30118(target);
            class_2703 packet = new class_2703(class_2703.class_5893.field_29137, this.player);
            this.player.field_13974.method_30118(previous);
            this.player.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25648, (float)target.method_8379()));
            this.player.field_13987.method_14364((class_2596)packet);
        }

        public void tick() {
            this.attachment.tick();
            class_2680 state = this.world.method_8320(this.pos);
            if (!state.method_27852(ModBlocks.CAMERA) || this.player.method_5715() || this.player.method_29504()) {
                CameraViewer.close(this.player);
                return;
            }
            int rotation = (Integer)state.method_11654((class_2769)class_2741.field_12532);
            this.player.method_6092(new class_1293(class_1294.field_5911, 2, 255, true, false, false));
            this.player.method_6092(new class_1293(class_1294.field_5901, 2, 255, true, false, false));
            float yaw = class_7718.method_45482((int)rotation) - 180.0f;
            class_243 posVec = this.player.method_5631(0.0f, yaw).method_1021(0.5);
            class_243 displayPos = this.pos.method_46558().method_1019(posVec);
            this.player.method_48105(this.world, displayPos.field_1352, displayPos.field_1351 - 1.7, displayPos.field_1350, Set.of(), yaw, 0.0f, true);
        }

        public void cleanup() {
            this.holder.destroy();
            this.player.method_48105(this.initialWorld, this.initialPos.field_1352, this.initialPos.field_1351, this.initialPos.field_1350, Set.of(), 0.0f, 0.0f, false);
            this.player.method_6016(class_1294.field_5925);
            this.updateGameMode(this.player.method_68876());
        }
    }

    private static class PlayerEntityElement
    extends SimpleEntityElement {
        private final class_3222 player;
        private final FakePlayer fakePlayer;

        public PlayerEntityElement(final class_3222 player) {
            super(class_1299.field_6097);
            this.player = player;
            this.copyDataFromPlayer(class_1657.field_7491);
            this.copyDataFromPlayer(class_1657.field_7511);
            this.copyDataFromPlayer(class_11890.field_62514);
            this.copyDataFromPlayer(class_11890.field_62513);
            GameProfile profile = new GameProfile(this.getUuid(), player.method_7334().name(), player.method_7334().properties());
            this.fakePlayer = FakePlayer.get((class_3218)player.method_51469(), (GameProfile)profile);
            this.setPitch(player.method_36455());
            this.setYaw(player.method_36454());
            this.setInteractionHandler(new VirtualElement.InteractionHandler(){

                public void interact(class_3222 attacker, class_1268 hand) {
                    attacker.field_13987.method_12062(class_2824.method_34207((class_1297)player, (boolean)player.method_5715(), (class_1268)hand));
                }

                public void interactAt(class_3222 attacker, class_1268 hand, class_243 pos) {
                    attacker.field_13987.method_12062(class_2824.method_34208((class_1297)player, (boolean)player.method_5715(), (class_1268)hand, (class_243)pos));
                }

                public void attack(class_3222 attacker) {
                    CameraViewer.close(player);
                    attacker.field_13987.method_12062(class_2824.method_34206((class_1297)player, (boolean)player.method_5715()));
                }
            });
        }

        public void startWatching(class_3222 observer, Consumer<class_2596<class_2602>> packetConsumer) {
            packetConsumer.accept((class_2596<class_2602>)new class_2703(class_2703.class_5893.field_29136, (class_3222)this.fakePlayer));
            super.startWatching(observer, packetConsumer);
        }

        public void stopWatching(class_3222 player, Consumer<class_2596<class_2602>> packetConsumer) {
            super.stopWatching(player, packetConsumer);
        }

        private <T> void copyDataFromPlayer(class_2940<T> key) {
            this.dataTracker.set(key, this.player.method_5841().method_12789(key));
        }
    }
}

