/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.sylcurity.gui;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import lol.sylvie.sylcurity.block.SecurityBlockEntity;
import lol.sylvie.sylcurity.gui.DialogBuilder;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class CommonDialogs {
    public static void openSecurityBlockSettings(class_3222 player, SecurityBlockEntity entity, class_2561 title, Consumer<class_2487> onExit, Runnable openThisMenu) {
        if (!entity.checkAccessVisibly((class_1657)player)) {
            return;
        }
        DialogBuilder settings = CommonDialogs.createSecurityBlockSettings(player, entity, title, onExit, openThisMenu);
        settings.addActionButton(class_2960.method_60655((String)"sylcurity", (String)"back"), (class_2561)class_2561.method_43471((String)"menu.sylcurity.back"), onExit);
        settings.openTo(player);
    }

    public static DialogBuilder createSecurityBlockSettings(class_3222 player, SecurityBlockEntity block, class_2561 title, Consumer<class_2487> onExit, Runnable openPrevious) {
        DialogBuilder settings = new DialogBuilder(player, title);
        settings.addTextInput("name", 200, (class_2561)class_2561.method_43471((String)"menu.sylcurity.name"), block.getName(), 32);
        settings.addTextInput("channel", 200, (class_2561)class_2561.method_43471((String)"menu.sylcurity.security_options.channel"), block.getChannel(), 16);
        int groupStrLen = 142;
        settings.addTextInput("groups", 200, (class_2561)class_2561.method_43471((String)"menu.sylcurity.security_options.groups"), String.join((CharSequence)", ", block.getGroups()), groupStrLen);
        settings.addActionButton(class_2960.method_60655((String)"sylcurity", (String)"edit_trusted_players"), (class_2561)class_2561.method_43471((String)"menu.sylcurity.trusted_players"), data -> CommonDialogs.openTrustedDialog(player, block, openPrevious));
        settings.addActionButton(class_2960.method_60655((String)"sylcurity", (String)"save_security_options"), (class_2561)class_2561.method_43471((String)"menu.sylcurity.save"), data -> {
            onExit.accept((class_2487)data);
            String name = data.method_68564("name", "");
            if (name.length() > 32) {
                player.method_7353((class_2561)class_2561.method_43471((String)"menu.sylcurity.error.name_too_long").method_27692(class_124.field_1061), true);
            } else {
                block.setName(name);
            }
            String channel = data.method_68564("channel", "");
            if (channel.length() > 16) {
                player.method_7353((class_2561)class_2561.method_43471((String)"menu.sylcurity.error.channel_too_long").method_27692(class_124.field_1061), true);
            } else {
                block.setChannel(channel);
            }
            String groupTags = data.method_68564("groups", "");
            List<String> split = Arrays.stream(groupTags.split(",")).map(String::strip).filter(s -> s.length() <= 16).distinct().toList();
            if (split.size() > 8) {
                player.method_7353((class_2561)class_2561.method_43471((String)"menu.sylcurity.error.too_many_groups").method_27692(class_124.field_1061), true);
            } else {
                block.setGroups(new ArrayList<String>(split));
            }
        });
        return settings;
    }

    public static void openTrustedDialog(class_3222 player, SecurityBlockEntity entity, Runnable openPrevious) {
        DialogBuilder builder = new DialogBuilder(player, (class_2561)class_2561.method_43471((String)"menu.sylcurity.trusted_players"));
        for (String user : entity.getTrusted().keySet()) {
            builder.addText((class_2561)class_2561.method_43470((String)user));
        }
        builder.addTextInput("username", 200, (class_2561)class_2561.method_43471((String)"menu.sylcurity.name"), "", 16);
        builder.addActionButton(class_2960.method_60655((String)"sylcurity", (String)"add_player"), (class_2561)class_2561.method_43471((String)"menu.sylcurity.trusted.add"), data -> {
            Optional usernameOptional = data.method_10558("username");
            if (usernameOptional.isEmpty()) {
                CommonDialogs.openTrustedDialog(player, entity, openPrevious);
                return;
            }
            String username = (String)usernameOptional.get();
            class_3222 target = player.method_51469().method_8503().method_3760().method_14566(username);
            if (target == null) {
                player.method_7353((class_2561)class_2561.method_43471((String)"menu.sylcurity.error.player_not_found").method_27692(class_124.field_1061), true);
            } else {
                GameProfile profile = target.method_7334();
                UUID id = profile.id();
                if (id.equals(entity.getOwner())) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"menu.sylcurity.error.no_trust_self").method_27692(class_124.field_1061), true);
                } else {
                    entity.getTrusted().put(profile.name(), profile.id());
                }
            }
            CommonDialogs.openTrustedDialog(player, entity, openPrevious);
        });
        builder.addActionButton(class_2960.method_60655((String)"sylcurity", (String)"remove_player"), (class_2561)class_2561.method_43471((String)"menu.sylcurity.trusted.remove"), data -> {
            Optional usernameOptional = data.method_10558("username");
            if (usernameOptional.isEmpty()) {
                player.method_7353((class_2561)class_2561.method_43471((String)"menu.sylcurity.error.player_not_trusted").method_27692(class_124.field_1061), true);
            } else {
                String username = (String)usernameOptional.get();
                entity.getTrusted().remove(username);
            }
            CommonDialogs.openTrustedDialog(player, entity, openPrevious);
        });
        builder.addActionButton(class_2960.method_60655((String)"sylcurity", (String)"back"), (class_2561)class_2561.method_43471((String)"menu.sylcurity.back"), data -> openPrevious.run());
        builder.openTo(player);
    }
}

