/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.sylcurity.messaging;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import lol.sylvie.sylcurity.messaging.FormattingUtil;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class SecurityMessage {
    protected final Type type;
    protected final String terminal;
    @Nullable
    protected final String group;
    protected final String name;
    @Nullable
    protected final class_3222 player;
    protected final Timestamp timestamp;
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("MM/dd/yy HH:mm:ss");

    public SecurityMessage(Type type, String terminal, @Nullable String group, String name, @Nullable class_3222 player) {
        this.type = type;
        this.terminal = terminal;
        this.group = group;
        this.name = name;
        this.player = player;
        this.timestamp = new Timestamp(System.currentTimeMillis());
    }

    public String getTerminal() {
        return this.terminal;
    }

    @Nullable
    public String getGroup() {
        return this.group;
    }

    @Nullable
    public class_3222 getPlayer() {
        return this.player;
    }

    public String asString() {
        return String.format("[%s] %s detected", this.timestamp(), this.getClass().getSimpleName());
    }

    public String timestamp() {
        return FORMAT.format(this.timestamp);
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        PLAYER_DETECTION((class_2561)class_2561.method_43471((String)"message.sylcurity.player_detection")),
        SECURITY_ACCESS((class_2561)class_2561.method_43471((String)"message.sylcurity.security_access"));

        private final class_2561 text;

        private Type(class_2561 text) {
            this.text = text;
        }

        public class_2561 getText() {
            return this.text;
        }
    }

    public static class SecurityAccess
    extends SecurityMessage {
        public SecurityAccess(String terminal, String group, String name, class_3222 offender) {
            super(Type.SECURITY_ACCESS, terminal, group, name, offender);
            if (offender == null) {
                throw new IllegalStateException("Access log needs a player!");
            }
        }

        @Override
        public String asString() {
            assert (this.player != null);
            return class_2561.method_43469((String)"message.sylcurity.security_access.format", (Object[])new Object[]{this.timestamp(), FormattingUtil.player(this.player), this.name}).getString();
        }
    }

    public static class PlayerDetection
    extends SecurityMessage {
        public PlayerDetection(String terminal, String group, String name, class_3222 offender) {
            super(Type.PLAYER_DETECTION, terminal, group, name, offender);
            if (offender == null) {
                throw new IllegalStateException("Player detection needs a player, dummy!");
            }
        }

        @Override
        public String asString() {
            assert (this.player != null);
            return class_2561.method_43469((String)"message.sylcurity.player_detection.format", (Object[])new Object[]{this.timestamp(), FormattingUtil.player(this.player), this.name}).getString();
        }
    }
}

