/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.sylcurity.messaging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import lol.sylvie.sylcurity.block.SecurityBlockEntity;
import lol.sylvie.sylcurity.messaging.SecurityMessage;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerBlockEntityEvents;

public class SecurityRegistry {
    public static final HashMap<String, ArrayList<SecurityBlockEntity>> REGISTRY = new HashMap();

    public static void initialize() {
        ServerBlockEntityEvents.BLOCK_ENTITY_LOAD.register((blockEntity, serverWorld) -> {
            if (!(blockEntity instanceof SecurityBlockEntity)) {
                return;
            }
            SecurityBlockEntity securityBlock = (SecurityBlockEntity)blockEntity;
            REGISTRY.computeIfAbsent(securityBlock.getChannel(), s -> new ArrayList()).add(securityBlock);
        });
        ServerBlockEntityEvents.BLOCK_ENTITY_UNLOAD.register((blockEntity, serverWorld) -> {
            if (!(blockEntity instanceof SecurityBlockEntity)) {
                return;
            }
            SecurityBlockEntity securityBlock = (SecurityBlockEntity)blockEntity;
            REGISTRY.get(securityBlock.getChannel()).remove((Object)securityBlock);
        });
    }

    public static void post(SecurityMessage message, UUID owner) {
        REGISTRY.getOrDefault(message.getTerminal(), new ArrayList()).stream().filter(b -> b.checkAccess(owner)).filter(b -> b.getGroups().contains(message.getGroup())).forEach(b -> b.accept(message));
    }
}

