/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.block;

import net.conczin.immersive_furniture.block.BaseFurnitureBlock;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.FurnitureDataManager;
import net.conczin.immersive_furniture.data.FurnitureRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;

public class LightFurnitureBlock
extends BaseFurnitureBlock {
    public static final IntegerProperty IDENTIFIER = IntegerProperty.create((String)"identifier", (int)0, (int)255);
    public static final IntegerProperty LIGHT = IntegerProperty.create((String)"light", (int)0, (int)5);

    public LightFurnitureBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)IDENTIFIER, (Comparable)Integer.valueOf(0))).setValue((Property)LIGHT, (Comparable)Integer.valueOf(0))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockPos = context.getClickedPos();
        Level levelAccessor = context.getLevel();
        boolean waterlogged = levelAccessor.getFluidState(blockPos).getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{IDENTIFIER, LIGHT, WATERLOGGED, FACING, ACTIVE});
    }

    @Override
    public FurnitureData getData(BlockState state, BlockGetter level, BlockPos pos) {
        int identifier = (Integer)state.getValue((Property)IDENTIFIER) + 65536;
        String hash = FurnitureRegistry.resolve(identifier);
        return hash != null ? FurnitureDataManager.getData(hash) : null;
    }

    @Override
    public BlockState toggleLight(FurnitureData data, BlockState state, Level level, BlockPos pos) {
        return (BlockState)state.setValue((Property)LIGHT, (Comparable)Integer.valueOf(data.toggleLight && (Boolean)state.getValue((Property)ACTIVE) != false ? 0 : (int)Math.ceil((float)data.lightLevel / 3.0f)));
    }
}

