/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.conczin.immersive_furniture.client.gui.FakeCamera;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

public class PreviewParticleEngine {
    private static final List<ParticleRenderType> RENDER_ORDER = ImmutableList.of((Object)ParticleRenderType.TERRAIN_SHEET, (Object)ParticleRenderType.PARTICLE_SHEET_OPAQUE, (Object)ParticleRenderType.PARTICLE_SHEET_LIT, (Object)ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT, (Object)ParticleRenderType.CUSTOM);
    private final Map<ParticleRenderType, Queue<Particle>> particles = Maps.newIdentityHashMap();

    public void add(Particle particle) {
        this.particles.computeIfAbsent(particle.getRenderType(), particleRenderType -> EvictingQueue.create((int)16384)).add(particle);
    }

    public void addParticle(ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        Particle particle = Minecraft.getInstance().particleEngine.createParticle(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
        if (particle != null) {
            this.add(particle);
        }
    }

    public void tick() {
        this.particles.forEach((particleRenderType, queue) -> this.tickParticleList((Collection<Particle>)queue));
    }

    private void tickParticleList(Collection<Particle> particles) {
        if (!particles.isEmpty()) {
            Iterator<Particle> iterator = particles.iterator();
            while (iterator.hasNext()) {
                Particle particle = iterator.next();
                particle.tick();
                if (particle.isAlive()) continue;
                iterator.remove();
            }
        }
    }

    public void render(PoseStack poseStack, LightTexture lightTexture, Camera camera, float partialTicks) {
        lightTexture.turnOnLightLayer();
        RenderSystem.enableDepthTest();
        Matrix4fStack viewStack = RenderSystem.getModelViewStack();
        viewStack.pushMatrix();
        viewStack.mul((Matrix4fc)poseStack.last().pose());
        RenderSystem.applyModelViewMatrix();
        TextureManager textureManager = Minecraft.getInstance().getTextureManager();
        for (ParticleRenderType particlerendertype : RENDER_ORDER) {
            Queue<Particle> queue = this.particles.get(particlerendertype);
            if (queue == null || queue.isEmpty()) continue;
            RenderSystem.setShader(GameRenderer::getParticleShader);
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder bufferbuilder = particlerendertype.begin(tesselator, textureManager);
            if (bufferbuilder == null) continue;
            for (Particle particle : queue) {
                particle.render((VertexConsumer)bufferbuilder, camera, partialTicks);
            }
            MeshData meshdata = bufferbuilder.build();
            if (meshdata == null) continue;
            BufferUploader.drawWithShader((MeshData)meshdata);
        }
        viewStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        lightTexture.turnOffLightLayer();
    }

    public void renderParticles(GuiGraphics graphics, float yaw, float pitch, float partialTicks) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player == null || minecraft.level == null) {
            return;
        }
        FakeCamera camera = new FakeCamera();
        camera.setup((BlockGetter)minecraft.level, (Entity)minecraft.player, false, false, partialTicks, yaw, pitch);
        this.render(graphics.pose(), minecraft.gameRenderer.lightTexture(), camera, partialTicks);
    }
}

