/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.gui;

import com.mojang.blaze3d.platform.InputConstants;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.StringConcatFactory;
import java.util.Arrays;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.conczin.immersive_furniture.Common;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationEditorScreen;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationScreen;
import net.conczin.immersive_furniture.client.gui.components.SettingsComponent;
import net.conczin.immersive_furniture.client.gui.widgets.LegacyImageButton;
import net.conczin.immersive_furniture.client.gui.widgets.StateImageButton;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.FurnitureDataManager;
import net.conczin.immersive_furniture.data.api.API;
import net.conczin.immersive_furniture.data.api.Auth;
import net.conczin.immersive_furniture.data.api.responses.ContentIdResponse;
import net.conczin.immersive_furniture.data.api.responses.ContentListResponse;
import net.conczin.immersive_furniture.data.api.responses.ErrorResponse;
import net.conczin.immersive_furniture.data.api.responses.IsAuthResponse;
import net.conczin.immersive_furniture.data.api.responses.Response;
import net.conczin.immersive_furniture.data.api.responses.SuccessResponse;
import net.conczin.immersive_furniture.item.Items;
import net.conczin.immersive_furniture.network.Network;
import net.conczin.immersive_furniture.network.c2s.CraftRequest;
import net.conczin.immersive_furniture.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ArtisansWorkstationLibraryScreen
extends ArtisansWorkstationScreen {
    static final Component SEARCH_TITLE = Component.translatable((String)"itemGroup.search");
    static final Component SEARCH_HINT = Component.translatable((String)"gui.recipebook.search_hint").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY);
    static final int ENTRIES_PER_PAGE = 8;
    private boolean uploading = false;
    private boolean awaitingAuthentication = false;
    private boolean awaitingSearch = false;
    private boolean shouldSearch = true;
    private String lastSearch = "";
    private boolean authenticating;
    private boolean isBrowserOpen = false;
    private boolean authenticated = false;
    private SortingMode order = SortingMode.RECOMMENDATIONS;
    private String tagFilter = "miscellaneous";
    Tab tab = Tab.GLOBAL;
    int page = 0;
    List<ResourceLocation> furniture = new LinkedList<ResourceLocation>();
    List<ResourceLocation> localFiles = FurnitureDataManager.getLocalFiles();
    ResourceLocation selected = null;
    int lastMouseX;
    int lastMouseY;
    float previewYaw = 0.0f;
    float previewPitch = 0.0f;

    public ArtisansWorkstationLibraryScreen() {
        this.authenticating = Auth.loadToken() != null;
        FurnitureDataManager.REQUESTED_DATA.clear();
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    protected void init() {
        super.init();
        if (this.selected == null) {
            String text;
            int w = (this.windowWidth - 4) / 4;
            int x = this.leftPos;
            for (Tab tab : Tab.values()) {
                text = "gui.immersive_furniture.tab." + tab.name().toLowerCase(Locale.ROOT);
                this.addRenderableWidget(Button.builder((Component)Component.translatable((String)text), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$init$0(net.conczin.immersive_furniture.client.gui.ArtisansWorkstationLibraryScreen$Tab net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((ArtisansWorkstationLibraryScreen)this, (Tab)tab)).bounds((int)(x + 2), (int)(this.topPos - 19), (int)w, (int)20).tooltip((Tooltip)Tooltip.create((Component)Component.translatable((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001.hint"}, (String)text))))).build()).active = tab != this.tab;
                x += w;
            }
            Objects.requireNonNull(this.font);
            EditBox searchBox = new EditBox(this.font, this.leftPos + 5, this.topPos + 5, this.windowWidth - 64 - 12, 9 + 3, SEARCH_TITLE);
            searchBox.setMaxLength(50);
            searchBox.setVisible(true);
            searchBox.setValue(this.lastSearch);
            searchBox.setHint(SEARCH_HINT);
            searchBox.setResponder(s -> {
                if (!s.equals(this.lastSearch)) {
                    this.lastSearch = s;
                    this.shouldSearch = true;
                }
            });
            this.addRenderableWidget(searchBox);
            this.setInitialFocus((GuiEventListener)searchBox);
            int i = 0;
            int tx = this.leftPos + 4;
            for (String tag : SettingsComponent.TAGS) {
                this.addToggleButton(tx, this.topPos + 18, 16, i * 16, 224, "gui.immersive_furniture.tag." + tag.toLowerCase(Locale.ROOT), b -> {
                    this.tagFilter = tag;
                    this.shouldSearch = true;
                    b.setEnabled(true);
                }).setEnabled(tag.equals(this.tagFilter));
                tx += 17;
                ++i;
            }
            int y = this.topPos + this.windowHeight - 25;
            this.addRenderableWidget(new LegacyImageButton(this.leftPos + 3, y, 22, 22, this.order.getU(), 114, 22, TEXTURE, 256, 256, b -> {
                this.order = this.order.cycle();
                this.shouldSearch = true;
                this.init();
            })).setTooltip(Tooltip.create((Component)Component.translatable((String)("gui.immersive_furniture.sort." + this.order.key()))));
            this.addRenderableWidget(new LegacyImageButton(this.leftPos + this.windowWidth / 2 - 24 - 6, y + 4, 12, 15, 193, 0, 15, TEXTURE, 256, 256, b -> {
                this.page = Math.max(0, this.page - 1);
                this.shouldSearch = true;
                this.init();
            }));
            this.addRenderableWidget(new LegacyImageButton(this.leftPos + this.windowWidth / 2 + 24 - 6, y + 4, 12, 15, 180, 0, 15, TEXTURE, 256, 256, b -> {
                ++this.page;
                this.shouldSearch = true;
                this.init();
            }));
            text = Component.translatable((String)(this.authenticated || this.authenticating ? "gui.immersive_furniture.logout" : "gui.immersive_furniture.login"));
            this.addRenderableWidget(Button.builder((Component)text, b -> {
                if (this.authenticated || this.authenticating) {
                    Auth.clearToken();
                    this.authenticated = false;
                    this.authenticating = false;
                } else {
                    Auth.authenticate(this.getPlayerName());
                    this.authenticating = true;
                    this.isBrowserOpen = true;
                }
                this.init();
            }).bounds(this.leftPos + this.windowWidth - 64 - 4, this.topPos + 4, 64, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.immersive_furniture.login.tooltip"))).build());
            this.addRenderableWidget(Button.builder((Component)Component.translatable((String)"gui.immersive_furniture.create"), b -> {
                if (this.minecraft != null) {
                    this.minecraft.setScreen((Screen)new ArtisansWorkstationEditorScreen(new FurnitureData()));
                }
            }).bounds(this.leftPos + this.windowWidth - 64 - 4, this.topPos + this.windowHeight - 24, 64, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.immersive_furniture.create.hint"))).build());
        } else {
            int x = this.leftPos + this.windowWidth / 2;
            int y = this.topPos + this.windowHeight - 25;
            if (!this.selected.getNamespace().equals("local")) {
                this.addToggleButton(x - 50 - 11, y, 22, 0, 114, "gui.immersive_furniture.favorite", b -> {
                    if (this.authenticated) {
                        FurnitureData model = FurnitureDataManager.getData(this.selected);
                        if (model != null) {
                            if (!b.isEnabled()) {
                                API.request(API.HttpMethod.DELETE, "like/furniture/" + model.contentid);
                            } else {
                                API.request(API.HttpMethod.POST, "like/furniture/" + model.contentid);
                            }
                            b.setEnabled(!b.isEnabled());
                        }
                    } else {
                        this.setError("gui.immersive_furniture.login_required");
                    }
                }).setEnabled(this.tab != Tab.FAVORITES);
            }
            if (this.selected.getNamespace().equals("local")) {
                this.addButton(x - 25 - 11, y, 22, 132, 114, "gui.immersive_furniture.publish", () -> {
                    if (this.authenticated) {
                        FurnitureData model = FurnitureDataManager.getData(this.selected);
                        if (model != null) {
                            this.publish(model);
                        }
                    } else {
                        this.setError("gui.immersive_furniture.login_required");
                    }
                });
            }
            if (this.tab == Tab.SUBMISSIONS || this.tab == Tab.LOCAL) {
                this.addButton(x - 11, y, 22, 44, 114, "gui.immersive_furniture.delete", this::delete);
            }
            this.addButton(x + 25 - 11, y, 22, 22, 114, "gui.immersive_furniture.modify", () -> {
                FurnitureData data = FurnitureDataManager.getData(this.selected);
                if (this.minecraft != null && data != null) {
                    this.minecraft.setScreen((Screen)new ArtisansWorkstationEditorScreen(new FurnitureData(data)));
                }
            });
            if (this.tab == Tab.GLOBAL) {
                this.addToggleButton(x + 50 - 11, y, 22, 110, 114, "gui.immersive_furniture.report", b -> {
                    if (this.authenticated) {
                        FurnitureData model = FurnitureDataManager.getData(this.selected);
                        if (model != null) {
                            if (b.isEnabled()) {
                                API.request(API.HttpMethod.DELETE, "report/furniture/" + model.contentid + "/DEFAULT");
                            } else {
                                API.request(API.HttpMethod.POST, "report/furniture/" + model.contentid + "/DEFAULT");
                            }
                            b.setEnabled(!b.isEnabled());
                        }
                    } else {
                        this.setError("gui.immersive_furniture.login_required");
                    }
                }).setEnabled(false);
            }
            this.addRenderableWidget(Button.builder((Component)Component.translatable((String)"gui.immersive_furniture.back"), b -> {
                this.selected = null;
                this.init();
            }).bounds(this.leftPos + 4, this.topPos + this.windowHeight - 24, 64, 20).build());
            this.addRenderableWidget(Button.builder((Component)Component.translatable((String)"gui.immersive_furniture.craft"), b -> {
                Network.sendToServer(new CraftRequest(FurnitureDataManager.getData(this.selected), this.holdingShift()));
                if (!this.holdingCtrl() && !this.holdingShift()) {
                    Minecraft.getInstance().setScreen(null);
                }
            }).bounds(this.leftPos + this.windowWidth - 68, this.topPos + this.windowHeight - 24, 64, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.immersive_furniture.craft.hint"))).build());
        }
    }

    private void delete() {
        if (this.lastCriticalActionAttempt + 5000L > System.currentTimeMillis()) {
            this.clearError();
            if (this.tab == Tab.SUBMISSIONS) {
                FurnitureData model = FurnitureDataManager.getData(this.selected);
                if (model != null) {
                    API.request(API.HttpMethod.DELETE, "content/furniture/" + model.contentid);
                } else {
                    this.setError("gui.immersive_furniture.delete_failed");
                }
            } else {
                FurnitureDataManager.deleteLocalFile(this.selected);
                this.localFiles = FurnitureDataManager.getLocalFiles();
                this.shouldSearch = true;
            }
            this.selected = null;
            this.init();
        } else {
            this.lastCriticalActionAttempt = System.currentTimeMillis();
            this.setError("gui.immersive_furniture.delete_confirm");
        }
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.renderBackground(graphics, mouseX, mouseY, delta);
        if (this.selected == null) {
            this.drawRectangle(graphics, this.leftPos, this.topPos, this.windowWidth, 38);
            this.drawRectangle(graphics, this.leftPos, this.topPos + this.windowHeight - 28, this.windowWidth, 28);
        } else {
            this.drawRectangle(graphics, this.leftPos, this.topPos, this.windowWidth, this.windowHeight - 28, 0, 48);
            this.drawRectangle(graphics, this.leftPos, this.topPos + this.windowHeight - 28, this.windowWidth, 28);
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        super.render(graphics, mouseX, mouseY, delta);
        List tooltip = null;
        if (this.selected == null) {
            this.search();
            int w = this.windowWidth / 4;
            int h = (this.windowHeight - 38 - 28) / 2;
            for (int x = 0; x < 4; ++x) {
                for (int y = 0; y < 2; ++y) {
                    FurnitureData data;
                    int i = x + y * 4;
                    boolean hovered = this.isTileHovered(x, y) && i < this.furniture.size();
                    this.drawRectangle(graphics, this.leftPos + x * w, this.topPos + 38 + y * h, w, h, 0, hovered ? 96 : 48);
                    if (i >= this.furniture.size() || (data = FurnitureDataManager.getData(this.furniture.get(i))) == null) continue;
                    float rot = (float)(hovered ? (double)((float)(System.currentTimeMillis() % 10000L) / 10000.0f) * Math.PI * 2.0 : -2.356194490192345);
                    this.renderModel(graphics, data, (double)this.leftPos + ((double)x + 0.5) * (double)w, (double)(this.topPos + 38) + ((double)y + 0.5) * (double)h, h, rot, -0.7853982f);
                    if (!hovered) continue;
                    tooltip = data.getTooltip(Screen.hasShiftDown());
                    tooltip.add(0, (Component)Component.literal((String)data.name).withStyle(ChatFormatting.BOLD));
                }
            }
            graphics.drawCenteredString(this.font, String.valueOf(this.page + 1), this.leftPos + this.windowWidth / 2, this.topPos + this.windowHeight - 17, 0xFFFFFF);
        } else {
            FurnitureData data = FurnitureDataManager.getData(this.selected);
            if (data != null) {
                graphics.pose().pushPose();
                graphics.pose().translate(0.0f, 0.0f, 1024.0f);
                graphics.enableScissor(this.leftPos + 6, this.topPos + 6, this.leftPos + this.windowWidth - 6, this.topPos + this.windowHeight - 28 - 6);
                this.renderModel(graphics, data, (double)this.leftPos + (double)this.windowWidth / 2.0, (double)this.topPos + (double)this.windowHeight / 2.0, this.windowHeight - 28, this.previewYaw, this.previewPitch);
                graphics.flush();
                graphics.disableScissor();
                graphics.drawString(this.font, data.name, this.leftPos + 8, this.topPos + 8, 0xFFFFFF);
                graphics.drawString(this.font, (Component)Component.translatable((String)"gui.immersive_furniture.author", (Object[])new Object[]{data.author}).withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY), this.leftPos + 8, this.topPos + 18, 0xFFFFFF);
                graphics.pose().translate((float)(this.leftPos + this.windowWidth), (float)(this.topPos + this.windowHeight - 28), 0.0f);
                graphics.pose().scale(1.5f, 1.5f, 1.5f);
                MutableComponent cost = Component.literal((String)String.valueOf(data.getCost()));
                graphics.drawString(this.font, (Component)cost, -this.font.width((FormattedText)cost) - 26, -17, 0xFFFFFF);
                graphics.renderFakeItem(Items.CRAFTING_MATERIAL.getDefaultInstance(), -22, -22);
                graphics.pose().popPose();
                if (this.lastMouseX >= this.leftPos + this.windowWidth - 32 - 6 && this.lastMouseX < this.leftPos + this.windowWidth - 6 && this.lastMouseY >= this.topPos + this.windowHeight - 32 - 32 && this.lastMouseY < this.topPos + this.windowHeight - 32 && data.getCost() > 0) {
                    tooltip = Items.CRAFTING_MATERIAL.getDefaultInstance().getTooltipLines(Item.TooltipContext.of((Level)null), null, (TooltipFlag)TooltipFlag.Default.NORMAL);
                }
            }
        }
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 1024.0f);
        if (this.authenticating) {
            this.tickAuthentication();
            if (this.isBrowserOpen) {
                this.drawTextBox(graphics, (Component)Component.translatable((String)"gui.immersive_furniture.authenticating_browser"));
            } else {
                this.drawTextBox(graphics, (Component)Component.translatable((String)"gui.immersive_furniture.authenticating").append((Component)Component.literal((String)(" " + ".".repeat((int)(System.currentTimeMillis() / 500L % 4L))))));
            }
        }
        if (tooltip != null) {
            graphics.renderTooltip(this.font, tooltip, Optional.empty(), this.lastMouseX, this.lastMouseY);
        }
        graphics.pose().popPose();
        this.renderError(graphics, this.selected == null ? this.height / 2 : this.topPos + 9);
        graphics.pose().translate(0.0f, 0.0f, 1024.0f);
    }

    private boolean isTileHovered(int x, int y) {
        int w = this.windowWidth / 4;
        int h = (this.windowHeight - 32 - 28) / 2;
        return this.lastMouseX >= this.leftPos + x * w && this.lastMouseX < this.leftPos + (x + 1) * w && this.lastMouseY >= this.topPos + 38 + y * h && this.lastMouseY < this.topPos + 38 + (y + 1) * h;
    }

    private boolean holdingShift() {
        long window = Minecraft.getInstance().getWindow().getWindow();
        return InputConstants.isKeyDown((long)window, (int)340) || InputConstants.isKeyDown((long)window, (int)344);
    }

    private boolean holdingCtrl() {
        long window = Minecraft.getInstance().getWindow().getWindow();
        return InputConstants.isKeyDown((long)window, (int)341) || InputConstants.isKeyDown((long)window, (int)345);
    }

    protected ImageButton addButton(int x, int y, int size, int u, int v, String tooltip, Runnable clicked) {
        ImageButton button = this.addRenderableWidget(new LegacyImageButton(x, y, size, size, u, v, size, TEXTURE, 256, 256, b -> clicked.run(), (Component)(tooltip == null ? Component.literal((String)"") : Component.translatable((String)tooltip))));
        if (tooltip != null) {
            button.setTooltip(Tooltip.create((Component)Component.translatable((String)tooltip)));
        }
        return button;
    }

    protected StateImageButton addToggleButton(int x, int y, int size, int u, int v, String tooltip, Consumer<StateImageButton> clicked) {
        StateImageButton button = this.addRenderableWidget(new StateImageButton(x, y, size, size, u, v, TEXTURE, 256, 256, b -> clicked.accept((StateImageButton)b), (Component)(tooltip == null ? Component.literal((String)"") : Component.translatable((String)tooltip))));
        if (tooltip != null) {
            button.setTooltip(Tooltip.create((Component)Component.translatable((String)tooltip)));
        }
        return button;
    }

    private void tickAuthentication() {
        if (this.awaitingAuthentication) {
            return;
        }
        this.awaitingAuthentication = true;
        CompletableFuture.runAsync(() -> {
            try {
                Response response;
                Response response2 = response = Auth.hasToken() ? API.request(API.HttpMethod.GET, IsAuthResponse::new, "auth") : null;
                if (response instanceof IsAuthResponse) {
                    IsAuthResponse authResponse = (IsAuthResponse)response;
                    if (authResponse.authenticated()) {
                        this.authenticated = true;
                        this.authenticating = false;
                        this.clearError();
                        Minecraft.getInstance().execute(this::init);
                        Auth.saveToken();
                    } else {
                        Auth.clearToken();
                        if (!this.isBrowserOpen) {
                            this.setError("gui.immersive_furniture.is_auth_failed");
                            this.authenticating = false;
                        }
                    }
                } else {
                    this.setError("gui.immersive_furniture.is_auth_failed");
                    this.authenticating = false;
                }
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                Common.logger.error("Failed to authenticate!", (Throwable)e);
            }
            this.awaitingAuthentication = false;
        });
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.selected == null) {
            for (int x = 0; x < 4; ++x) {
                for (int y = 0; y < 2; ++y) {
                    int index = x + y * 4;
                    if (index >= this.furniture.size() || !this.isTileHovered(x, y)) continue;
                    this.setSelected(this.furniture.get(index));
                    this.init();
                    return true;
                }
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.selected != null) {
            if (button == 0) {
                this.previewYaw += (float)(dragX * (double)0.015f);
                this.previewPitch -= (float)(dragY * (double)0.015f);
            }
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public void setSelected(ResourceLocation location) {
        this.selected = location;
        this.previewYaw = -2.3561945f;
        this.previewPitch = -0.7853982f;
    }

    public void setTab(Tab tab) {
        this.tab = tab;
        this.page = 0;
        this.shouldSearch = true;
        this.init();
    }

    private void drawTextBox(GuiGraphics graphics, Component text) {
        int y = this.height / 2 - 32;
        graphics.fill(this.width / 2 - 115, y - 5, this.width / 2 + 115, y + 12, 0x50000000);
        graphics.drawCenteredString(this.font, text, this.width / 2, y, -1);
    }

    private String getPlayerName() {
        return Minecraft.getInstance().player == null ? "Unknown" : Minecraft.getInstance().player.getGameProfile().getName();
    }

    private void search() {
        if (this.awaitingSearch) {
            return;
        }
        if (!this.shouldSearch) {
            return;
        }
        this.shouldSearch = false;
        if (this.tab == Tab.LOCAL) {
            this.furniture = this.localFiles.stream().filter(l -> Utils.search(this.lastSearch, l.toString())).filter(l -> {
                FurnitureData data = FurnitureDataManager.getData(l);
                return this.tagFilter.equals("miscellaneous") || data == null || data.tag.equals(this.tagFilter);
            }).skip((long)this.page * 8L).limit(8L).toList();
        } else {
            this.awaitingSearch = true;
            CompletableFuture.runAsync(() -> {
                Response response = API.request(API.HttpMethod.GET, ContentListResponse::new, "v2/content/furniture", Map.of("whitelist", this.lastSearch + (String)(this.tagFilter.equals("miscellaneous") ? "" : "," + this.tagFilter), "blacklist", "", "order", this.order.key(), "track", this.tab == Tab.FAVORITES ? "likes" : (this.tab == Tab.SUBMISSIONS ? "submissions" : "all"), "descending", "true", "offset", String.valueOf(this.page * 8), "limit", String.valueOf(8)));
                if (response instanceof ContentListResponse) {
                    ContentListResponse contentListResponse = (ContentListResponse)response;
                    this.furniture = Arrays.stream(contentListResponse.contents()).map(c -> ResourceLocation.fromNamespaceAndPath((String)"library", (String)(c.contentid() + "." + c.version()))).collect(Collectors.toList());
                    Minecraft.getInstance().execute(this::init);
                } else {
                    this.setError("gui.immersive_furniture.list_fetch_failed");
                }
                this.awaitingSearch = false;
            });
        }
    }

    private void publish(FurnitureData data) {
        if (this.uploading) {
            return;
        }
        this.uploading = true;
        CompletableFuture.runAsync(() -> {
            if (!Auth.hasToken()) {
                return;
            }
            LinkedList<String> tags = new LinkedList<String>();
            tags.add(data.tag);
            if (data.hasParticles()) {
                tags.add("has_particles");
            }
            if (data.hasSounds()) {
                tags.add("has_sounds");
            }
            if (data.canSit()) {
                tags.add("can_sit");
            }
            if (data.canSleep()) {
                tags.add("can_sleep");
            }
            if (data.hasDisplayItems()) {
                tags.add("has_display_items");
            }
            if (data.getUniqueSolidStates().size() > 1) {
                tags.add("has_states");
            }
            if (!data.dependencies.isEmpty()) {
                tags.add("has_dependencies");
            }
            if (!data.sources.isEmpty()) {
                tags.add("has_modded_textures");
            }
            if (data.inventorySize > 0) {
                tags.add("has_inventory");
            }
            if (data.lightLevel > 0) {
                tags.add("is_light_source");
            }
            tags.addAll(data.elements.stream().filter(e -> e.type == FurnitureData.ElementType.ELEMENT).map(e -> e.material.source.getPath()).distinct().toList());
            Response request = API.request(data.contentid == -1 ? API.HttpMethod.POST : API.HttpMethod.PUT, data.contentid == -1 ? ContentIdResponse::new : SuccessResponse::new, (String)(data.contentid == -1 ? "content/furniture" : "content/furniture/" + data.contentid), Map.of(), Map.of("title", data.name, "meta", "{}", "data", new String(Base64.getEncoder().encode(Utils.toBytes(data.toTag()))), "tags", tags));
            if (request instanceof ContentIdResponse) {
                ContentIdResponse response = (ContentIdResponse)request;
                data.contentid = response.contentid();
                FurnitureDataManager.saveLocalFile(data);
                this.selected = null;
                Minecraft.getInstance().execute(() -> this.setTab(Tab.SUBMISSIONS));
            } else if (request instanceof SuccessResponse) {
                this.selected = null;
                this.init();
            } else if (request instanceof ErrorResponse) {
                ErrorResponse response = (ErrorResponse)request;
                if (response.code() == 428) {
                    this.setError("gui.immersive_furniture.upload_duplicate");
                } else {
                    this.setError("gui.immersive_furniture.upload_failed");
                }
            }
            this.uploading = false;
        });
    }

    private /* synthetic */ void lambda$init$0(Tab tab, Button b) {
        this.setTab(tab);
    }

    public static enum SortingMode {
        DATE(88),
        LIKES(66),
        RECOMMENDATIONS(154);

        private final int u;

        private SortingMode(int u) {
            this.u = u;
        }

        public SortingMode cycle() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> LIKES;
                case 1 -> RECOMMENDATIONS;
                case 2 -> DATE;
            };
        }

        public int getU() {
            return this.u;
        }

        public String key() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum Tab {
        LOCAL,
        GLOBAL,
        FAVORITES,
        SUBMISSIONS;

    }
}

