/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.gui.components;

import java.util.Objects;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationEditorScreen;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationScreen;
import net.conczin.immersive_furniture.client.gui.components.ScreenComponent;
import net.conczin.immersive_furniture.client.gui.widgets.LegacyImageButton;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public abstract class ListComponent
extends ScreenComponent {
    static final Component SEARCH_TITLE = Component.translatable((String)"itemGroup.search");
    static final Component SEARCH_HINT = Component.translatable((String)"gui.recipebook.search_hint").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY);
    EditBox searchBox;
    int page = 0;

    public ListComponent(ArtisansWorkstationEditorScreen screen) {
        super(screen);
        assert (this.minecraft.level != null);
        assert (this.minecraft.player != null);
    }

    @Override
    public void init(int leftPos, int topPos, int width, int height) {
        super.init(leftPos, topPos, width, height);
        String oldSearch = this.searchBox != null ? this.searchBox.getValue() : "";
        Font font = this.minecraft.font;
        Objects.requireNonNull(this.minecraft.font);
        this.searchBox = new EditBox(font, leftPos + 6, topPos + 6, width - 12, 9 + 3, SEARCH_TITLE);
        this.searchBox.setMaxLength(50);
        this.searchBox.setVisible(true);
        this.searchBox.setValue(oldSearch);
        this.searchBox.setHint(SEARCH_HINT);
        this.searchBox.setResponder(s -> this.updateSearch());
        this.screen.addRenderableWidget(this.searchBox);
        this.screen.addRenderableWidget(new LegacyImageButton(leftPos + 6, topPos + height - 21, 12, 15, 193, 0, 15, ArtisansWorkstationScreen.TEXTURE, 256, 256, b -> {
            this.page = Math.max(0, this.page - 1);
            this.updateSearch();
        }));
        this.screen.addRenderableWidget(new LegacyImageButton(leftPos + width - 18, topPos + height - 21, 12, 15, 180, 0, 15, ArtisansWorkstationScreen.TEXTURE, 256, 256, b -> {
            ++this.page;
            this.updateSearch();
        }));
        this.updateSearch();
    }

    abstract int getPages();

    abstract void updateSearch();

    public void render(GuiGraphics graphics) {
        graphics.drawCenteredString(this.minecraft.font, String.format("%s / %S", this.page + 1, this.getPages()), this.leftPos + this.width / 2, this.topPos + this.height - 17, 0xFFFFFF);
    }
}

