/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.gui.components;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationEditorScreen;
import net.conczin.immersive_furniture.client.gui.components.ListComponent;
import net.conczin.immersive_furniture.client.gui.widgets.SpriteButton;
import net.conczin.immersive_furniture.client.gui.widgets.StateImageButton;
import net.conczin.immersive_furniture.client.model.TransparencyManager;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.TransparencyType;
import net.conczin.immersive_furniture.mixin.client.SpriteContentsAccessor;
import net.conczin.immersive_furniture.mixin.client.TextureAtlasAccessor;
import net.conczin.immersive_furniture.utils.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public class SpritesComponent
extends ListComponent {
    private final List<SpriteContents> allSprites;
    private List<ResourceLocation> filteredSprites = new LinkedList<ResourceLocation>();
    final List<SpriteButton> spriteButtons = new ArrayList<SpriteButton>();
    private boolean vanillaOnly = true;
    public FilterType filterType = FilterType.ANIMATIONS;

    public SpritesComponent(ArtisansWorkstationEditorScreen screen) {
        super(screen);
        TextureAtlas atlas = Minecraft.getInstance().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS);
        List<SpriteContents> sprites = ((TextureAtlasAccessor)atlas).getSprites();
        this.allSprites = sprites.stream().filter(SpritesComponent::sanityFilter).filter(SpritesComponent::isSquare).toList();
    }

    private static boolean sanityFilter(SpriteContents s) {
        if (s.name().getPath().endsWith("_side")) {
            return false;
        }
        if (s.name().getPath().endsWith("_bottom")) {
            return false;
        }
        return !s.name().getPath().endsWith("_top");
    }

    private static boolean isSquare(SpriteContents spriteContents) {
        int height;
        int width = spriteContents.width();
        return width == (height = spriteContents.height()) && Math.pow((int)Math.sqrt(width), 2.0) == (double)width;
    }

    @Override
    public void init(int leftPos, int topPos, int width, int height) {
        int tx = 7;
        int u = 0;
        for (FilterType value : FilterType.values()) {
            StateImageButton button = this.addToggleButton(leftPos + tx, topPos + 22, 16, u, 160, "gui.immersive_furniture.sprite_filter." + value.name().toLowerCase(Locale.ROOT), () -> {
                this.filterType = value;
                this.screen.init();
            });
            button.setEnabled(this.filterType == value);
            tx += 18;
            u += 16;
        }
        this.addToggleButton(leftPos + 80, topPos + 22, 16, 80, 160, "gui.immersive_furniture.vanilla", () -> {
            this.vanillaOnly = !this.vanillaOnly;
            this.screen.init();
        }).setEnabled(this.vanillaOnly);
        FurnitureData.Element firstElement = this.screen.getFirstElement().orElse(null);
        this.spriteButtons.clear();
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 4; ++x) {
                SpriteButton button = new SpriteButton(leftPos + 6 + x * 22, topPos + 44 + y * 22, 22, 22, 146, 0, b -> {
                    ResourceLocation spriteLocation = ((SpriteButton)b).getSpriteLocation();
                    if (spriteLocation != null) {
                        this.screen.selectedElements.forEach(e -> {
                            e.sprite.sprite = spriteLocation;
                        });
                        this.screen.init();
                    }
                });
                button.setEnabled(firstElement != null && button.getSpriteLocation() != null && button.getSpriteLocation().equals((Object)firstElement.sprite.sprite));
                this.spriteButtons.add(button);
                this.screen.addRenderableWidget(button);
            }
        }
        super.init(leftPos, topPos, width, height);
    }

    @Override
    int getPages() {
        return Math.max(0, (this.filteredSprites.size() - 1) / 20 + 1);
    }

    private boolean filter(SpriteContents s) {
        return switch (this.filterType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> {
                if (((SpriteContentsAccessor)s).immersiveFurniture$getFrameCount() > 1) {
                    yield true;
                }
                yield false;
            }
            case 0 -> s.name().toString().contains("item/");
            case 1 -> {
                if (TransparencyManager.INSTANCE.getTransparencyType(s) != TransparencyType.SOLID && TransparencyManager.INSTANCE.isCornerTransparent(s) && !s.name().toString().contains("item/")) {
                    yield true;
                }
                yield false;
            }
            case 3 -> true;
        };
    }

    @Override
    void updateSearch() {
        this.filteredSprites = this.allSprites.stream().filter((? super T s) -> !this.vanillaOnly || s.name().getNamespace().equals("minecraft")).filter((? super T s) -> Utils.search(this.searchBox.getValue(), s.name().toString())).filter(this::filter).map(SpriteContents::name).toList();
        this.page = Math.max(0, Math.min(this.page, this.getPages() - 1));
        TextureAtlas blockAtlas = Minecraft.getInstance().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS);
        for (int i = 0; i < this.spriteButtons.size(); ++i) {
            int li = i + this.page * this.spriteButtons.size();
            if (li < this.filteredSprites.size()) {
                ResourceLocation location = this.filteredSprites.get(li);
                TextureAtlasSprite sprite = blockAtlas.getSprite(location);
                this.spriteButtons.get(i).setSpriteLocation(location);
                this.spriteButtons.get(i).setSprite(sprite);
                this.spriteButtons.get(i).setEnabled(!this.screen.selectedElements.isEmpty());
                continue;
            }
            this.spriteButtons.get(i).setSpriteLocation(null);
            this.spriteButtons.get(i).setSprite(null);
            this.spriteButtons.get(i).setEnabled(false);
        }
    }

    public static enum FilterType {
        ITEMS,
        SPRITES,
        ANIMATIONS,
        ALL;

    }
}

