/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.gui.widgets;

import com.mojang.math.Axis;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class ColorSliderWidget
extends AbstractWidget {
    private final Consumer<Double> consumer;
    double value;
    int color0;
    int color1;

    public ColorSliderWidget(int x, int y, int width, int height, double value, Consumer<Double> consumer) {
        super(x, y, width, height, (Component)Component.literal((String)""));
        this.consumer = consumer;
        this.value = value;
    }

    protected void drawInnerWidget(GuiGraphics graphics) {
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.getX(), (float)(this.getY() + this.getHeight()), 0.0f);
        graphics.pose().rotateAround(Axis.ZP.rotationDegrees(-90.0f), 0.0f, 0.0f, 0.0f);
        graphics.fillGradient(0, 0, this.getHeight(), this.getWidth(), this.color0, this.color1);
        graphics.pose().popPose();
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.drawInnerWidget(graphics);
        graphics.renderOutline(this.getX(), this.getY(), this.getWidth(), this.getHeight(), -16777216);
        int x = (int)((double)this.getX() + this.value * (double)this.getWidth());
        graphics.fill(x - 1, this.getY(), x + 1, this.getY() + this.getHeight(), -16777216);
    }

    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        this.update(mouseX);
        super.onDrag(mouseX, mouseY, dragX, dragY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isInArea(mouseX, mouseY)) {
            this.update(mouseX);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private boolean isInArea(double mouseX, double mouseY) {
        return mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + this.width) && mouseY >= (double)this.getY() && mouseY <= (double)(this.getY() + this.height);
    }

    void update(double mouseX) {
        this.value = Mth.clamp((double)((mouseX - (double)this.getX()) / (double)this.width), (double)0.0, (double)1.0);
        this.consumer.accept(this.value);
    }

    protected void updateWidgetNarration(NarrationElementOutput narration) {
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void setColor(int color0, int color1) {
        this.color0 = color0;
        this.color1 = color1;
    }
}

