/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationScreen;
import net.conczin.immersive_furniture.client.gui.widgets.StateImageButton;
import net.conczin.immersive_furniture.client.model.MaterialSource;
import net.conczin.immersive_furniture.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class MaterialButton
extends StateImageButton {
    MaterialSource material;

    public MaterialButton(int x, int y, int width, int height, int xTexStart, int yTexStart, Button.OnPress onPress) {
        super(x, y, width, height, xTexStart, yTexStart, ArtisansWorkstationScreen.TEXTURE, 256, 256, onPress, (Component)Component.literal((String)""));
    }

    public MaterialSource getMaterial() {
        return this.material;
    }

    public void setMaterial(MaterialSource material) {
        this.material = material;
        if (material != null) {
            Component name = material.name();
            this.setMessage(name);
            MutableComponent namespaceTooltip = Component.literal((String)Utils.capitalize(material.location().getNamespace())).withStyle(ChatFormatting.GRAY);
            this.setTooltip(Tooltip.create((Component)name.copy().append("\n").append((Component)namespaceTooltip)));
        } else {
            this.setMessage((Component)Component.literal((String)""));
            this.setTooltip(Tooltip.create((Component)Component.literal((String)"")));
        }
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.material == null) {
            return;
        }
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        TextureAtlasSprite up = this.material.up().sprite();
        TextureAtlasSprite north = this.material.north().sprite();
        TextureAtlasSprite east = this.material.east().sprite();
        float size = (float)this.width * 0.4f * (mouseX > this.getX() && mouseX < this.getX() + this.width && mouseY > this.getY() && mouseY < this.getY() + this.height ? 1.1f : 1.0f);
        float x = (float)this.getX() + (float)this.width / 2.0f;
        float y = (float)this.getY() + (float)this.height / 2.0f - size / 4.0f * 2.5f;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)up.atlasLocation());
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        Matrix4f matrix4f = graphics.pose().last().pose();
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        float lx = x - size;
        float rx = x + size;
        float py = y - size / 2.0f;
        float cy = y + size / 2.0f;
        float by = y + size / 4.0f * 5.0f;
        float ry = y + size / 4.0f * 7.0f;
        bufferBuilder.addVertex(matrix4f, x, py, 0.0f).setUv(up.getU0(), up.getV1()).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, lx, y, 0.0f).setUv(up.getU1(), up.getV1()).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, x, cy, 0.0f).setUv(up.getU1(), up.getV0()).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, rx, y, 0.0f).setUv(up.getU0(), up.getV0()).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        float ng = 0.8f;
        bufferBuilder.addVertex(matrix4f, rx, y, 0.0f).setUv(north.getU1(), north.getV0()).setColor(ng, ng, ng, 1.0f);
        bufferBuilder.addVertex(matrix4f, x, cy, 0.0f).setUv(north.getU0(), north.getV0()).setColor(ng, ng, ng, 1.0f);
        bufferBuilder.addVertex(matrix4f, x, ry, 0.0f).setUv(north.getU0(), north.getV1()).setColor(ng, ng, ng, 1.0f);
        bufferBuilder.addVertex(matrix4f, rx, by, 0.0f).setUv(north.getU1(), north.getV1()).setColor(ng, ng, ng, 1.0f);
        float eg = 0.6f;
        bufferBuilder.addVertex(matrix4f, x, cy, 0.0f).setUv(east.getU1(), east.getV0()).setColor(eg, eg, eg, 1.0f);
        bufferBuilder.addVertex(matrix4f, lx, y, 0.0f).setUv(east.getU0(), east.getV0()).setColor(eg, eg, eg, 1.0f);
        bufferBuilder.addVertex(matrix4f, lx, by, 0.0f).setUv(east.getU0(), east.getV1()).setColor(eg, eg, eg, 1.0f);
        bufferBuilder.addVertex(matrix4f, x, ry, 0.0f).setUv(east.getU1(), east.getV1()).setColor(eg, eg, eg, 1.0f);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
    }
}

