/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationScreen;
import net.conczin.immersive_furniture.client.gui.widgets.StateImageButton;
import net.conczin.immersive_furniture.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class SpriteButton
extends StateImageButton {
    private ResourceLocation spriteLocation;
    private TextureAtlasSprite sprite;

    public SpriteButton(int x, int y, int width, int height, int xTexStart, int yTexStart, Button.OnPress onPress) {
        super(x, y, width, height, xTexStart, yTexStart, ArtisansWorkstationScreen.TEXTURE, 256, 256, onPress, (Component)Component.literal((String)""));
    }

    public ResourceLocation getSpriteLocation() {
        return this.spriteLocation;
    }

    public void setSpriteLocation(ResourceLocation spriteLocation) {
        this.spriteLocation = spriteLocation;
        if (spriteLocation != null) {
            MutableComponent message = Component.literal((String)Utils.capitalize(spriteLocation));
            this.setMessage((Component)message);
            MutableComponent namespaceTooltip = Component.literal((String)Utils.capitalize(spriteLocation.getNamespace())).withStyle(ChatFormatting.GRAY);
            this.setTooltip(Tooltip.create((Component)message.copy().append("\n").append((Component)namespaceTooltip)));
        }
    }

    public void setSprite(TextureAtlasSprite sprite) {
        this.sprite = sprite;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.sprite == null) {
            return;
        }
        TextureAtlas atlas = Minecraft.getInstance().getModelManager().getAtlas(this.sprite.atlasLocation());
        TextureAtlasSprite sprite = atlas.getSprite(this.sprite.contents().name());
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        float size = (float)this.width * 0.8f * (this.isHovered ? 1.1f : 1.0f);
        float x = (float)this.getX() + (float)this.width / 2.0f - size / 2.0f;
        float y = (float)this.getY() + (float)this.height / 2.0f - size / 2.0f;
        boolean blitOffset = false;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix4f = graphics.pose().last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix4f, x, y, (float)blitOffset).setUv(sprite.getU0(), sprite.getV0());
        bufferbuilder.addVertex(matrix4f, x, y + size, (float)blitOffset).setUv(sprite.getU0(), sprite.getV1());
        bufferbuilder.addVertex(matrix4f, x + size, y + size, (float)blitOffset).setUv(sprite.getU1(), sprite.getV1());
        bufferbuilder.addVertex(matrix4f, x + size, y, (float)blitOffset).setUv(sprite.getU1(), sprite.getV0());
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }
}

