/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;

public class CompositeBakedModel
implements BakedModel {
    private final Map<RenderType, BakedModel> models;
    private final BakedModel any;
    private final List<BakedQuad> quads;

    public CompositeBakedModel(Map<RenderType, BakedModel> models) {
        this.models = models;
        this.any = models.values().stream().findAny().orElse(this.getMissing());
        this.quads = models.values().stream().flatMap(model -> model.getQuads(null, null, RandomSource.create()).stream()).toList();
    }

    public List<BakedQuad> getQuads(BlockState blockState, Direction direction, RandomSource randomSource) {
        return this.quads;
    }

    public boolean useAmbientOcclusion() {
        return this.any.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.any.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.any.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return this.any.isCustomRenderer();
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.any.getParticleIcon();
    }

    public ItemTransforms getTransforms() {
        return this.any.getTransforms();
    }

    public ItemOverrides getOverrides() {
        return this.any.getOverrides();
    }

    private BakedModel getMissing() {
        TextureAtlas atlas = Minecraft.getInstance().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS);
        TextureAtlasSprite sprite = atlas.getSprite(MissingTextureAtlasSprite.getLocation());
        return new SimpleBakedModel(List.of(), Map.of(), false, false, false, sprite, ItemTransforms.NO_TRANSFORMS, ItemOverrides.EMPTY);
    }

    public Map<RenderType, BakedModel> getModels() {
        return this.models;
    }
}

