/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.model;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.conczin.immersive_furniture.Common;
import net.conczin.immersive_furniture.client.model.CompositeBakedModel;
import net.conczin.immersive_furniture.client.model.CompositeBlockModel;
import net.conczin.immersive_furniture.client.model.DynamicAtlas;
import net.conczin.immersive_furniture.client.model.FurnitureModelFactory;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.utils.CachedSupplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;

public class FurnitureModelBaker {
    private static final ModelBakerImpl modelBaker = new ModelBakerImpl();
    private static final RandomSource random = RandomSource.create();

    private static CompositeBakedModel bakeModel(DynamicAtlas atlas, CompositeBlockModel model, int yRot, int state) {
        LinkedHashMap<RenderType, BakedModel> bakedModels = new LinkedHashMap<RenderType, BakedModel>();
        for (RenderType type : model.models.get(state).keySet()) {
            bakedModels.put(type, FurnitureModelBaker.bakeModel(atlas, model, type, yRot, state));
        }
        return new CompositeBakedModel(bakedModels);
    }

    private static BakedModel bakeModel(DynamicAtlas atlas, CompositeBlockModel model, RenderType type, int yRot, int state) {
        BakedModel bake = model.models.get(state).get(type).bake((ModelBaker)modelBaker, material -> atlas == DynamicAtlas.BAKED || !material.texture().getNamespace().equals("immersive_furniture") ? material.sprite() : atlas.sprite, (ModelState)BlockModelRotation.by((int)0, (int)yRot));
        for (BakedQuad quad : bake.getQuads(null, null, random)) {
            int[] vertices = quad.getVertices();
            for (int i = 0; i < vertices.length; i += 8) {
                FurnitureData.Element element = model.getElement(quad.getTintIndex());
                vertices[i + 3] = element.color;
                vertices[i + 6] = element.emission << 20 | element.emission << 4;
            }
        }
        return bake;
    }

    public static CompositeBakedModel getAsyncModel(FurnitureData data, DynamicAtlas atlas, int state) {
        String hash = data.getHash();
        if (atlas.knownFurniture.containsKey(hash)) {
            return FurnitureModelBaker.getModel(data, hash, atlas, 0, state, false);
        }
        if (!atlas.asyncRequestedFurniture.contains(hash)) {
            atlas.asyncRequestedFurniture.add(hash);
            Common.EXECUTOR.execute(() -> {
                FurnitureModelBaker.getModel(data, hash, atlas, 0, state, false);
                atlas.asyncRequestedFurniture.remove(hash);
            });
        }
        return null;
    }

    public static CompositeBakedModel getModel(FurnitureData data, DynamicAtlas atlas) {
        return FurnitureModelBaker.getModel(data, data.getHash(), atlas, 0, 0, true);
    }

    public static CompositeBakedModel getModel(FurnitureData data, String hash, DynamicAtlas atlas, int yRot, int state, boolean force) {
        boolean exist;
        CachedBakedModelSet cachedBakedModelSet = atlas.knownFurniture.get(hash);
        boolean bl = exist = cachedBakedModelSet != null;
        if (!force && !exist && atlas.isFull()) {
            return null;
        }
        if (exist) {
            atlas.uploadIfDirty();
            return cachedBakedModelSet.get(yRot, state);
        }
        float previousUsage = atlas.getUsage();
        CompositeBlockModel model = FurnitureModelFactory.getModel(data, atlas);
        atlas.uploadIfDirty();
        CachedBakedModelSet modelSet = new CachedBakedModelSet(atlas, model);
        if (hash.equals(data.computeHash())) {
            atlas.knownFurniture.put(hash, modelSet);
        }
        if (force || !atlas.isFull() && atlas.getUsage() >= previousUsage) {
            return modelSet.get(yRot, state);
        }
        atlas.knownFurniture.remove(hash);
        return null;
    }

    static class ModelBakerImpl
    implements ModelBaker {
        ModelBakerImpl() {
        }

        public UnbakedModel getModel(ResourceLocation location) {
            return null;
        }

        public BakedModel bake(ResourceLocation location, ModelState transform) {
            return null;
        }

        public BakedModel bake(ResourceLocation var1, ModelState var2, Function<Material, TextureAtlasSprite> var3) {
            return null;
        }

        public Function<Material, TextureAtlasSprite> getModelTextureGetter() {
            return null;
        }

        public UnbakedModel getTopLevelModel(ModelResourceLocation location) {
            return null;
        }

        public BakedModel bakeUncached(UnbakedModel model, ModelState state, Function<Material, TextureAtlasSprite> sprites) {
            return null;
        }
    }

    public static class CachedBakedModelSet {
        private static final Supplier<CompositeBakedModel> EMPTY = () -> new CompositeBakedModel(Map.of());
        public final Map<Integer, Supplier<CompositeBakedModel>> variations = new HashMap<Integer, Supplier<CompositeBakedModel>>();

        public CachedBakedModelSet(DynamicAtlas atlas, CompositeBlockModel model) {
            for (int rot = 0; rot < 360; rot += 90) {
                for (Integer state : model.models.keySet()) {
                    int finalRot = rot;
                    this.variations.put(rot + state, new CachedSupplier<CompositeBakedModel>(() -> FurnitureModelBaker.bakeModel(atlas, model, finalRot, state)));
                }
            }
        }

        public CompositeBakedModel get(int yRot, int state) {
            return this.variations.getOrDefault(yRot + state, this.variations.getOrDefault(yRot, EMPTY)).get();
        }
    }
}

