/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.model;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.conczin.immersive_furniture.client.model.DynamicAtlas;
import net.conczin.immersive_furniture.client.model.MaterialSource;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;

public class MaterialRegistry {
    public static final MaterialRegistry INSTANCE = new MaterialRegistry();
    public final Map<ResourceLocation, MaterialSource> materials = new ConcurrentHashMap<ResourceLocation, MaterialSource>();

    public void sync() {
        for (Block block : BuiltInRegistries.BLOCK) {
            BlockState state = block.defaultBlockState();
            if (state.getRenderShape() != RenderShape.MODEL) continue;
            try {
                MaterialSource source = MaterialSource.create(state);
                if (source == null) continue;
                this.materials.put(source.location(), source);
            }
            catch (Exception exception) {}
        }
        DynamicAtlas.SCRATCH.clear();
    }
}

