/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.data;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import net.conczin.immersive_furniture.Common;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.api.API;
import net.conczin.immersive_furniture.data.api.responses.ContentResponse;
import net.conczin.immersive_furniture.data.api.responses.Response;
import net.conczin.immersive_furniture.network.Network;
import net.conczin.immersive_furniture.network.c2s.FurnitureDataRequest;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;

public class FurnitureDataManager {
    public static final Path gameRoot = Path.of("./immersive_furniture", new String[0]);
    public static Path worldRoot = Path.of("./immersive_furniture", new String[0]);
    public static final Map<ResourceLocation, FurnitureData> DATA = new ConcurrentHashMap<ResourceLocation, FurnitureData>();
    public static final Set<ResourceLocation> REQUESTED_DATA = ConcurrentHashMap.newKeySet();
    private static final Set<String> alreadySaved = new ConcurrentSkipListSet<String>();

    public static void setWorldRoot(Path worldPath) {
        worldRoot = worldPath.resolve("immersive_furniture").normalize();
        alreadySaved.clear();
    }

    public static void setWorldRoot() {
        worldRoot = gameRoot;
        alreadySaved.clear();
    }

    private static File getFile(ResourceLocation id) {
        String path = id.getNamespace() + "/" + id.getPath() + ".nbt";
        File oldFile = gameRoot.resolve(path).toFile();
        if (oldFile.exists()) {
            return oldFile;
        }
        File file = oldFile;
        if (id.getNamespace().equals("hash")) {
            file = worldRoot.resolve(path).toFile();
        }
        file.getParentFile().mkdirs();
        return file;
    }

    private static void delete(File file) {
        file.delete();
    }

    public static String toSafeName(String input) {
        String safe = input.replaceAll("[^a-z0-9_\\-.]", "_");
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(input.getBytes());
            StringBuilder hex = new StringBuilder();
            for (byte b : hash) {
                hex.append(String.format("%02x", b));
            }
            return safe + "_" + String.valueOf(hex);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<ResourceLocation> getLocalFiles() {
        File cache = new File("./immersive_furniture/local");
        File[] files = cache.listFiles();
        if (files == null) {
            return List.of();
        }
        return Arrays.stream(files).filter(p -> p.getPath().endsWith(".nbt")).sorted((a, b) -> Long.compare(b.lastModified(), a.lastModified())).map(p -> ResourceLocation.fromNamespaceAndPath((String)"local", (String)p.getName().replace(".nbt", ""))).toList();
    }

    public static ResourceLocation getSafeLocalLocation(FurnitureData data) {
        return ResourceLocation.fromNamespaceAndPath((String)"local", (String)FurnitureDataManager.toSafeName(data.name.toLowerCase(Locale.ROOT)));
    }

    public static boolean localFileExists(FurnitureData data) {
        return FurnitureDataManager.getFile(FurnitureDataManager.getSafeLocalLocation(data)).exists();
    }

    public static void deleteLocalFile(ResourceLocation location) {
        FurnitureDataManager.delete(FurnitureDataManager.getFile(location));
    }

    public static void saveLocalFile(FurnitureData data) {
        FurnitureDataManager.save(data, FurnitureDataManager.getSafeLocalLocation(data));
    }

    public static void save(FurnitureData data, ResourceLocation id) {
        File cache = FurnitureDataManager.getFile(id);
        try {
            NbtIo.writeCompressed((CompoundTag)data.toTag(), (Path)cache.toPath());
            DATA.put(id, data);
        }
        catch (IOException e) {
            Common.logger.error("Failed to save local file: {}", (Object)cache.getPath(), (Object)e);
        }
    }

    public static void saveHashData(FurnitureData data) {
        String hash = data.getHash();
        if (alreadySaved.contains(hash)) {
            return;
        }
        alreadySaved.add(hash);
        FurnitureDataManager.save(data, ResourceLocation.fromNamespaceAndPath((String)"hash", (String)data.getHash()));
    }

    public static FurnitureData getData(String hash) {
        ResourceLocation cachedLocation = ResourceLocation.fromNamespaceAndPath((String)"cache", (String)hash);
        if (DATA.containsKey(cachedLocation)) {
            return DATA.get(cachedLocation);
        }
        return FurnitureDataManager.getHashData(hash);
    }

    public static FurnitureData getCachedData(String hash) {
        return FurnitureDataManager.getData(ResourceLocation.fromNamespaceAndPath((String)"cache", (String)hash));
    }

    public static FurnitureData getHashData(String hash) {
        return FurnitureDataManager.getData(ResourceLocation.fromNamespaceAndPath((String)"hash", (String)hash));
    }

    public static FurnitureData getData(ResourceLocation id) {
        if (!DATA.containsKey(id) && !REQUESTED_DATA.contains(id)) {
            REQUESTED_DATA.add(id);
            File cache = FurnitureDataManager.getFile(id);
            if (cache.exists()) {
                try {
                    CompoundTag tag = NbtIo.readCompressed((Path)cache.toPath(), (NbtAccounter)NbtAccounter.unlimitedHeap());
                    FurnitureData data = new FurnitureData(tag);
                    DATA.put(id, data);
                }
                catch (IOException e) {
                    FurnitureDataManager.delete(cache);
                    Common.logger.error("Failed to read file: {}", (Object)cache, (Object)e);
                }
            }
            if (id.getNamespace().equals("library")) {
                int version;
                int contentid;
                try {
                    String[] split = id.getPath().split("\\.");
                    contentid = Integer.parseInt(split[0]);
                    version = Integer.parseInt(split[1]);
                }
                catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                    Common.logger.error("Failed to parse content id and version from: {}", (Object)id, (Object)e);
                    return null;
                }
                CompletableFuture.runAsync(() -> {
                    Response response = API.request(API.HttpMethod.GET, ContentResponse::new, "content/furniture/" + contentid, Map.of("version", String.valueOf(version)));
                    if (response instanceof ContentResponse) {
                        ContentResponse contentResponse = (ContentResponse)response;
                        ByteArrayInputStream in = new ByteArrayInputStream(Base64.getDecoder().decode(contentResponse.content().data()));
                        try {
                            FurnitureData data = new FurnitureData(NbtIo.readCompressed((InputStream)in, (NbtAccounter)NbtAccounter.unlimitedHeap()));
                            data.contentid = contentid;
                            data.author = contentResponse.content().username();
                            NbtIo.writeCompressed((CompoundTag)data.toTag(), (Path)FurnitureDataManager.getFile(id).toPath());
                            DATA.put(id, data);
                        }
                        catch (Exception e) {
                            Common.logger.error("Failed to read content response: {}", (Object)contentResponse, (Object)e);
                        }
                    }
                });
            } else if (id.getNamespace().equals("cache")) {
                Network.sendToServer(new FurnitureDataRequest(id.getPath()));
            }
        }
        return DATA.get(id);
    }
}

