/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.mixin;

import java.util.Optional;
import net.conczin.immersive_furniture.InteractionManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract Optional<BlockPos> getSleepingPos();

    @Shadow
    public abstract boolean isSleeping();

    @Inject(method={"checkBedExists()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void immersiveFurniture$checkBedExists(CallbackInfoReturnable<Boolean> cir) {
        Optional<BlockPos> sleepingPos = this.getSleepingPos();
        if (sleepingPos.isPresent() && InteractionManager.isFurnitureBed(this.level(), sleepingPos.get())) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"setPosToBed(Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void immersiveFurniture$setPosToBed(BlockPos pos, CallbackInfo ci) {
        if (InteractionManager.isFurnitureBed(this.level(), pos)) {
            this.immersiveFurniture$MoveToBed();
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void immersiveFurniture$tick(CallbackInfo ci) {
        if (this.isSleeping()) {
            this.immersiveFurniture$MoveToBed();
        }
    }

    @Unique
    private void immersiveFurniture$MoveToBed() {
        InteractionManager.Interaction interaction = InteractionManager.INSTANCE.getInteraction((LivingEntity)this);
        if (interaction != null) {
            float rotation = interaction.offset().rotation();
            this.setYRot(-rotation - 90.0f);
            this.setYBodyRot(-rotation - 90.0f);
            this.setYHeadRot(-rotation - 90.0f);
            this.setPos((float)interaction.pos().getX() + interaction.offset().offset().x(), (float)interaction.pos().getY() + interaction.offset().offset().y(), (float)interaction.pos().getZ() + interaction.offset().offset().z());
        }
    }

    @Inject(method={"getBedOrientation()Lnet/minecraft/core/Direction;"}, at={@At(value="HEAD")}, cancellable=true)
    private void immersiveFurniture$getBedOrientation(CallbackInfoReturnable<Direction> cir) {
        InteractionManager.Interaction interaction = InteractionManager.INSTANCE.getInteraction((LivingEntity)this);
        if (interaction != null) {
            cir.setReturnValue(null);
        }
    }
}

