/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.conczin.immersive_furniture.block.BaseFurnitureBlock;
import net.conczin.immersive_furniture.block.FurnitureProxyBlock;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;

public class InteractionManager {
    public static final InteractionManager INSTANCE = new InteractionManager();
    private final Map<UUID, Interaction> interactions = new ConcurrentHashMap<UUID, Interaction>();

    public void addInteraction(class_1297 entity, class_2338 pos, FurnitureData.PoseOffset offset) {
        this.interactions.put(entity.method_5667(), new Interaction(pos, offset));
    }

    public Interaction getInteraction(class_1309 entity) {
        Interaction interaction = this.interactions.get(entity.method_5667());
        if (interaction != null) {
            Optional sleepingPos = entity.method_18398();
            if (sleepingPos.isPresent() && !((class_2338)sleepingPos.get()).equals((Object)interaction.pos)) {
                this.clearInteraction((class_1297)entity);
                return null;
            }
            class_1937 level = entity.method_37908();
            if (InteractionManager.isFurnitureBed(level, interaction.pos())) {
                return interaction;
            }
            this.clearInteraction((class_1297)entity);
        }
        return null;
    }

    public static boolean isFurnitureBed(class_1937 level, class_2338 pos) {
        class_2248 block = level.method_8320(pos).method_26204();
        return block instanceof BaseFurnitureBlock || block instanceof FurnitureProxyBlock;
    }

    public void clearInteraction(class_1297 entity) {
        this.interactions.remove(entity.method_5667());
    }

    public void clearInteraction() {
        this.interactions.clear();
    }

    public record Interaction(class_2338 pos, FurnitureData.PoseOffset offset) {
    }
}

