/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.gui;

import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.StringConcatFactory;
import java.util.Arrays;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.conczin.immersive_furniture.Common;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationEditorScreen;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationScreen;
import net.conczin.immersive_furniture.client.gui.components.SettingsComponent;
import net.conczin.immersive_furniture.client.gui.widgets.StateImageButton;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.FurnitureDataManager;
import net.conczin.immersive_furniture.data.api.API;
import net.conczin.immersive_furniture.data.api.Auth;
import net.conczin.immersive_furniture.data.api.responses.ContentIdResponse;
import net.conczin.immersive_furniture.data.api.responses.ContentListResponse;
import net.conczin.immersive_furniture.data.api.responses.ErrorResponse;
import net.conczin.immersive_furniture.data.api.responses.IsAuthResponse;
import net.conczin.immersive_furniture.data.api.responses.Response;
import net.conczin.immersive_furniture.data.api.responses.SuccessResponse;
import net.conczin.immersive_furniture.item.Items;
import net.conczin.immersive_furniture.network.Network;
import net.conczin.immersive_furniture.network.c2s.CraftRequest;
import net.conczin.immersive_furniture.utils.Utils;
import net.minecraft.class_124;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7919;

public class ArtisansWorkstationLibraryScreen
extends ArtisansWorkstationScreen {
    static final class_2561 SEARCH_TITLE = class_2561.method_43471((String)"itemGroup.search");
    static final class_2561 SEARCH_HINT = class_2561.method_43471((String)"gui.recipebook.search_hint").method_27692(class_124.field_1056).method_27692(class_124.field_1080);
    static final int ENTRIES_PER_PAGE = 8;
    private boolean uploading = false;
    private boolean awaitingAuthentication = false;
    private boolean awaitingSearch = false;
    private boolean shouldSearch = true;
    private String lastSearch = "";
    private boolean authenticating;
    private boolean isBrowserOpen = false;
    private boolean authenticated = false;
    private SortingMode order = SortingMode.RECOMMENDATIONS;
    private String tagFilter = "miscellaneous";
    Tab tab = Tab.GLOBAL;
    int page = 0;
    List<class_2960> furniture = new LinkedList<class_2960>();
    List<class_2960> localFiles = FurnitureDataManager.getLocalFiles();
    class_2960 selected = null;
    int lastMouseX;
    int lastMouseY;
    float previewYaw = 0.0f;
    float previewPitch = 0.0f;

    public ArtisansWorkstationLibraryScreen() {
        this.authenticating = Auth.loadToken() != null;
        FurnitureDataManager.REQUESTED_DATA.clear();
    }

    public boolean method_25421() {
        return false;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        if (this.selected == null) {
            String text;
            int w = (this.windowWidth - 4) / 4;
            int x = this.leftPos;
            for (Tab tab : Tab.values()) {
                text = "gui.immersive_furniture.tab." + tab.name().toLowerCase(Locale.ROOT);
                this.method_37063(class_4185.method_46430((class_2561)class_2561.method_43471((String)text), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$init$0(net.conczin.immersive_furniture.client.gui.ArtisansWorkstationLibraryScreen$Tab net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)((ArtisansWorkstationLibraryScreen)this, (Tab)tab)).method_46434((int)(x + 2), (int)(this.topPos - 19), (int)w, (int)20).method_46436((class_7919)class_7919.method_47407((class_2561)class_2561.method_43471((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001.hint"}, (String)text))))).method_46431()).field_22763 = tab != this.tab;
                x += w;
            }
            Objects.requireNonNull(this.field_22793);
            class_342 searchBox = new class_342(this.field_22793, this.leftPos + 5, this.topPos + 5, this.windowWidth - 64 - 12, 9 + 3, SEARCH_TITLE);
            searchBox.method_1880(50);
            searchBox.method_1862(true);
            searchBox.method_1852(this.lastSearch);
            searchBox.method_47404(SEARCH_HINT);
            searchBox.method_1863(s -> {
                if (!s.equals(this.lastSearch)) {
                    this.lastSearch = s;
                    this.shouldSearch = true;
                }
            });
            this.method_37063(searchBox);
            this.method_48265((class_364)searchBox);
            int i = 0;
            int tx = this.leftPos + 4;
            for (String tag : SettingsComponent.TAGS) {
                this.addToggleButton(tx, this.topPos + 18, 16, i * 16, 224, "gui.immersive_furniture.tag." + tag.toLowerCase(Locale.ROOT), b -> {
                    this.tagFilter = tag;
                    this.shouldSearch = true;
                    b.setEnabled(true);
                }).setEnabled(tag.equals(this.tagFilter));
                tx += 17;
                ++i;
            }
            int y = this.topPos + this.windowHeight - 25;
            this.method_37063(new class_344(this.leftPos + 3, y, 22, 22, this.order.getU(), 114, 22, TEXTURE, 256, 256, b -> {
                this.order = this.order.cycle();
                this.shouldSearch = true;
                this.method_25426();
            })).method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)("gui.immersive_furniture.sort." + this.order.key()))));
            this.method_37063(new class_344(this.leftPos + this.windowWidth / 2 - 24 - 6, y + 4, 12, 15, 193, 0, 15, TEXTURE, 256, 256, b -> {
                this.page = Math.max(0, this.page - 1);
                this.shouldSearch = true;
                this.method_25426();
            }));
            this.method_37063(new class_344(this.leftPos + this.windowWidth / 2 + 24 - 6, y + 4, 12, 15, 180, 0, 15, TEXTURE, 256, 256, b -> {
                ++this.page;
                this.shouldSearch = true;
                this.method_25426();
            }));
            text = class_2561.method_43471((String)(this.authenticated || this.authenticating ? "gui.immersive_furniture.logout" : "gui.immersive_furniture.login"));
            this.method_37063(class_4185.method_46430((class_2561)text, b -> {
                if (this.authenticated || this.authenticating) {
                    Auth.clearToken();
                    this.authenticated = false;
                    this.authenticating = false;
                } else {
                    Auth.authenticate(this.getPlayerName());
                    this.authenticating = true;
                    this.isBrowserOpen = true;
                }
                this.method_25426();
            }).method_46434(this.leftPos + this.windowWidth - 64 - 4, this.topPos + 4, 64, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.immersive_furniture.login.tooltip"))).method_46431());
            this.method_37063(class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.immersive_furniture.create"), b -> {
                if (this.field_22787 != null) {
                    this.field_22787.method_1507((class_437)new ArtisansWorkstationEditorScreen(new FurnitureData()));
                }
            }).method_46434(this.leftPos + this.windowWidth - 64 - 4, this.topPos + this.windowHeight - 24, 64, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.immersive_furniture.create.hint"))).method_46431());
        } else {
            int x = this.leftPos + this.windowWidth / 2;
            int y = this.topPos + this.windowHeight - 25;
            if (!this.selected.method_12836().equals("local")) {
                this.addToggleButton(x - 50 - 11, y, 22, 0, 114, "gui.immersive_furniture.favorite", b -> {
                    if (this.authenticated) {
                        FurnitureData model = FurnitureDataManager.getData(this.selected);
                        if (model != null) {
                            if (!b.isEnabled()) {
                                API.request(API.HttpMethod.DELETE, "like/furniture/" + model.contentid);
                            } else {
                                API.request(API.HttpMethod.POST, "like/furniture/" + model.contentid);
                            }
                            b.setEnabled(!b.isEnabled());
                        }
                    } else {
                        this.setError("gui.immersive_furniture.login_required");
                    }
                }).setEnabled(this.tab != Tab.FAVORITES);
            }
            if (this.selected.method_12836().equals("local")) {
                this.addButton(x - 25 - 11, y, 22, 132, 114, "gui.immersive_furniture.publish", () -> {
                    if (this.authenticated) {
                        FurnitureData model = FurnitureDataManager.getData(this.selected);
                        if (model != null) {
                            this.publish(model);
                        }
                    } else {
                        this.setError("gui.immersive_furniture.login_required");
                    }
                });
            }
            if (this.tab == Tab.SUBMISSIONS || this.tab == Tab.LOCAL) {
                this.addButton(x - 11, y, 22, 44, 114, "gui.immersive_furniture.delete", this::delete);
            }
            this.addButton(x + 25 - 11, y, 22, 22, 114, "gui.immersive_furniture.modify", () -> {
                FurnitureData data = FurnitureDataManager.getData(this.selected);
                if (this.field_22787 != null && data != null) {
                    this.field_22787.method_1507((class_437)new ArtisansWorkstationEditorScreen(new FurnitureData(data)));
                }
            });
            if (this.tab == Tab.GLOBAL) {
                this.addToggleButton(x + 50 - 11, y, 22, 110, 114, "gui.immersive_furniture.report", b -> {
                    if (this.authenticated) {
                        FurnitureData model = FurnitureDataManager.getData(this.selected);
                        if (model != null) {
                            if (b.isEnabled()) {
                                API.request(API.HttpMethod.DELETE, "report/furniture/" + model.contentid + "/DEFAULT");
                            } else {
                                API.request(API.HttpMethod.POST, "report/furniture/" + model.contentid + "/DEFAULT");
                            }
                            b.setEnabled(!b.isEnabled());
                        }
                    } else {
                        this.setError("gui.immersive_furniture.login_required");
                    }
                }).setEnabled(false);
            }
            this.method_37063(class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.immersive_furniture.back"), b -> {
                this.selected = null;
                this.method_25426();
            }).method_46434(this.leftPos + 4, this.topPos + this.windowHeight - 24, 64, 20).method_46431());
            this.method_37063(class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.immersive_furniture.craft"), b -> {
                Network.sendToServer(new CraftRequest(FurnitureDataManager.getData(this.selected), this.holdingShift()));
                if (!this.holdingCtrl() && !this.holdingShift()) {
                    class_310.method_1551().method_1507(null);
                }
            }).method_46434(this.leftPos + this.windowWidth - 68, this.topPos + this.windowHeight - 24, 64, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.immersive_furniture.craft.hint"))).method_46431());
        }
    }

    private void delete() {
        if (this.lastCriticalActionAttempt + 5000L > System.currentTimeMillis()) {
            this.clearError();
            if (this.tab == Tab.SUBMISSIONS) {
                FurnitureData model = FurnitureDataManager.getData(this.selected);
                if (model != null) {
                    API.request(API.HttpMethod.DELETE, "content/furniture/" + model.contentid);
                } else {
                    this.setError("gui.immersive_furniture.delete_failed");
                }
            } else {
                FurnitureDataManager.deleteLocalFile(this.selected);
                this.localFiles = FurnitureDataManager.getLocalFiles();
                this.shouldSearch = true;
            }
            this.selected = null;
            this.method_25426();
        } else {
            this.lastCriticalActionAttempt = System.currentTimeMillis();
            this.setError("gui.immersive_furniture.delete_confirm");
        }
    }

    public void method_25420(class_332 graphics) {
        super.method_25420(graphics);
        if (this.selected == null) {
            this.drawRectangle(graphics, this.leftPos, this.topPos, this.windowWidth, 38);
            this.drawRectangle(graphics, this.leftPos, this.topPos + this.windowHeight - 28, this.windowWidth, 28);
        } else {
            this.drawRectangle(graphics, this.leftPos, this.topPos, this.windowWidth, this.windowHeight - 28, 0, 48);
            this.drawRectangle(graphics, this.leftPos, this.topPos + this.windowHeight - 28, this.windowWidth, 28);
        }
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        super.method_25394(graphics, mouseX, mouseY, delta);
        List tooltip = null;
        if (this.selected == null) {
            this.search();
            int w = this.windowWidth / 4;
            int h = (this.windowHeight - 38 - 28) / 2;
            for (int x = 0; x < 4; ++x) {
                for (int y = 0; y < 2; ++y) {
                    FurnitureData data;
                    int i = x + y * 4;
                    boolean hovered = this.isTileHovered(x, y) && i < this.furniture.size();
                    this.drawRectangle(graphics, this.leftPos + x * w, this.topPos + 38 + y * h, w, h, 0, hovered ? 96 : 48);
                    if (i >= this.furniture.size() || (data = FurnitureDataManager.getData(this.furniture.get(i))) == null) continue;
                    float rot = (float)(hovered ? (double)((float)(System.currentTimeMillis() % 10000L) / 10000.0f) * Math.PI * 2.0 : -2.356194490192345);
                    this.renderModel(graphics, data, (double)this.leftPos + ((double)x + 0.5) * (double)w, (double)(this.topPos + 38) + ((double)y + 0.5) * (double)h, h, rot, -0.7853982f);
                    if (!hovered) continue;
                    tooltip = data.getTooltip(class_437.method_25442());
                    tooltip.add(0, (class_2561)class_2561.method_43470((String)data.name).method_27692(class_124.field_1067));
                }
            }
            graphics.method_25300(this.field_22793, String.valueOf(this.page + 1), this.leftPos + this.windowWidth / 2, this.topPos + this.windowHeight - 17, 0xFFFFFF);
        } else {
            FurnitureData data = FurnitureDataManager.getData(this.selected);
            if (data != null) {
                graphics.method_51448().method_22903();
                graphics.method_51448().method_46416(0.0f, 0.0f, 1024.0f);
                graphics.method_44379(this.leftPos + 6, this.topPos + 6, this.leftPos + this.windowWidth - 6, this.topPos + this.windowHeight - 28 - 6);
                this.renderModel(graphics, data, (double)this.leftPos + (double)this.windowWidth / 2.0, (double)this.topPos + (double)this.windowHeight / 2.0, this.windowHeight - 28, this.previewYaw, this.previewPitch);
                graphics.method_51452();
                graphics.method_44380();
                graphics.method_25303(this.field_22793, data.name, this.leftPos + 8, this.topPos + 8, 0xFFFFFF);
                graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43469((String)"gui.immersive_furniture.author", (Object[])new Object[]{data.author}).method_27692(class_124.field_1056).method_27692(class_124.field_1080), this.leftPos + 8, this.topPos + 18, 0xFFFFFF);
                graphics.method_51448().method_46416((float)(this.leftPos + this.windowWidth), (float)(this.topPos + this.windowHeight - 28), 0.0f);
                graphics.method_51448().method_22905(1.5f, 1.5f, 1.5f);
                class_5250 cost = class_2561.method_43470((String)String.valueOf(data.getCost()));
                graphics.method_27535(this.field_22793, (class_2561)cost, -this.field_22793.method_27525((class_5348)cost) - 26, -17, 0xFFFFFF);
                graphics.method_51445(Items.CRAFTING_MATERIAL.method_7854(), -22, -22);
                graphics.method_51448().method_22909();
                if (this.lastMouseX >= this.leftPos + this.windowWidth - 32 - 6 && this.lastMouseX < this.leftPos + this.windowWidth - 6 && this.lastMouseY >= this.topPos + this.windowHeight - 32 - 32 && this.lastMouseY < this.topPos + this.windowHeight - 32) {
                    tooltip = Items.CRAFTING_MATERIAL.method_7854().method_7950(null, (class_1836)class_1836.class_1837.field_41070);
                }
            }
        }
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, 1024.0f);
        if (this.authenticating) {
            this.tickAuthentication();
            if (this.isBrowserOpen) {
                this.drawTextBox(graphics, (class_2561)class_2561.method_43471((String)"gui.immersive_furniture.authenticating_browser"));
            } else {
                this.drawTextBox(graphics, (class_2561)class_2561.method_43471((String)"gui.immersive_furniture.authenticating").method_10852((class_2561)class_2561.method_43470((String)(" " + ".".repeat((int)(System.currentTimeMillis() / 500L % 4L))))));
            }
        }
        if (tooltip != null) {
            graphics.method_51437(this.field_22793, tooltip, Optional.empty(), this.lastMouseX, this.lastMouseY);
        }
        graphics.method_51448().method_22909();
        this.renderError(graphics, this.selected == null ? this.field_22790 / 2 : this.topPos + 9);
        graphics.method_51448().method_46416(0.0f, 0.0f, 1024.0f);
    }

    private boolean isTileHovered(int x, int y) {
        int w = this.windowWidth / 4;
        int h = (this.windowHeight - 32 - 28) / 2;
        return this.lastMouseX >= this.leftPos + x * w && this.lastMouseX < this.leftPos + (x + 1) * w && this.lastMouseY >= this.topPos + 38 + y * h && this.lastMouseY < this.topPos + 38 + (y + 1) * h;
    }

    private boolean holdingShift() {
        long window = class_310.method_1551().method_22683().method_4490();
        return class_3675.method_15987((long)window, (int)340) || class_3675.method_15987((long)window, (int)344);
    }

    private boolean holdingCtrl() {
        long window = class_310.method_1551().method_22683().method_4490();
        return class_3675.method_15987((long)window, (int)341) || class_3675.method_15987((long)window, (int)345);
    }

    protected class_344 addButton(int x, int y, int size, int u, int v, String tooltip, Runnable clicked) {
        class_344 button = this.method_37063(new class_344(x, y, size, size, u, v, size, TEXTURE, 256, 256, b -> clicked.run(), (class_2561)(tooltip == null ? class_2561.method_43470((String)"") : class_2561.method_43471((String)tooltip))));
        if (tooltip != null) {
            button.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)tooltip)));
        }
        return button;
    }

    protected StateImageButton addToggleButton(int x, int y, int size, int u, int v, String tooltip, Consumer<StateImageButton> clicked) {
        StateImageButton button = this.method_37063(new StateImageButton(x, y, size, size, u, v, TEXTURE, 256, 256, b -> clicked.accept((StateImageButton)b), (class_2561)(tooltip == null ? class_2561.method_43470((String)"") : class_2561.method_43471((String)tooltip))));
        if (tooltip != null) {
            button.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)tooltip)));
        }
        return button;
    }

    private void tickAuthentication() {
        if (this.awaitingAuthentication) {
            return;
        }
        this.awaitingAuthentication = true;
        CompletableFuture.runAsync(() -> {
            try {
                Response response;
                Response response2 = response = Auth.hasToken() ? API.request(API.HttpMethod.GET, IsAuthResponse::new, "auth") : null;
                if (response instanceof IsAuthResponse) {
                    IsAuthResponse authResponse = (IsAuthResponse)response;
                    if (authResponse.authenticated()) {
                        this.authenticated = true;
                        this.authenticating = false;
                        this.clearError();
                        class_310.method_1551().execute(this::method_25426);
                        Auth.saveToken();
                    } else {
                        Auth.clearToken();
                        if (!this.isBrowserOpen) {
                            this.setError("gui.immersive_furniture.is_auth_failed");
                            this.authenticating = false;
                        }
                    }
                } else {
                    this.setError("gui.immersive_furniture.is_auth_failed");
                    this.authenticating = false;
                }
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                Common.logger.error("Failed to authenticate!", (Throwable)e);
            }
            this.awaitingAuthentication = false;
        });
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.selected == null) {
            for (int x = 0; x < 4; ++x) {
                for (int y = 0; y < 2; ++y) {
                    int index = x + y * 4;
                    if (index >= this.furniture.size() || !this.isTileHovered(x, y)) continue;
                    this.setSelected(this.furniture.get(index));
                    this.method_25426();
                    return true;
                }
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.selected != null) {
            if (button == 0) {
                this.previewYaw += (float)(dragX * (double)0.015f);
                this.previewPitch -= (float)(dragY * (double)0.015f);
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public void setSelected(class_2960 location) {
        this.selected = location;
        this.previewYaw = -2.3561945f;
        this.previewPitch = -0.7853982f;
    }

    public void setTab(Tab tab) {
        this.tab = tab;
        this.page = 0;
        this.shouldSearch = true;
        this.method_25426();
    }

    private void drawTextBox(class_332 graphics, class_2561 text) {
        int y = this.field_22790 / 2 - 32;
        graphics.method_25294(this.field_22789 / 2 - 115, y - 5, this.field_22789 / 2 + 115, y + 12, 0x50000000);
        graphics.method_27534(this.field_22793, text, this.field_22789 / 2, y, -1);
    }

    private String getPlayerName() {
        return class_310.method_1551().field_1724 == null ? "Unknown" : class_310.method_1551().field_1724.method_7334().getName();
    }

    private void search() {
        if (this.awaitingSearch) {
            return;
        }
        if (!this.shouldSearch) {
            return;
        }
        this.shouldSearch = false;
        if (this.tab == Tab.LOCAL) {
            this.furniture = this.localFiles.stream().filter(l -> Utils.search(this.lastSearch, l.toString())).filter(l -> {
                FurnitureData data = FurnitureDataManager.getData(l);
                return this.tagFilter.equals("miscellaneous") || data == null || data.tag.equals(this.tagFilter);
            }).skip((long)this.page * 8L).limit(8L).toList();
        } else {
            this.awaitingSearch = true;
            CompletableFuture.runAsync(() -> {
                Response response = API.request(API.HttpMethod.GET, ContentListResponse::new, "v2/content/furniture", Map.of("whitelist", this.lastSearch + (String)(this.tagFilter.equals("miscellaneous") ? "" : "," + this.tagFilter), "blacklist", "", "order", this.order.key(), "track", this.tab == Tab.FAVORITES ? "likes" : (this.tab == Tab.SUBMISSIONS ? "submissions" : "all"), "descending", "true", "offset", String.valueOf(this.page * 8), "limit", String.valueOf(8)));
                if (response instanceof ContentListResponse) {
                    ContentListResponse contentListResponse = (ContentListResponse)response;
                    this.furniture = Arrays.stream(contentListResponse.contents()).map(c -> new class_2960("library", c.contentid() + "." + c.version())).collect(Collectors.toList());
                    class_310.method_1551().execute(this::method_25426);
                } else {
                    this.setError("gui.immersive_furniture.list_fetch_failed");
                }
                this.awaitingSearch = false;
            });
        }
    }

    private void publish(FurnitureData data) {
        if (this.uploading) {
            return;
        }
        this.uploading = true;
        CompletableFuture.runAsync(() -> {
            if (!Auth.hasToken()) {
                return;
            }
            LinkedList<String> tags = new LinkedList<String>();
            tags.add(data.tag);
            if (data.hasParticles()) {
                tags.add("has_particles");
            }
            if (data.hasSounds()) {
                tags.add("has_sounds");
            }
            if (data.canSit()) {
                tags.add("can_sit");
            }
            if (data.canSleep()) {
                tags.add("can_sleep");
            }
            if (data.hasDisplayItems()) {
                tags.add("has_display_items");
            }
            if (data.getUniqueSolidStates().size() > 1) {
                tags.add("has_states");
            }
            if (!data.dependencies.isEmpty()) {
                tags.add("has_dependencies");
            }
            if (!data.sources.isEmpty()) {
                tags.add("has_modded_textures");
            }
            if (data.inventorySize > 0) {
                tags.add("has_inventory");
            }
            if (data.lightLevel > 0) {
                tags.add("is_light_source");
            }
            tags.addAll(data.elements.stream().filter(e -> e.type == FurnitureData.ElementType.ELEMENT).map(e -> e.material.source.method_12832()).distinct().toList());
            Response request = API.request(data.contentid == -1 ? API.HttpMethod.POST : API.HttpMethod.PUT, data.contentid == -1 ? ContentIdResponse::new : SuccessResponse::new, (String)(data.contentid == -1 ? "content/furniture" : "content/furniture/" + data.contentid), Map.of(), Map.of("title", data.name, "meta", "{}", "data", new String(Base64.getEncoder().encode(Utils.toBytes(data.toTag()))), "tags", tags));
            if (request instanceof ContentIdResponse) {
                ContentIdResponse response = (ContentIdResponse)request;
                data.contentid = response.contentid();
                FurnitureDataManager.saveLocalFile(data);
                this.selected = null;
                class_310.method_1551().execute(() -> this.setTab(Tab.SUBMISSIONS));
            } else if (request instanceof SuccessResponse) {
                this.selected = null;
                this.method_25426();
            } else if (request instanceof ErrorResponse) {
                ErrorResponse response = (ErrorResponse)request;
                if (response.code() == 428) {
                    this.setError("gui.immersive_furniture.upload_duplicate");
                } else {
                    this.setError("gui.immersive_furniture.upload_failed");
                }
            }
            this.uploading = false;
        });
    }

    private /* synthetic */ void lambda$init$0(Tab tab, class_4185 b) {
        this.setTab(tab);
    }

    public static enum SortingMode {
        DATE(88),
        LIKES(66),
        RECOMMENDATIONS(154);

        private final int u;

        private SortingMode(int u) {
            this.u = u;
        }

        public SortingMode cycle() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case DATE -> LIKES;
                case LIKES -> RECOMMENDATIONS;
                case RECOMMENDATIONS -> DATE;
            };
        }

        public int getU() {
            return this.u;
        }

        public String key() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum Tab {
        LOCAL,
        GLOBAL,
        FAVORITES,
        SUBMISSIONS;

    }
}

