/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.gui.components;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationEditorScreen;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationScreen;
import net.conczin.immersive_furniture.client.gui.components.ScreenComponent;
import net.conczin.immersive_furniture.client.gui.widgets.BoundedDoubleSlider;
import net.conczin.immersive_furniture.client.gui.widgets.StateImageButton;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.ModelUtils;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4050;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;

public class ModelComponent
extends ScreenComponent {
    static final class_2561 SELECT_TITLE = class_2561.method_43471((String)"gui.immersive_furniture.select");
    static final class_2561 POSITION_TITLE = class_2561.method_43471((String)"gui.immersive_furniture.position");
    static final class_2561 SIZE_TITLE = class_2561.method_43471((String)"gui.immersive_furniture.size");
    static final class_2561 ROTATION_TITLE = class_2561.method_43471((String)"gui.immersive_furniture.rotation");
    static final class_2561 MOVE_FURNITURE_TITLE = class_2561.method_43471((String)"gui.immersive_furniture.move_furniture");
    static final class_2561 FURNITURE_DIMENSION_TITLE = class_2561.method_43471((String)"gui.immersive_furniture.furniture_dimension");
    static final class_2561 FIELD_TITLE = class_2561.method_43470((String)"");
    private class_342 px;
    private class_342 py;
    private class_342 pz;
    private class_342 sx;
    private class_342 sy;
    private class_342 sz;
    private StateImageButton rx;
    private StateImageButton ry;
    private StateImageButton rz;

    public ModelComponent(ArtisansWorkstationEditorScreen screen) {
        super(screen);
    }

    @Override
    public void init(int leftPos, int topPos, int width, int height) {
        FurnitureData.Element firstElement;
        super.init(leftPos, topPos, width, height);
        this.addButton(leftPos + 6, topPos + height - 22, 16, 64, 192, "gui.immersive_furniture.new_element", () -> {
            FurnitureData.Element element = new FurnitureData.Element();
            this.screen.data.elements.add(element);
            this.screen.selectElement(element, false);
            this.screen.method_25426();
        });
        if (this.screen.selectedElements.isEmpty()) {
            int x = leftPos + 6 + 12;
            int y = topPos + 108;
            int spacing = 24;
            this.addButton(x, y, 16, 96, 160, "gui.immersive_furniture.move_furniture_east", () -> this.moveFurniture(1.0f, 0.0f, 0.0f));
            this.addButton(x, y + 29, 16, 128, 160, "gui.immersive_furniture.move_furniture_west", () -> this.moveFurniture(-1.0f, 0.0f, 0.0f));
            this.addButton(x + spacing, y, 16, 96, 160, "gui.immersive_furniture.move_furniture_up", () -> this.moveFurniture(0.0f, 1.0f, 0.0f));
            this.addButton(x + spacing, y + 29, 16, 128, 160, "gui.immersive_furniture.move_furniture_down", () -> this.moveFurniture(0.0f, -1.0f, 0.0f));
            this.addButton(x + spacing * 2, y, 16, 96, 160, "gui.immersive_furniture.move_furniture_south", () -> this.moveFurniture(0.0f, 0.0f, 1.0f));
            this.addButton(x + spacing * 2, y + 29, 16, 128, 160, "gui.immersive_furniture.move_furniture_north", () -> this.moveFurniture(0.0f, 0.0f, -1.0f));
            int dimY = topPos + 45;
            int maxDimension = 4;
            this.addButton(x, dimY, 16, 96, 160, "", () -> {
                this.screen.data.size.x = Math.min(maxDimension, this.screen.data.size.x + 1);
            });
            this.addButton(x, dimY + 29, 16, 128, 160, "", () -> {
                this.screen.data.size.x = Math.max(1, this.screen.data.size.x - 1);
            });
            this.addButton(x + spacing, dimY, 16, 96, 160, "", () -> {
                this.screen.data.size.y = Math.min(maxDimension, this.screen.data.size.y + 1);
            });
            this.addButton(x + spacing, dimY + 29, 16, 128, 160, "", () -> {
                this.screen.data.size.y = Math.max(1, this.screen.data.size.y - 1);
            });
            this.addButton(x + spacing * 2, dimY, 16, 96, 160, "", () -> {
                this.screen.data.size.z = Math.min(maxDimension, this.screen.data.size.z + 1);
            });
            this.addButton(x + spacing * 2, dimY + 29, 16, 128, 160, "", () -> {
                this.screen.data.size.z = Math.max(1, this.screen.data.size.z - 1);
            });
        }
        if ((firstElement = (FurnitureData.Element)this.screen.getFirstElement().orElse(null)) == null) {
            return;
        }
        this.addButton(leftPos + 24, topPos + height - 22, 16, 80, 192, "gui.immersive_furniture.delete_element", () -> {
            this.screen.data.elements.removeAll(this.screen.selectedElements);
            this.screen.selectedElements.clear();
            this.screen.method_25426();
        });
        this.addButton(leftPos + 42, topPos + height - 22, 16, 160, 192, "gui.immersive_furniture.duplicate_element", this::duplicateElements);
        int u = 208 + (firstElement.mask - 1) * 16;
        this.addToggleButton(leftPos + 78, topPos + height - 22, 16, u, 224, "gui.immersive_furniture.mask." + firstElement.mask, () -> {
            this.screen.selectedElements.forEach(e -> {
                e.mask = e.mask % 3 + 1;
            });
            this.screen.method_25426();
        }).setEnabled(false);
        int y = topPos + 17;
        this.px = this.addNewFloatBox(leftPos + 6, y, 28);
        this.px.method_1852(Float.toString(firstElement.from.x));
        this.px.method_1863(b -> this.screen.getFirstElement().ifPresent(currentFirstElement -> {
            float offset = this.parse(this.px.method_1882(), currentFirstElement.from.x) - currentFirstElement.from.x;
            if ((double)Math.abs(offset) < 0.001) {
                return;
            }
            currentFirstElement.from.x += offset;
            currentFirstElement.to.x += offset;
            for (FurnitureData.Element element : this.screen.selectedElements) {
                element.from.x = currentFirstElement.from.x;
                element.to.x = currentFirstElement.to.x;
                element.sanityCheck();
            }
        }));
        this.py = this.addNewFloatBox(leftPos + 6 + 30, y, 28);
        this.py.method_1852(Float.toString(firstElement.from.y));
        this.py.method_1863(b -> this.screen.getFirstElement().ifPresent(currentFirstElement -> {
            float offset = this.parse(this.py.method_1882(), currentFirstElement.from.y) - currentFirstElement.from.y;
            if ((double)Math.abs(offset) < 0.001) {
                return;
            }
            currentFirstElement.from.y += offset;
            currentFirstElement.to.y += offset;
            for (FurnitureData.Element element : this.screen.selectedElements) {
                element.from.y = currentFirstElement.from.y;
                element.to.y = currentFirstElement.to.y;
                element.sanityCheck();
            }
        }));
        this.pz = this.addNewFloatBox(leftPos + 6 + 60, y, 28);
        this.pz.method_1852(Float.toString(firstElement.from.z));
        this.pz.method_1863(b -> this.screen.getFirstElement().ifPresent(currentFirstElement -> {
            float offset = this.parse(this.pz.method_1882(), currentFirstElement.from.z) - currentFirstElement.from.z;
            if ((double)Math.abs(offset) < 0.001) {
                return;
            }
            currentFirstElement.from.z += offset;
            currentFirstElement.to.z += offset;
            for (FurnitureData.Element element : this.screen.selectedElements) {
                element.from.z = currentFirstElement.from.z;
                element.to.z = currentFirstElement.to.z;
                element.sanityCheck();
            }
        }));
        if (this.isResizable(firstElement)) {
            y = topPos + 45;
            Vector3i size = firstElement.getSize();
            this.sx = this.addNewFloatBox(leftPos + 6, y, 28);
            this.sx.method_1852(String.valueOf(size.x));
            this.sx.method_1863(b -> this.screen.getFirstElement().ifPresent(currentFirstElement -> {
                int oldSize = currentFirstElement.getSize().x;
                int newSize = Math.max(0, this.parse(this.sx.method_1882(), oldSize));
                if ((double)Math.abs(newSize - oldSize) < 0.001) {
                    return;
                }
                currentFirstElement.from.x -= (float)(newSize - oldSize) / 2.0f;
                currentFirstElement.to.x += (float)(newSize - oldSize) / 2.0f;
                for (FurnitureData.Element element : this.screen.selectedElements) {
                    element.from.x = currentFirstElement.from.x;
                    element.to.x = currentFirstElement.to.x;
                    element.sanityCheck();
                }
            }));
            this.sy = this.addNewFloatBox(leftPos + 6 + 30, y, 28);
            this.sy.method_1852(String.valueOf(size.y));
            this.sy.method_1863(b -> this.screen.getFirstElement().ifPresent(currentFirstElement -> {
                int oldSize = currentFirstElement.getSize().y;
                int newSize = Math.max(0, this.parse(this.sy.method_1882(), oldSize));
                if ((double)Math.abs(newSize - oldSize) < 0.001) {
                    return;
                }
                currentFirstElement.from.y -= (float)(newSize - oldSize) / 2.0f;
                currentFirstElement.to.y += (float)(newSize - oldSize) / 2.0f;
                for (FurnitureData.Element element : this.screen.selectedElements) {
                    element.from.y = currentFirstElement.from.y;
                    element.to.y = currentFirstElement.to.y;
                    element.sanityCheck();
                }
            }));
            this.sz = this.addNewFloatBox(leftPos + 6 + 60, y, 28);
            this.sz.method_1852(String.valueOf(size.z));
            this.sz.method_1863(b -> this.screen.getFirstElement().ifPresent(currentFirstElement -> {
                int oldSize = currentFirstElement.getSize().z;
                int newSize = Math.max(0, this.parse(this.sz.method_1882(), oldSize));
                if ((double)Math.abs(newSize - oldSize) < 0.001) {
                    return;
                }
                currentFirstElement.from.z -= (float)(newSize - oldSize) / 2.0f;
                currentFirstElement.to.z += (float)(newSize - oldSize) / 2.0f;
                for (FurnitureData.Element element : this.screen.selectedElements) {
                    element.from.z = currentFirstElement.from.z;
                    element.to.z = currentFirstElement.to.z;
                    element.sanityCheck();
                }
            }));
        }
        y = topPos + 73;
        this.rx = this.addToggleButton(leftPos + 6, y, 16, 16, 192, null, () -> {
            this.screen.selectedElements.forEach(e -> {
                e.axis = class_2350.class_2351.field_11048;
            });
            this.rx.setEnabled(false);
            this.ry.setEnabled(true);
            this.rz.setEnabled(true);
        });
        this.rx.setEnabled(firstElement.axis != class_2350.class_2351.field_11048);
        this.ry = this.addToggleButton(leftPos + 24, y, 16, 32, 192, null, () -> {
            this.screen.selectedElements.forEach(e -> {
                e.axis = class_2350.class_2351.field_11052;
            });
            this.rx.setEnabled(true);
            this.ry.setEnabled(false);
            this.rz.setEnabled(true);
        });
        this.ry.setEnabled(firstElement.axis != class_2350.class_2351.field_11052);
        this.rz = this.addToggleButton(leftPos + 42, y, 16, 48, 192, null, () -> {
            this.screen.selectedElements.forEach(e -> {
                e.axis = class_2350.class_2351.field_11051;
            });
            this.rx.setEnabled(true);
            this.ry.setEnabled(true);
            this.rz.setEnabled(false);
        });
        this.rz.setEnabled(firstElement.axis != class_2350.class_2351.field_11051);
        this.addButton(leftPos + 62, y + 1, 14, 222, 2, null, () -> this.rotate(22.5f));
        this.addButton(leftPos + 78, y + 1, 14, 206, 2, null, () -> this.rotate(-22.5f));
        for (FurnitureData.ElementType type : FurnitureData.ElementType.values()) {
            this.addToggleButton(leftPos + 6 + type.ordinal() * 18, topPos + 94, 16, 176 + type.ordinal() * 16, 192, "gui.immersive_furniture.element_type." + type.name().toLowerCase(), () -> {
                this.screen.selectedElements.forEach(e -> {
                    e.type = type;
                    e.sanityCheck();
                });
                this.screen.method_25426();
            }).setEnabled(firstElement.type != type);
        }
        if (firstElement.type == FurnitureData.ElementType.PARTICLE_EMITTER) {
            BoundedDoubleSlider directionalVelocitySlider = new BoundedDoubleSlider(leftPos + 6, topPos + 112, (width - 14) / 2, 20, "gui.immersive_furniture.directional_velocity", firstElement.particleEmitter.velocityDirectional, 0.0, 5.0);
            directionalVelocitySlider.setCallback(v -> this.screen.selectedElements.forEach(e -> {
                e.particleEmitter.velocityDirectional = v.floatValue();
            }));
            this.screen.method_37063(directionalVelocitySlider);
            BoundedDoubleSlider velocityRandomSlider = new BoundedDoubleSlider(leftPos + 8 + (width - 14) / 2, topPos + 112, (width - 14) / 2, 20, "gui.immersive_furniture.random_velocity", firstElement.particleEmitter.velocityRandom, 0.0, 5.0);
            velocityRandomSlider.setCallback(v -> this.screen.selectedElements.forEach(e -> {
                e.particleEmitter.velocityRandom = v.floatValue();
            }));
            this.screen.method_37063(velocityRandomSlider);
            BoundedDoubleSlider amountSlider = new BoundedDoubleSlider(leftPos + 6, topPos + 134, width - 32, 20, "gui.immersive_furniture.particle_amount", firstElement.particleEmitter.amount, 0.0, 4.0);
            amountSlider.setCallback(v -> this.screen.selectedElements.forEach(e -> {
                e.particleEmitter.amount = v.floatValue();
            }));
            this.screen.method_37063(amountSlider);
            this.addToggleButton(leftPos + width - 23, topPos + 136, 16, 192, 160, "gui.immersive_furniture.on_interact", () -> {
                this.screen.selectedElements.forEach(e -> {
                    e.particleEmitter.onInteract = !e.particleEmitter.onInteract;
                });
                this.screen.method_25426();
                class_638 level = class_310.method_1551().field_1687;
                class_746 player = class_310.method_1551().field_1724;
                if (level != null && player != null && firstElement.particleEmitter.onInteract) {
                    this.screen.data.emitInteractParticles(player.method_23312(), null, this.screen.currentState, (class_1657)player, ArtisansWorkstationScreen.getParticleEngine(this.screen.data)::addParticle, true);
                }
            }).setEnabled(!firstElement.particleEmitter.onInteract);
        } else if (firstElement.type == FurnitureData.ElementType.SOUND_EMITTER) {
            BoundedDoubleSlider volumeSlider = new BoundedDoubleSlider(leftPos + 6, topPos + 112, (width - 14) / 2, 20, "gui.immersive_furniture.volume", firstElement.soundEmitter.volume, 0.0, 2.0);
            volumeSlider.setCallback(v -> this.screen.selectedElements.forEach(e -> {
                e.soundEmitter.volume = v.floatValue();
            }));
            this.screen.method_37063(volumeSlider);
            BoundedDoubleSlider velocityRandomSlider = new BoundedDoubleSlider(leftPos + 8 + (width - 14) / 2, topPos + 112, (width - 14) / 2, 20, "gui.immersive_furniture.pitch", firstElement.soundEmitter.pitch, 0.5, 2.0);
            velocityRandomSlider.setCallback(v -> this.screen.selectedElements.forEach(e -> {
                e.soundEmitter.pitch = v.floatValue();
            }));
            this.screen.method_37063(velocityRandomSlider);
            if (!firstElement.soundEmitter.onInteract) {
                BoundedDoubleSlider frequencySlider = new BoundedDoubleSlider(leftPos + 6, topPos + 134, width - 32, 20, "gui.immersive_furniture.frequency", firstElement.soundEmitter.frequency, 0.0, 1.0);
                frequencySlider.setCallback(v -> this.screen.selectedElements.forEach(e -> {
                    e.soundEmitter.frequency = v.floatValue();
                }));
                this.screen.method_37063(frequencySlider);
            }
            this.addToggleButton(leftPos + width - 23, topPos + 136, 16, 192, 160, "gui.immersive_furniture.on_interact", () -> {
                this.screen.selectedElements.forEach(e -> {
                    e.soundEmitter.onInteract = !e.soundEmitter.onInteract;
                    e.soundEmitter.frequency = e.soundEmitter.onInteract ? 0.0f : 0.1f;
                });
                this.screen.method_25426();
                class_638 level = class_310.method_1551().field_1687;
                class_746 player = class_310.method_1551().field_1724;
                if (level != null && player != null && firstElement.soundEmitter.onInteract) {
                    this.screen.data.playInteractSound((class_1937)level, player.method_23312(), this.screen.currentState, (class_1657)player);
                }
            }).setEnabled(!firstElement.soundEmitter.onInteract);
        } else if (firstElement.type == FurnitureData.ElementType.PLAYER_POSE) {
            List<class_4050> poses = List.of(class_4050.field_40118, class_4050.field_18078);
            for (int i = 0; i < poses.size(); ++i) {
                class_4050 pose = poses.get(i);
                this.addToggleButton(leftPos + 6 + i * 18, topPos + 114, 16, 160 + i * 16, 160, "gui.immersive_furniture.player_pose." + pose.name().toLowerCase(), () -> {
                    this.screen.selectedElements.forEach(e -> {
                        e.playerPose.pose = pose;
                        e.sanityCheck();
                    });
                    this.screen.method_25426();
                }).setEnabled(firstElement.playerPose.pose != pose);
            }
        } else if (firstElement.type == FurnitureData.ElementType.SPRITE) {
            for (int i = 0; i < 360; i += 90) {
                int rotation = i;
                this.addToggleButton(leftPos + 6 + i / 90 * 18, topPos + 114, 16, 96 + i / 90 * 16, 160, "gui.immersive_furniture.rotation." + i, () -> {
                    this.screen.selectedElements.forEach(e -> {
                        e.sprite.rotation = rotation;
                    });
                    this.screen.method_25426();
                }).setEnabled(firstElement.sprite.rotation != rotation);
            }
            this.addButton(leftPos + 6, topPos + 132, 16, 112, 192, "gui.immersive_furniture.decrease_size", () -> {
                this.screen.selectedElements.forEach(e -> {
                    e.sprite.size = Math.max(0.25f, e.sprite.size / 2.0f);
                    e.sanityCheck();
                });
                this.screen.method_25426();
            });
            this.addButton(leftPos + 24, topPos + 132, 16, 96, 192, "gui.immersive_furniture.increase_size", () -> {
                this.screen.selectedElements.forEach(e -> {
                    e.sprite.size = Math.min(2.0f, e.sprite.size * 2.0f);
                    e.sanityCheck();
                });
                this.screen.method_25426();
            });
            if (firstElement.sprite.item) {
                this.addToggleButton(leftPos + 78, topPos + 114, 16, 240, 160, "gui.immersive_furniture.align", () -> {
                    this.screen.selectedElements.forEach(e -> {
                        e.sprite.align = !e.sprite.align;
                        e.sanityCheck();
                    });
                    this.screen.method_25426();
                }).setEnabled(!firstElement.sprite.align);
            }
            this.addToggleButton(leftPos + 60, topPos + 132, 16, 0, 160, "gui.immersive_furniture.item", () -> {
                this.screen.selectedElements.forEach(e -> {
                    e.sprite.item = !e.sprite.item;
                    e.sanityCheck();
                });
                this.screen.method_25426();
            }).setEnabled(!firstElement.sprite.item);
            this.addToggleButton(leftPos + 78, topPos + 132, 16, 144, 192, "gui.immersive_furniture.tiled", () -> {
                this.screen.selectedElements.forEach(e -> {
                    e.sprite.tiled = !e.sprite.tiled;
                    e.sanityCheck();
                });
                this.screen.method_25426();
            }).setEnabled(!firstElement.sprite.tiled);
        }
    }

    private void rotate(float rotation) {
        if (this.screen.selectedElements.size() > 1) {
            Vector3f center = new Vector3f();
            this.screen.selectedElements.stream().map(FurnitureData.Element::getCenter).forEach(arg_0 -> ((Vector3f)center).add(arg_0));
            center.div((float)this.screen.selectedElements.size());
            for (FurnitureData.Element element : this.screen.selectedElements) {
                Vector3f offset = element.getCenter().sub((Vector3fc)center);
                Vector3f newOffset = ModelUtils.rotate(new Vector3f((Vector3fc)offset), element.axis, rotation);
                newOffset.sub((Vector3fc)offset);
                element.move((float)Math.round(newOffset.x * 4.0f) / 4.0f, (float)Math.round(newOffset.y * 4.0f) / 4.0f, (float)Math.round(newOffset.z * 4.0f) / 4.0f);
            }
        }
        for (FurnitureData.Element element : this.screen.selectedElements) {
            element.rotation = (element.rotation + rotation) % 360.0f;
        }
    }

    public void duplicateElements() {
        ArrayList<FurnitureData.Element> duplicatedElements = new ArrayList<FurnitureData.Element>(this.screen.selectedElements);
        if (duplicatedElements.isEmpty()) {
            return;
        }
        this.screen.selectedElements.clear();
        for (FurnitureData.Element element : duplicatedElements) {
            FurnitureData.Element newElement = new FurnitureData.Element(element);
            this.screen.data.elements.add(newElement);
            this.screen.selectedElements.add(newElement);
        }
        this.screen.method_25426();
    }

    private boolean isResizable(FurnitureData.Element element) {
        return (element.type != FurnitureData.ElementType.SPRITE || element.sprite.tiled) && element.type != FurnitureData.ElementType.PLAYER_POSE;
    }

    private void moveFurniture(float xOffset, float yOffset, float zOffset) {
        for (FurnitureData.Element element : this.screen.data.elements) {
            element.from.x += xOffset;
            element.to.x += xOffset;
            element.from.y += yOffset;
            element.to.y += yOffset;
            element.from.z += zOffset;
            element.to.z += zOffset;
            element.sanityCheck();
        }
    }

    public void update() {
        FurnitureData.Element firstElement = this.screen.getFirstElement().orElse(null);
        if (firstElement == null) {
            return;
        }
        this.px.method_1852(Float.toString(firstElement.from.x));
        this.py.method_1852(Float.toString(firstElement.from.y));
        this.pz.method_1852(Float.toString(firstElement.from.z));
        if (this.sx != null) {
            Vector3i size = firstElement.getSize();
            this.sx.method_1852(String.valueOf(size.x));
            this.sy.method_1852(String.valueOf(size.y));
            this.sz.method_1852(String.valueOf(size.z));
        }
        if (this.rx != null) {
            this.rx.setEnabled(firstElement.axis == class_2350.class_2351.field_11048);
            this.ry.setEnabled(firstElement.axis == class_2350.class_2351.field_11052);
            this.rz.setEnabled(firstElement.axis == class_2350.class_2351.field_11051);
        }
    }

    private class_342 addNewFloatBox(int x, int y, int width) {
        class_327 class_3272 = this.minecraft.field_1772;
        Objects.requireNonNull(this.minecraft.field_1772);
        class_342 searchBox = new class_342(class_3272, x, y, width, 9 + 3, FIELD_TITLE);
        searchBox.method_1880(8);
        this.screen.method_37063(searchBox);
        return searchBox;
    }

    public float parse(String value, float defaultValue) {
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public int parse(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public void render(class_332 graphics) {
        FurnitureData.Element firstElement = this.screen.getFirstElement().orElse(null);
        if (firstElement == null) {
            graphics.method_27535(this.minecraft.field_1772, SELECT_TITLE, this.leftPos + 6, this.topPos + 6, 0xFFFFFF);
            int x = this.leftPos + 6 + 12;
            int y = this.topPos + 108;
            int spacing = 24;
            int dimY = this.topPos + 45;
            graphics.method_27534(this.minecraft.field_1772, FURNITURE_DIMENSION_TITLE, this.leftPos + 50, dimY - 12, 0xFFFFFF);
            graphics.method_25300(this.minecraft.field_1772, "X: " + this.screen.data.size.x, x + 8, dimY + 19, 0xFFFFFF);
            graphics.method_25300(this.minecraft.field_1772, "Y: " + this.screen.data.size.y, x + 8 + spacing, dimY + 19, 0xFFFFFF);
            graphics.method_25300(this.minecraft.field_1772, "Z: " + this.screen.data.size.z, x + 8 + spacing * 2, dimY + 19, 0xFFFFFF);
            graphics.method_27534(this.minecraft.field_1772, MOVE_FURNITURE_TITLE, this.leftPos + 50, y - 12, 0xFFFFFF);
            graphics.method_25303(this.minecraft.field_1772, "X", x + 5, y + 19, 0xFFFFFF);
            graphics.method_25303(this.minecraft.field_1772, "Y", x + 5 + spacing, y + 19, 0xFFFFFF);
            graphics.method_25303(this.minecraft.field_1772, "Z", x + 5 + spacing * 2, y + 19, 0xFFFFFF);
            this.renderSmoothOutline(graphics, this.leftPos + 4, dimY - 15, this.width - 8, 62, 0x44000000);
            this.renderSmoothOutline(graphics, this.leftPos + 4, y - 15, this.width - 8, 62, 0x44000000);
        } else {
            graphics.method_27535(this.minecraft.field_1772, POSITION_TITLE, this.leftPos + 6, this.topPos + 6, 0xFFFFFF);
            if (this.isResizable(firstElement)) {
                graphics.method_27535(this.minecraft.field_1772, SIZE_TITLE, this.leftPos + 6, this.topPos + 34, 0xFFFFFF);
            }
            if (firstElement.type != FurnitureData.ElementType.PLAYER_POSE) {
                graphics.method_27535(this.minecraft.field_1772, ROTATION_TITLE, this.leftPos + 6, this.topPos + 62, 0xFFFFFF);
            }
            this.renderSmoothOutline(graphics, this.leftPos + 4, this.topPos + 4, this.width - 8, 87, 0x44000000);
            this.renderSmoothOutline(graphics, this.leftPos + 4, this.topPos + 92, this.width - 8, this.height - 117, 0x44000000);
        }
        this.renderSmoothOutline(graphics, this.leftPos + 4, this.topPos + 156, this.width - 8, 20, 0x44000000);
    }

    public void renderSmoothOutline(class_332 graphics, int x, int y, int width, int height, int color) {
        graphics.method_25294(x + 1, y, x + width - 1, y + 1, color);
        graphics.method_25294(x + 1, y + height - 1, x + width - 1, y + height, color);
        graphics.method_25294(x, y + 1, x + 1, y + height - 1, color);
        graphics.method_25294(x + width - 1, y + 1, x + width, y + height - 1, color);
    }
}

