/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.gui.components;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationEditorScreen;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationLibraryScreen;
import net.conczin.immersive_furniture.client.gui.components.ScreenComponent;
import net.conczin.immersive_furniture.client.gui.widgets.BoundedIntSliderButton;
import net.conczin.immersive_furniture.client.gui.widgets.StateImageButton;
import net.conczin.immersive_furniture.client.model.DynamicAtlas;
import net.conczin.immersive_furniture.client.model.FurnitureModelFactory;
import net.conczin.immersive_furniture.client.model.MaterialRegistry;
import net.conczin.immersive_furniture.client.model.MaterialSource;
import net.conczin.immersive_furniture.client.model.TransparencyManager;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.FurnitureDataManager;
import net.conczin.immersive_furniture.utils.Utils;
import net.minecraft.class_124;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class SettingsComponent
extends ScreenComponent {
    static final class_2561 SEARCH_TITLE = class_2561.method_43471((String)"gui.immersive_furniture.name");
    static final class_2561 SEARCH_HINT = class_2561.method_43471((String)"gui.immersive_furniture.name.hint").method_27692(class_124.field_1056).method_27692(class_124.field_1080);
    public static final List<String> TAGS = List.of("living_room", "bed_room", "kitchen", "bath_room", "office", "storage", "outdoor", "communal", "workshop", "miscellaneous");
    private boolean localFileExists;

    public SettingsComponent(ArtisansWorkstationEditorScreen screen) {
        super(screen);
    }

    @Override
    public void init(int leftPos, int topPos, int width, int height) {
        super.init(leftPos, topPos, width, height);
        this.localFileExists = FurnitureDataManager.localFileExists(this.screen.data);
        class_327 class_3272 = this.minecraft.field_1772;
        Objects.requireNonNull(this.minecraft.field_1772);
        class_342 nameBox = new class_342(class_3272, leftPos + 6, topPos + 6, width - 12, 9 + 3, SEARCH_TITLE);
        nameBox.method_1880(50);
        nameBox.method_1862(true);
        nameBox.method_1852(this.screen.data.name);
        nameBox.method_47404(SEARCH_HINT);
        nameBox.method_1863(s -> {
            this.screen.data.name = s;
            this.localFileExists = FurnitureDataManager.localFileExists(this.screen.data);
        });
        this.screen.method_37063(nameBox);
        int i = 0;
        int x = leftPos + 6;
        int y = topPos + 22;
        for (String tag : TAGS) {
            this.addToggleButton(x, y, 16, i * 16, 224, "gui.immersive_furniture.tag." + tag.toLowerCase(Locale.ROOT), () -> {
                this.screen.data.tag = tag;
                this.screen.method_25426();
            }).setEnabled(tag.equals(this.screen.data.tag));
            ++i;
            if ((x += 18) <= leftPos + width - 6) continue;
            x = leftPos + 6;
            y += 18;
        }
        BoundedIntSliderButton lightLevelSlider = new BoundedIntSliderButton(leftPos + 6, topPos + 60, width - 12, 20, "gui.immersive_furniture.light_level", this.screen.data.lightLevel, 0, 15);
        lightLevelSlider.setCallback(c -> {
            this.screen.data.lightLevel = c;
        });
        this.screen.method_37063(lightLevelSlider);
        BoundedIntSliderButton inventorySlider = new BoundedIntSliderButton(leftPos + 6, topPos + 82, width - 12, 20, "gui.immersive_furniture.inventory", this.screen.data.inventorySize, 0, 6);
        inventorySlider.setCallback(c -> {
            this.screen.data.inventorySize = c;
        });
        this.screen.method_37063(inventorySlider);
        int togglesY = topPos + 106;
        StateImageButton rightClickToggle = this.addToggleButton(leftPos + 6, togglesY, 16, 192, 160, "gui.immersive_furniture.toggle_with_right_click", () -> {
            this.screen.data.toggleWithRightClick = !this.screen.data.toggleWithRightClick;
            this.screen.method_25426();
        });
        rightClickToggle.setEnabled(!this.screen.data.toggleWithRightClick);
        StateImageButton lightToggle = this.addToggleButton(leftPos + 24, togglesY, 16, 208, 160, "gui.immersive_furniture.toggle_light", () -> {
            this.screen.data.toggleLight = !this.screen.data.toggleLight;
            this.screen.method_25426();
        });
        lightToggle.setEnabled(!this.screen.data.toggleLight);
        this.addButton("gui.immersive_furniture.save", b -> {
            this.finish(this.screen.data);
            FurnitureDataManager.saveLocalFile(this.screen.data);
            FurnitureDataManager.deleteLocalFile(new class_2960("local", "autosave"));
            ArtisansWorkstationLibraryScreen libraryScreen = new ArtisansWorkstationLibraryScreen();
            libraryScreen.setSelected(FurnitureDataManager.getSafeLocalLocation(this.screen.data));
            libraryScreen.setTab(ArtisansWorkstationLibraryScreen.Tab.LOCAL);
            class_310.method_1551().method_1507((class_437)libraryScreen);
        }, leftPos + 6, topPos + 154, width - 12);
    }

    public void render(class_332 graphics) {
        if (this.localFileExists) {
            graphics.method_27534(this.minecraft.field_1772, (class_2561)class_2561.method_43471((String)"gui.immersive_furniture.overwrite_file"), this.leftPos + this.width + (280 - this.width) / 2, this.topPos + this.height - 16, 0xFFFFFF);
        }
    }

    private void addButton(String message, class_4185.class_4241 onPress, int x, int y, int w) {
        this.screen.method_37063(class_4185.method_46430((class_2561)class_2561.method_43471((String)message), (class_4185.class_4241)onPress).method_46434(x, y, w, 20).method_46431());
    }

    public void finish(FurnitureData data) {
        TransparencyManager.prepare(data);
        DynamicAtlas.SCRATCH.clear();
        FurnitureModelFactory.getModel(data, DynamicAtlas.SCRATCH);
        data.author = class_310.method_1551().method_1548().method_1676();
        if (data.hasDisplayItems()) {
            data.inventorySize = Math.max(1, data.inventorySize);
        }
        data.sources.clear();
        for (FurnitureData.Element element : data.elements) {
            if (element.type != FurnitureData.ElementType.ELEMENT) continue;
            MaterialSource source = MaterialRegistry.INSTANCE.materials.getOrDefault(element.material.source, MaterialSource.DEFAULT);
            for (class_2350 value : class_2350.values()) {
                class_2960 location = source.getMaterial(value).sprite().method_45851().method_45816();
                data.sources.add(location.method_12836());
                class_2960 textureLocation = new class_2960(location.method_12836(), "textures/" + location.method_12832() + ".png");
                class_310.method_1551().method_1478().method_14486(textureLocation).ifPresent(resource -> data.sources.add(Utils.beatifyPackID(resource.method_14480())));
            }
        }
        data.sources.remove("vanilla");
        data.sources.remove("minecraft");
        data.sources.remove("mod_resources");
        data.sources.remove("mod resources");
        data.dependencies.clear();
        for (FurnitureData.Element element : data.elements) {
            if (element.type == FurnitureData.ElementType.PARTICLE_EMITTER) {
                data.dependencies.add(element.particleEmitter.particle.method_12836());
                continue;
            }
            if (element.type == FurnitureData.ElementType.SOUND_EMITTER) {
                data.dependencies.add(element.soundEmitter.sound.method_12836());
                continue;
            }
            if (element.type != FurnitureData.ElementType.SPRITE) continue;
            data.dependencies.add(element.sprite.sprite.method_12836());
        }
        data.dependencies.remove("minecraft");
        data.dependencies.remove("mod resources");
    }
}

