/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.gui.widgets;

import java.util.List;
import java.util.function.Consumer;
import net.conczin.immersive_furniture.Common;
import net.conczin.immersive_furniture.client.Utils;
import net.conczin.immersive_furniture.client.gui.widgets.ColorSliderWidget;
import net.conczin.immersive_furniture.client.gui.widgets.TexturedColorSliderWidget;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5253;
import net.minecraft.class_6382;

public class HSVColorPicker
extends class_339 {
    private final ColorSliderWidget hueSlider;
    private final ColorSliderWidget saturationSlider;
    private final ColorSliderWidget valueSlider;
    private int color;
    private float hue;
    private float saturation;
    private float value;
    private final Consumer<Integer> callback;

    public HSVColorPicker(int x, int y, int width, int height, int color, Consumer<Integer> callback) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)""));
        this.color = color;
        float[] hsv = Utils.rgbToHsv(color);
        this.hue = hsv[0];
        this.saturation = hsv[1];
        this.value = hsv[2];
        this.callback = callback;
        int sliderHeight = (height - 6) / 3;
        this.hueSlider = new TexturedColorSliderWidget(x, y + 1, width, sliderHeight, this.hue / 360.0f, Common.locate("textures/gui/hue.png"), v -> {
            this.hue = v.floatValue() * 360.0f;
            this.update();
        });
        this.saturationSlider = new ColorSliderWidget(x, y + 3 + sliderHeight, width, sliderHeight, this.saturation, v -> {
            this.saturation = v.floatValue();
            this.update();
        });
        this.valueSlider = new ColorSliderWidget(x, y + 5 + 2 * sliderHeight, width, sliderHeight, this.value, v -> {
            this.value = v.floatValue();
            this.update();
        });
        this.update();
    }

    private void update() {
        this.color = Utils.hsvToRgb(this.hue, this.saturation, this.value);
        this.saturationSlider.setColor(-16777216 + Utils.hsvToRgb(this.hue, 0.0f, 1.0f), -16777216 + Utils.hsvToRgb(this.hue, 1.0f, 1.0f));
        this.valueSlider.setColor(-16777216, -16777216 + Utils.hsvToRgb(this.hue, 1.0f, 1.0f));
        this.callback.accept(class_5253.class_5254.method_27764((int)255, (int)class_5253.class_8045.method_48345((int)this.color), (int)class_5253.class_8045.method_48346((int)this.color), (int)class_5253.class_8045.method_48347((int)this.color)));
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return false;
    }

    public List<class_339> getWidgets() {
        return List.of(this, this.hueSlider, this.saturationSlider, this.valueSlider);
    }
}

