/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.model;

import net.conczin.immersive_furniture.data.ElementRotation;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.ModelUtils;
import net.minecraft.class_2350;
import net.minecraft.class_753;
import net.minecraft.class_789;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;

public class ClientModelUtils {
    public static Vector2i getFaceDimensions(FurnitureData.Element element, class_2350 direction) {
        switch (direction) {
            case field_11036: 
            case field_11033: {
                return new Vector2i((int)(element.to.x - element.from.x), (int)(element.to.z - element.from.z));
            }
            case field_11043: 
            case field_11035: {
                return new Vector2i((int)(element.to.x - element.from.x), (int)(element.to.y - element.from.y));
            }
            case field_11039: 
            case field_11034: {
                return new Vector2i((int)(element.to.z - element.from.z), (int)(element.to.y - element.from.y));
            }
        }
        throw new IllegalArgumentException("Invalid direction: " + String.valueOf(direction));
    }

    public static Vector3i to3D(FurnitureData.Element element, class_2350 direction, int x, int y) {
        switch (direction) {
            case field_11036: {
                return new Vector3i((int)element.from.x + x, (int)element.to.y, (int)element.from.z + y);
            }
            case field_11033: {
                return new Vector3i((int)element.from.x + x, (int)element.from.y, (int)element.to.z - y);
            }
            case field_11043: {
                return new Vector3i((int)element.to.x - x, (int)element.to.y - y, (int)element.from.z);
            }
            case field_11035: {
                return new Vector3i((int)element.from.x + x, (int)element.to.y - y, (int)element.to.z);
            }
            case field_11039: {
                return new Vector3i((int)element.from.x, (int)element.to.y - y, (int)element.from.z + x);
            }
            case field_11034: {
                return new Vector3i((int)element.to.x, (int)element.to.y - y, (int)element.to.z - x);
            }
        }
        throw new IllegalArgumentException("Invalid direction: " + String.valueOf(direction));
    }

    public static float[] getShapeData(FurnitureData.Element element) {
        float[] fs = new float[class_2350.values().length];
        fs[class_753.class_754.field_3967] = element.from.x() / 16.0f;
        fs[class_753.class_754.field_3968] = element.from.y() / 16.0f;
        fs[class_753.class_754.field_3969] = element.from.z() / 16.0f;
        fs[class_753.class_754.field_3970] = element.to.x() / 16.0f;
        fs[class_753.class_754.field_3971] = element.to.y() / 16.0f;
        fs[class_753.class_754.field_3972] = element.to.z() / 16.0f;
        return fs;
    }

    public static Vector3f getVertex(class_2350 facing, int vertex, float[] fs, ElementRotation rotation, Matrix4f transform) {
        class_753.class_755 vertexInfo = class_753.method_3163((class_2350)facing).method_3162(vertex);
        Vector3f vec = new Vector3f(fs[vertexInfo.field_3975], fs[vertexInfo.field_3974], fs[vertexInfo.field_3973]);
        if (rotation != null) {
            Quaternionf quaternionf = ModelUtils.getElementRotation(rotation);
            vec.sub((Vector3fc)rotation.origin());
            quaternionf.transform(vec);
            vec.add((Vector3fc)rotation.origin());
        }
        if (transform != null) {
            transform.transformPosition(vec);
        }
        return vec;
    }

    public static Vector3f[] getVertices(FurnitureData.Element element, class_2350 facing, float[] fs, Matrix4f transform) {
        return new Vector3f[]{ClientModelUtils.getVertex(facing, 0, fs, element.getRotation(), transform), ClientModelUtils.getVertex(facing, 1, fs, element.getRotation(), transform), ClientModelUtils.getVertex(facing, 2, fs, element.getRotation(), transform), ClientModelUtils.getVertex(facing, 3, fs, element.getRotation(), transform)};
    }

    public static class_789 toBlockElementRotation(ElementRotation rotation) {
        return new class_789(rotation.origin(), rotation.axis(), rotation.angle(), rotation.rescale());
    }
}

