/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.model;

import java.util.HashMap;
import java.util.List;
import net.conczin.immersive_furniture.client.model.MaterialRegistry;
import net.conczin.immersive_furniture.client.model.RotatedMaterial;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.mixin.client.SpriteContentsAccessor;
import net.conczin.immersive_furniture.utils.Utils;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7923;
import org.joml.Vector3f;

public record MaterialSource(class_2960 location, RotatedMaterial down, RotatedMaterial up, RotatedMaterial north, RotatedMaterial south, RotatedMaterial west, RotatedMaterial east) {
    public static final MaterialSource DEFAULT = new MaterialSource(new class_2960("minecraft:oak_log"), new RotatedMaterial("minecraft:block/oak_log_top"), new RotatedMaterial("minecraft:block/oak_log_top"), new RotatedMaterial("minecraft:block/oak_log"), new RotatedMaterial("minecraft:block/oak_log"), new RotatedMaterial("minecraft:block/oak_log"), new RotatedMaterial("minecraft:block/oak_log"));
    private static final class_5819 random = class_5819.method_43047();

    public class_1011 get(class_2350 direction) {
        return MaterialSource.getImage(this.getMaterial(direction).sprite());
    }

    public RotatedMaterial getMaterial(class_2350 direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033 -> this.down;
            case class_2350.field_11036 -> this.up;
            case class_2350.field_11043 -> this.north;
            case class_2350.field_11035 -> this.south;
            case class_2350.field_11039 -> this.west;
            case class_2350.field_11034 -> this.east;
        };
    }

    public static class_1011 getImage(class_1058 sprite) {
        return ((SpriteContentsAccessor)sprite.method_45851()).getMipLevelData()[0];
    }

    public class_2561 name() {
        String key = "block." + this.location.method_12836() + "." + this.location.method_12832();
        return class_2561.method_48321((String)key, (String)Utils.capitalize(this.location));
    }

    public static MaterialSource create(class_2680 state) {
        class_1087 model = class_310.method_1551().method_1554().method_4743().method_3335(state);
        HashMap<class_2350, RotatedMaterial> materials = new HashMap<class_2350, RotatedMaterial>();
        for (class_2350 direction : class_2350.values()) {
            int height;
            List quads = model.method_4707(state, direction, random);
            if (quads.size() != 1) {
                return null;
            }
            class_1058 sprite = ((class_777)quads.get(0)).method_35788();
            int width = sprite.method_45851().method_45807();
            if (width != (height = sprite.method_45851().method_45815()) || Math.pow((int)Math.sqrt(width), 2.0) != (double)width) {
                return null;
            }
            int rotation = MaterialSource.getRotation(quads);
            class_2960 name = sprite.method_45851().method_45816();
            materials.put(direction, new RotatedMaterial(sprite.method_45852(), name, rotation));
        }
        class_2960 name = class_7923.field_41175.method_10221((Object)state.method_26204());
        return new MaterialSource(name, (RotatedMaterial)materials.get(class_2350.field_11033), (RotatedMaterial)materials.get(class_2350.field_11036), (RotatedMaterial)materials.get(class_2350.field_11043), (RotatedMaterial)materials.get(class_2350.field_11035), (RotatedMaterial)materials.get(class_2350.field_11039), (RotatedMaterial)materials.get(class_2350.field_11034));
    }

    private static int getRotation(List<class_777> quads) {
        int[] v = quads.get(0).method_3357();
        float u0 = Float.intBitsToFloat(v[4]);
        float v0 = Float.intBitsToFloat(v[5]);
        float u1 = Float.intBitsToFloat(v[20]);
        float v1 = Float.intBitsToFloat(v[21]);
        int rotation = 0;
        if (u0 > u1) {
            rotation = v0 > v1 ? (rotation += 2) : (rotation += 3);
        } else if (v0 > v1) {
            ++rotation;
        }
        return rotation;
    }

    public static int wrap(int x, int w, int n) {
        if (w >= n) {
            return x + (w - n) / 2;
        }
        int cycleLength = 2 * w;
        int fullCycles = n / cycleLength;
        int remainder = n % cycleLength;
        int pos = x % (fullCycles * cycleLength + remainder);
        int block = pos / w;
        int offset = pos % w;
        return block % 2 == 0 ? offset : w - 1 - offset;
    }

    public static int smartWrap(int coord, int size, int textureSize, int margin) {
        if (coord < margin || coord >= size - margin) {
            return coord >= size / 2 ? textureSize - (size - coord) : coord;
        }
        int w = Math.max(1, textureSize - margin * 2);
        int n = Math.max(1, size - margin * 2);
        return MaterialSource.wrap(coord - margin, w, n) + margin;
    }

    public static int fromCube(FurnitureData.Material material, class_2350 direction, Vector3f center, int x, int y, int w, int h) {
        class_2350 rotatedDirection = direction;
        int axisOrdinal = material.axis.ordinal();
        if (axisOrdinal > 0) {
            int shift = 2 * axisOrdinal;
            int directionOrdinal = (direction.ordinal() + shift) % 6;
            rotatedDirection = class_2350.values()[directionOrdinal];
        }
        MaterialSource source = MaterialRegistry.INSTANCE.materials.getOrDefault(material.source, DEFAULT);
        class_1011 texture = source.get(rotatedDirection);
        if (direction == class_2350.field_11034 || direction == class_2350.field_11043) {
            x = w - x - 1;
        }
        if (direction == class_2350.field_11033) {
            y = h - y - 1;
        }
        if (material.wrap == FurnitureData.WrapMode.REPEAT) {
            x += (int)(center.x += center.y);
            y += (int)(center.z += center.y);
        }
        int tw = texture.method_4307();
        int th = texture.method_4323();
        if (material.wrap == FurnitureData.WrapMode.EXPAND) {
            x = MaterialSource.smartWrap(x, w, tw, material.margin);
            y = MaterialSource.smartWrap(y, h, th, material.margin);
        }
        x %= tw;
        y %= th;
        if (material.axis != FurnitureData.MaterialAxis.X && direction == class_2350.field_11043) {
            x = tw - x - 1;
        }
        if (material.axis != FurnitureData.MaterialAxis.Y && direction == class_2350.field_11033) {
            y = th - y - 1;
        }
        if (material.axis == FurnitureData.MaterialAxis.X && direction == class_2350.field_11034) {
            x = tw - x - 1;
        }
        int rotation = source.getMaterial(rotatedDirection).getRotation();
        if (material.axis == FurnitureData.MaterialAxis.Y) {
            switch (direction) {
                case field_11033: 
                case field_11036: 
                case field_11035: {
                    ++rotation;
                    break;
                }
                case field_11043: {
                    rotation += 3;
                    break;
                }
                case field_11034: {
                    rotation += 2;
                }
            }
        } else if (material.axis == FurnitureData.MaterialAxis.Z) {
            switch (direction) {
                case field_11036: {
                    rotation += 2;
                    break;
                }
                case field_11043: 
                case field_11035: {
                    rotation += 3;
                    break;
                }
                case field_11039: 
                case field_11034: {
                    ++rotation;
                }
            }
        }
        if ((rotation %= 4) == 1) {
            int temp = x;
            x = y;
            y = tw - temp - 1;
        } else if (rotation == 2) {
            x = tw - x - 1;
            y = th - y - 1;
        } else if (rotation == 3) {
            int temp = x;
            x = th - y - 1;
            y = temp;
        }
        return texture.method_4315(x, y);
    }
}

