/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.renderer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1087;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_804;
import net.minecraft.class_811;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class ModelBoundingBoxFetcher {
    public static final ModelBoundingBoxFetcher INSTANCE = new ModelBoundingBoxFetcher();
    private final Map<Long, class_238> CACHE = new HashMap<Long, class_238>();
    private final class_5819 random = class_5819.method_43047();

    public class_238 getModelBoundingBox(class_1087 bakedmodel) {
        long modelKey = System.identityHashCode(bakedmodel);
        return this.CACHE.computeIfAbsent(modelKey, k -> this.computeModelBoundingBox(bakedmodel));
    }

    private class_238 computeModelBoundingBox(class_1087 bakedmodel) {
        float minX = 3.0f;
        float minY = 3.0f;
        float minZ = 3.0f;
        float maxX = -3.0f;
        float maxY = -3.0f;
        float maxZ = -3.0f;
        class_804 transform = bakedmodel.method_4709().method_3503(class_811.field_4319);
        class_4587 poseStack = new class_4587();
        transform.method_23075(false, poseStack);
        poseStack.method_46416(-0.5f, -0.5f, -0.5f);
        Matrix4f pose = poseStack.method_23760().method_23761();
        for (int d = 0; d < 7; ++d) {
            class_2350 direction = d == 6 ? null : class_2350.method_10143((int)d);
            List quads = bakedmodel.method_4707(null, direction, this.random);
            for (class_777 quad : quads) {
                if (quad.method_3358() == class_2350.field_11035 || quad.method_3358() == class_2350.field_11043) continue;
                int[] vertices = quad.method_3357();
                for (int i = 0; i < 4; ++i) {
                    int offset = i * 8;
                    float x = Float.intBitsToFloat(vertices[offset]);
                    float y = Float.intBitsToFloat(vertices[offset + 1]);
                    float z = Float.intBitsToFloat(vertices[offset + 2]);
                    Vector4f pos = pose.transform(x, y, z, 1.0f, new Vector4f());
                    if (pos.x < minX) {
                        minX = pos.x;
                    }
                    if (pos.y < minY) {
                        minY = pos.y;
                    }
                    if (pos.z < minZ) {
                        minZ = pos.z;
                    }
                    if (pos.x > maxX) {
                        maxX = pos.x;
                    }
                    if (pos.y > maxY) {
                        maxY = pos.y;
                    }
                    if (!(pos.z > maxZ)) continue;
                    maxZ = pos.z;
                }
            }
        }
        return new class_238((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }
}

