/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.data;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import net.conczin.immersive_furniture.Common;
import net.conczin.immersive_furniture.client.model.DynamicAtlas;
import net.conczin.immersive_furniture.config.Config;
import net.conczin.immersive_furniture.data.ElementRotation;
import net.conczin.immersive_furniture.data.ModelUtils;
import net.conczin.immersive_furniture.data.TransparencyType;
import net.conczin.immersive_furniture.utils.NBTHelper;
import net.conczin.immersive_furniture.utils.Utils;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_4050;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;

public class FurnitureData {
    public static final FurnitureData EMPTY = new FurnitureData();
    public String name = "Empty";
    public String tag = "miscellaneous";
    public int lightLevel;
    public int inventorySize;
    public boolean toggleWithRightClick;
    public boolean toggleLight;
    public int contentid = -1;
    public String author = "Unknown";
    public String originalAuthor = "";
    public Set<String> sources = new HashSet<String>();
    public Set<String> dependencies = new HashSet<String>();
    public final List<Element> elements = new LinkedList<Element>();
    public Vector3i size = new Vector3i(1, 1, 1);
    private String hash;
    private final Map<Integer, class_265> cachedFullShapes = new ConcurrentHashMap<Integer, class_265>();
    private final Map<Integer, class_265> cachedSubShapes = new ConcurrentHashMap<Integer, class_265>();
    private final Set<Integer> requestedFullShapes = new ConcurrentSkipListSet<Integer>();
    private final Set<Integer> requestedSubShapes = new ConcurrentSkipListSet<Integer>();
    public long lastTick = 0L;

    public FurnitureData() {
        this.elements.add(new Element());
    }

    public FurnitureData(class_2487 tag) {
        this.name = NBTHelper.getString(tag, "Name", this.name);
        this.tag = NBTHelper.getString(tag, "Tag", this.tag);
        this.lightLevel = NBTHelper.getInt(tag, "LightLevel", this.lightLevel);
        this.inventorySize = NBTHelper.getInt(tag, "InventorySize", this.inventorySize);
        this.toggleWithRightClick = NBTHelper.getBoolean(tag, "ToggleWithRightClick", this.toggleWithRightClick);
        this.toggleLight = NBTHelper.getBoolean(tag, "ToggleLight", this.toggleLight);
        this.contentid = NBTHelper.getInt(tag, "ContentID", this.contentid);
        this.author = NBTHelper.getString(tag, "Author", this.author);
        this.originalAuthor = NBTHelper.getString(tag, "OriginalAuthor", this.originalAuthor);
        this.sources = NBTHelper.getStringSet(tag.method_10554("Sources", 8));
        this.dependencies = NBTHelper.getStringSet(tag.method_10554("Dependencies", 8));
        this.size = new Vector3i(NBTHelper.getInt(tag, "SizeX", 1), NBTHelper.getInt(tag, "SizeY", 1), NBTHelper.getInt(tag, "SizeZ", 1));
        class_2499 elementsTag = tag.method_10554("Elements", 10);
        for (int i = 0; i < elementsTag.size(); ++i) {
            this.elements.add(new Element(elementsTag.method_10602(i)));
        }
    }

    public FurnitureData(FurnitureData data) {
        this.name = data.name;
        this.tag = data.tag;
        this.lightLevel = data.lightLevel;
        this.inventorySize = data.inventorySize;
        this.toggleWithRightClick = data.toggleWithRightClick;
        this.toggleLight = data.toggleLight;
        this.author = data.author;
        this.originalAuthor = data.originalAuthor.isEmpty() ? data.author : data.originalAuthor;
        this.sources.addAll(data.sources);
        this.dependencies.addAll(data.dependencies);
        this.hash = null;
        this.lastTick = 0L;
        for (Element element : data.elements) {
            this.elements.add(new Element(element));
        }
        this.size = new Vector3i(data.size.x, data.size.y, data.size.z);
    }

    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10582("Name", this.name);
        tag.method_10582("Tag", this.tag);
        tag.method_10569("LightLevel", this.lightLevel);
        tag.method_10569("InventorySize", this.inventorySize);
        tag.method_10556("ToggleWithRightClick", this.toggleWithRightClick);
        tag.method_10556("ToggleLight", this.toggleLight);
        tag.method_10569("ContentID", this.contentid);
        tag.method_10582("Author", this.author);
        tag.method_10582("OriginalAuthor", this.originalAuthor);
        tag.method_10566("Sources", (class_2520)NBTHelper.getStringList(this.sources));
        tag.method_10566("Dependencies", (class_2520)NBTHelper.getStringList(this.dependencies));
        tag.method_10569("SizeX", this.size.x);
        tag.method_10569("SizeY", this.size.y);
        tag.method_10569("SizeZ", this.size.z);
        class_2499 elementsTag = new class_2499();
        for (Element element : this.elements) {
            elementsTag.add((Object)element.toTag());
        }
        tag.method_10566("Elements", (class_2520)elementsTag);
        return tag;
    }

    public int getCost() {
        double volume = Math.sqrt(this.getVolume()) / 32.0;
        double cost = volume + (double)this.inventorySize * 0.5 + (double)this.lightLevel / 15.0 + (double)this.elements.size() / 4.0;
        return (int)Math.ceil(cost * (double)Config.getInstance().costMultiplier);
    }

    public class_238 boundingBox() {
        if (this.elements.isEmpty()) {
            return new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float minZ = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float maxY = Float.MIN_VALUE;
        float maxZ = Float.MIN_VALUE;
        for (Element element : this.elements) {
            if (element.type != ElementType.ELEMENT && element.type != ElementType.SPRITE) continue;
            Vector3f from = element.from;
            Vector3f to = element.to;
            minX = Math.min(minX, from.x);
            minY = Math.min(minY, from.y);
            minZ = Math.min(minZ, from.z);
            maxX = Math.max(maxX, to.x);
            maxY = Math.max(maxY, to.y);
            maxZ = Math.max(maxZ, to.z);
        }
        return new class_238((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public int getVolume() {
        int volume = 0;
        for (Element element : this.elements) {
            if (element.type != ElementType.ELEMENT) continue;
            Vector3i size = element.getSize();
            volume += size.x * size.y * size.z;
        }
        return volume;
    }

    public double getSize() {
        class_238 boundingBox = this.boundingBox();
        return Math.max(Math.max(Math.abs(boundingBox.field_1323 - 8.0), Math.abs(boundingBox.field_1322 - 8.0)), Math.max(Math.max(Math.abs(boundingBox.field_1321 - 8.0), Math.abs(boundingBox.field_1320 - 8.0)), Math.max(Math.abs(boundingBox.field_1325 - 8.0), Math.abs(boundingBox.field_1324 - 8.0))));
    }

    public boolean requiresBlockEntity() {
        return this.inventorySize > 0;
    }

    public String getHash() {
        if (this.hash == null) {
            this.hash = this.computeHash();
        }
        return this.hash;
    }

    public String computeHash() {
        return Utils.hashNbt(new FurnitureData(this).toTag());
    }

    public void dirty() {
        this.hash = null;
        this.cachedFullShapes.clear();
        this.cachedSubShapes.clear();
        this.requestedFullShapes.clear();
        this.requestedSubShapes.clear();
        for (Element element : this.elements) {
            element.rotationAxes = null;
            element.bakedTextures.clear();
        }
    }

    public void playInteractSound(class_1937 level, class_2338 pos, int state, class_1657 player) {
        for (Element element : this.elements) {
            if (!element.isMasked(state) || element.type != ElementType.SOUND_EMITTER || !element.soundEmitter.onInteract) continue;
            FurnitureData.playSound(level, pos, player.method_6051(), element);
        }
    }

    public void emitInteractParticles(class_2338 pos, class_2350 direction, int state, class_1657 player, ParticleConsumer particleConsumer, boolean inScreen) {
        for (Element element : this.elements) {
            if (!element.isMasked(state) || element.type != ElementType.PARTICLE_EMITTER || !element.particleEmitter.onInteract) continue;
            this.emitParticles(pos, direction, player.method_6051(), element, particleConsumer, inScreen, 10.0f);
        }
    }

    public boolean hasParticles() {
        return this.elements.stream().anyMatch(e -> e.type == ElementType.PARTICLE_EMITTER);
    }

    public boolean hasSounds() {
        return this.elements.stream().anyMatch(e -> e.type == ElementType.SOUND_EMITTER);
    }

    public boolean canSit() {
        return this.elements.stream().anyMatch(e -> e.type == ElementType.PLAYER_POSE && e.playerPose.pose == class_4050.field_40118);
    }

    public boolean canSleep() {
        return this.elements.stream().anyMatch(e -> e.type == ElementType.PLAYER_POSE && e.playerPose.pose == class_4050.field_18078);
    }

    public boolean hasDisplayItems() {
        return this.elements.stream().anyMatch(e -> e.type == ElementType.SPRITE && e.sprite.item);
    }

    public Set<Integer> getUniqueSolidStates() {
        Map<Integer, Long> maskCounts = this.elements.stream().filter(e -> e.type == ElementType.ELEMENT || e.type == ElementType.SPRITE).collect(Collectors.groupingBy(e -> e.mask, Collectors.counting()));
        HashSet<Integer> states = new HashSet<Integer>();
        long firstHash = -1L;
        for (int state = 0; state < 2; ++state) {
            long hash = 0L;
            for (Map.Entry<Integer, Long> entry : maskCounts.entrySet()) {
                if ((entry.getKey() & 1 << state) == 0) continue;
                hash += 1024L * (long)entry.getKey().intValue() + entry.getValue();
            }
            if (hash != firstHash) {
                states.add(state);
            }
            if (state != 0) continue;
            firstHash = hash;
        }
        return states;
    }

    public List<class_2561> getTooltip(boolean advanced) {
        LinkedList<class_2561> tooltip = new LinkedList<class_2561>();
        tooltip.add((class_2561)class_2561.method_43469((String)"gui.immersive_furniture.author", (Object[])new Object[]{this.author}).method_27692(class_124.field_1056).method_27692(class_124.field_1080));
        if (!this.originalAuthor.isEmpty() && !this.originalAuthor.equals(this.author)) {
            tooltip.add((class_2561)class_2561.method_43469((String)"gui.immersive_furniture.original_author", (Object[])new Object[]{this.originalAuthor}).method_27692(class_124.field_1056).method_27692(class_124.field_1080));
        }
        tooltip.add((class_2561)class_2561.method_43471((String)("gui.immersive_furniture.tag." + this.tag.toLowerCase(Locale.ROOT))).method_27692(class_124.field_1065).method_10852(this.getPrefixedSizeTooltip()));
        if (this.lightLevel > 0) {
            tooltip.add((class_2561)class_2561.method_43469((String)"gui.immersive_furniture.light_level", (Object[])new Object[]{this.lightLevel}).method_27692(class_124.field_1054));
        }
        if (this.inventorySize > 0) {
            tooltip.add((class_2561)class_2561.method_43469((String)"gui.immersive_furniture.inventory", (Object[])new Object[]{this.inventorySize}).method_27692(class_124.field_1054));
        }
        if (this.hasParticles()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"gui.immersive_furniture.has_particles").method_27692(class_124.field_1054));
        }
        if (this.hasSounds()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"gui.immersive_furniture.has_sounds").method_27692(class_124.field_1054));
        }
        if (this.canSit()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"gui.immersive_furniture.can_sit").method_27692(class_124.field_1054));
        }
        if (this.canSleep()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"gui.immersive_furniture.can_sleep").method_27692(class_124.field_1054));
        }
        if (this.hasDisplayItems()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"gui.immersive_furniture.has_display_items").method_27692(class_124.field_1054));
        }
        if (this.getUniqueSolidStates().size() > 1) {
            tooltip.add((class_2561)class_2561.method_43471((String)"gui.immersive_furniture.has_states").method_27692(class_124.field_1054));
        }
        boolean hasAdvanced = false;
        if (!this.sources.isEmpty()) {
            hasAdvanced = true;
            if (advanced) {
                tooltip.add((class_2561)class_2561.method_43471((String)"gui.immersive_furniture.sources").method_27692(class_124.field_1080));
                for (String string : this.sources) {
                    tooltip.add((class_2561)class_2561.method_43470((String)("- " + string)).method_27692(class_124.field_1080));
                }
            }
        }
        if (!this.dependencies.isEmpty()) {
            hasAdvanced = true;
            if (advanced) {
                tooltip.add((class_2561)class_2561.method_43471((String)"gui.immersive_furniture.dependencies").method_27692(class_124.field_1080));
                for (String string : this.dependencies) {
                    tooltip.add((class_2561)class_2561.method_43470((String)("- " + string)).method_27692(class_124.field_1080));
                }
            }
        }
        if (advanced) {
            int pixels = 0;
            for (Element element : this.elements) {
                for (Map<Integer, int[]> texture : element.bakedTextures.textures.values()) {
                    for (Map.Entry<Integer, int[]> states : texture.entrySet()) {
                        pixels += states.getValue().length;
                    }
                }
            }
            double d = (double)pixels / Math.pow(DynamicAtlas.BAKED.getSize(), 2.0);
            tooltip.add((class_2561)class_2561.method_43469((String)"gui.immersive_furniture.atlas_usage", (Object[])new Object[]{String.format("%.1f%%", d * 100.0)}).method_27692(class_124.field_1063));
        }
        if (hasAdvanced && !advanced) {
            tooltip.add((class_2561)class_2561.method_43471((String)"gui.immersive_furniture.tooltip").method_27695(new class_124[]{class_124.field_1063, class_124.field_1056}));
        }
        return tooltip;
    }

    private class_2561 getPrefixedSizeTooltip() {
        class_2561 sizeTooltip = this.getSizeTooltip();
        if (sizeTooltip == null) {
            return class_2561.method_43470((String)"");
        }
        return class_2561.method_43470((String)" - ").method_10852(sizeTooltip).method_27692(class_124.field_1080);
    }

    private class_2561 getSizeTooltip() {
        if (this.size.x == 1 && this.size.y == 1 && this.size.z == 1) {
            return null;
        }
        if (this.size.x == 1 && this.size.y == 1) {
            return class_2561.method_43469((String)"gui.immersive_furniture.n_deep", (Object[])new Object[]{this.size.z});
        }
        if (this.size.x == 1 && this.size.z == 1) {
            return class_2561.method_43469((String)"gui.immersive_furniture.n_tall", (Object[])new Object[]{this.size.y});
        }
        if (this.size.y == 1 && this.size.z == 1) {
            return class_2561.method_43469((String)"gui.immersive_furniture.n_wide", (Object[])new Object[]{this.size.x});
        }
        return class_2561.method_43470((String)String.format("%sx%sx%s", this.size.x, this.size.y, this.size.z));
    }

    public PoseOffset getClosestPose(class_243 location, class_2350 direction) {
        float bestDistance = Float.MAX_VALUE;
        PoseOffset found = null;
        for (Element element : this.elements) {
            if (element.type != ElementType.PLAYER_POSE) continue;
            Vector3f center = FurnitureData.rotate(element.getRotationAxes().center(), direction).mul(0.0625f);
            double distance = location.method_1028((double)center.x, (double)center.y, (double)center.z);
            if (found != null && !(distance < (double)bestDistance)) continue;
            bestDistance = (float)distance;
            Vector3f forward = FurnitureData.rotateVector(element.getRotationAxes().forward(), direction).normalize();
            Vector3f up = FurnitureData.rotateVector(element.getRotationAxes().up(), direction).normalize();
            if (element.playerPose.pose == class_4050.field_18078) {
                center.add((Vector3fc)forward.mul(0.5625f));
                center.sub((Vector3fc)up.mul(-0.0625f));
            } else {
                center.add((Vector3fc)forward.mul(0.125f));
                center.sub((Vector3fc)up.mul(0.03125f));
            }
            found = new PoseOffset(center, element.playerPose.pose, -element.rotation + direction.method_10144() % 360.0f);
        }
        return found;
    }

    private void emitParticles(class_2338 pos, class_2350 direction, class_5819 random, Element element, ParticleConsumer particleConsumer, boolean inScreen, float amountMultiplier) {
        class_2400 particle = element.particleEmitter.getParticle();
        if (particle == null) {
            return;
        }
        for (float c = element.particleEmitter.amount * amountMultiplier - random.method_43057(); c > 0.0f; c -= 1.0f) {
            Vector3f sampledPos = element.sampleRandomPosition(random, direction).mul(0.0625f);
            Vector3f up = new Vector3f((Vector3fc)element.getRotationAxes().up()).div(Math.abs(element.to.y - element.from.y) + 0.001f);
            float vr = element.particleEmitter.velocityRandom / 16.0f;
            float vd = element.particleEmitter.velocityDirectional / 16.0f;
            particleConsumer.addParticle(particle, sampledPos.x() + (inScreen ? 0.0f : (float)pos.method_10263()), sampledPos.y() + (inScreen ? 1024.0f : (float)pos.method_10264()), sampledPos.z() + (inScreen ? 0.0f : (float)pos.method_10260()), (random.method_43057() - 0.5f) * vr + up.x() * vd, (random.method_43057() - 0.5f) * vr + up.y() * vd, (random.method_43057() - 0.5f) * vr + up.z() * vd);
        }
    }

    public void tick(class_1937 level, class_2338 pos, int state, class_2350 direction, class_5819 random, ParticleConsumer particleConsumer, boolean inScreen, boolean inEditor) {
        for (Element element : this.elements) {
            if (!element.isMasked(state)) continue;
            if (element.type == ElementType.PARTICLE_EMITTER && !element.particleEmitter.onInteract) {
                this.emitParticles(pos, direction, random, element, particleConsumer, inScreen, 1.0f);
                continue;
            }
            if (element.type != ElementType.SOUND_EMITTER || inScreen && !inEditor || !(element.soundEmitter.frequency > 0.0f) || !(random.method_43057() < element.soundEmitter.frequency)) continue;
            FurnitureData.playSound(level, pos, random, element);
        }
    }

    private static void playSound(class_1937 level, class_2338 pos, class_5819 random, Element element) {
        class_3414 soundEvent = element.soundEmitter.getSoundEvent();
        if (soundEvent == null) {
            return;
        }
        level.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, soundEvent, class_3419.field_15245, (0.75f + random.method_43057()) * element.soundEmitter.volume, (0.75f + random.method_43057()) * element.soundEmitter.pitch, false);
    }

    public class_265 getShape(class_2350 rotation, int state) {
        return this.cachedFullShapes.computeIfAbsent(rotation.ordinal() * 31 + state, key -> this.computeShape(rotation, state));
    }

    public class_265 getShape(class_2350 rotation, int state, int offsetX, int offsetY, int offsetZ) {
        return this.cachedSubShapes.computeIfAbsent((((rotation.ordinal() * 31 + offsetX) * 31 + offsetY) * 31 + offsetZ) * 31 + state, key -> this.computeShape(rotation, state, offsetX, offsetY, offsetZ));
    }

    public class_265 getShapeLazy(class_2350 rotation) {
        int id = rotation.ordinal() * 31;
        if (this.cachedFullShapes.containsKey(id)) {
            return this.cachedFullShapes.get(id);
        }
        if (!this.requestedFullShapes.contains(id)) {
            this.requestedFullShapes.add(id);
            Common.EXECUTOR.execute(() -> this.getShape(rotation, 0));
        }
        return null;
    }

    public class_265 getShapeLazy(class_2350 rotation, int state, int offsetX, int offsetY, int offsetZ) {
        int id = (((rotation.ordinal() * 31 + offsetX) * 31 + offsetY) * 31 + offsetZ) * 31 + state;
        if (this.cachedSubShapes.containsKey(id)) {
            return this.cachedSubShapes.get(id);
        }
        if (!this.requestedSubShapes.contains(id)) {
            this.requestedSubShapes.add(id);
            Common.EXECUTOR.execute(() -> this.getShape(rotation, state, offsetX, offsetY, offsetZ));
        }
        return null;
    }

    private class_265 computeShape(class_2350 rotation, int state) {
        return this.elements.stream().filter(e -> e.type == ElementType.ELEMENT && !e.isFlat() && e.isMasked(state)).map(element -> this.getBox((Element)element, rotation)).reduce((a, b) -> class_259.method_1082((class_265)a, (class_265)b, (class_247)class_247.field_1366)).map(class_265::method_1097).orElse(class_2248.method_9541((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0));
    }

    public int getRotatedX(class_2350 facing, int x, int z) {
        return switch (facing) {
            case class_2350.field_11035 -> -x;
            case class_2350.field_11034 -> -z;
            case class_2350.field_11039 -> z;
            default -> x;
        };
    }

    public int getRotatedZ(class_2350 facing, int x, int z) {
        return switch (facing) {
            case class_2350.field_11035 -> -z;
            case class_2350.field_11034 -> x;
            case class_2350.field_11039 -> -x;
            default -> z;
        };
    }

    public class_265 computeShape(class_2350 rotation, int state, int offsetX, int offsetY, int offsetZ) {
        Vector3f start = FurnitureData.rotate(new Vector3f(offsetX == 0 ? -8.0f : 0.0f, offsetY == 0 ? -8.0f : 0.0f, offsetZ == 0 ? -8.0f : 0.0f), rotation);
        Vector3f stop = FurnitureData.rotate(new Vector3f(offsetX == this.size.x - 1 ? 24.0f : 16.0f, offsetY == this.size.y - 1 ? 24.0f : 16.0f, offsetZ == this.size.z - 1 ? 24.0f : 16.0f), rotation);
        return class_259.method_1072((class_265)this.getShape(rotation, state).method_1096((double)(-this.getRotatedX(rotation, offsetX, offsetZ)), (double)(-offsetY), (double)(-this.getRotatedZ(rotation, offsetX, offsetZ))), (class_265)class_2248.method_9541((double)Math.min(start.x, stop.x), (double)Math.min(start.y, stop.y), (double)Math.min(start.z, stop.z), (double)Math.max(start.x, stop.x), (double)Math.max(start.y, stop.y), (double)Math.max(start.z, stop.z)), (class_247)class_247.field_16896);
    }

    private static Vector3f rotate(Vector3f vec, class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11035 -> new Vector3f(16.0f - vec.x, vec.y, 16.0f - vec.z);
            case class_2350.field_11034 -> new Vector3f(16.0f - vec.z, vec.y, vec.x);
            case class_2350.field_11039 -> new Vector3f(vec.z, vec.y, 16.0f - vec.x);
            default -> new Vector3f((Vector3fc)vec);
        };
    }

    private static Vector3f rotateVector(Vector3f vec, class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11035 -> new Vector3f(-vec.x, vec.y, -vec.z);
            case class_2350.field_11034 -> new Vector3f(-vec.z, vec.y, vec.x);
            case class_2350.field_11039 -> new Vector3f(vec.z, vec.y, -vec.x);
            default -> new Vector3f((Vector3fc)vec);
        };
    }

    private class_265 getBox(Element element, class_2350 rotation) {
        float mid;
        Vector3f[] corners;
        Vector3f from = new Vector3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        Vector3f to = new Vector3f(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        for (Vector3f corner : corners = ModelUtils.getCorners(element)) {
            from.x = Math.min(from.x, corner.x);
            from.y = Math.min(from.y, corner.y);
            from.z = Math.min(from.z, corner.z);
            to.x = Math.max(to.x, corner.x);
            to.y = Math.max(to.y, corner.y);
            to.z = Math.max(to.z, corner.z);
        }
        double volume = element.getVolume();
        double newVolume = (to.x - from.x) * (to.y - from.y) * (to.z - from.z);
        float fraction = (float)Math.sqrt(volume / newVolume);
        if (element.axis != class_2350.class_2351.field_11048) {
            mid = 0.5f * (from.x + to.x);
            from.x = from.x * fraction + mid * (1.0f - fraction);
            to.x = to.x * fraction + mid * (1.0f - fraction);
        }
        if (element.axis != class_2350.class_2351.field_11052) {
            mid = 0.5f * (from.y + to.y);
            from.y = from.y * fraction + mid * (1.0f - fraction);
            to.y = to.y * fraction + mid * (1.0f - fraction);
        }
        if (element.axis != class_2350.class_2351.field_11051) {
            mid = 0.5f * (from.z + to.z);
            from.z = from.z * fraction + mid * (1.0f - fraction);
            to.z = to.z * fraction + mid * (1.0f - fraction);
        }
        Vector3f rotatedFrom = FurnitureData.rotate(from, rotation);
        Vector3f rotatedTo = FurnitureData.rotate(to, rotation);
        float resolution = this.elements.size() > 96 ? 1.0f : (this.elements.size() > 48 ? 2.0f : 4.0f);
        return class_2248.method_9541((double)((float)Math.round(Math.min(rotatedFrom.x, rotatedTo.x) * resolution) / resolution), (double)((float)Math.round(Math.min(rotatedFrom.y, rotatedTo.y) * resolution) / resolution), (double)((float)Math.round(Math.min(rotatedFrom.z, rotatedTo.z) * resolution) / resolution), (double)((float)Math.round(Math.max(rotatedFrom.x, rotatedTo.x) * resolution) / resolution), (double)((float)Math.round(Math.max(rotatedFrom.y, rotatedTo.y) * resolution) / resolution), (double)((float)Math.round(Math.max(rotatedFrom.z, rotatedTo.z) * resolution) / resolution));
    }

    public static class Element {
        public Vector3f from;
        public Vector3f to;
        public class_2350.class_2351 axis = class_2350.class_2351.field_11052;
        public float rotation = 0.0f;
        public ElementType type = ElementType.ELEMENT;
        public int color = -1;
        public int emission = 0;
        public int mask = 3;
        public Material material;
        public ParticleEmitter particleEmitter;
        public SoundEmitter soundEmitter;
        public PlayerPose playerPose;
        public Sprite sprite;
        public ElementBakedTextures bakedTextures = new ElementBakedTextures();
        public ElementRotationAxes rotationAxes;

        public Element() {
            this.from = new Vector3f(2.0f, 0.0f, 2.0f);
            this.to = new Vector3f(14.0f, 12.0f, 14.0f);
            this.material = new Material();
            this.particleEmitter = new ParticleEmitter();
            this.soundEmitter = new SoundEmitter();
            this.playerPose = new PlayerPose();
            this.sprite = new Sprite();
        }

        public Element(class_2487 tag) {
            this.from = NBTHelper.getVector3f(tag.method_10554("From", 5));
            this.to = NBTHelper.getVector3f(tag.method_10554("To", 5));
            this.axis = NBTHelper.getEnum(tag, class_2350.class_2351.class, "Axis", this.axis);
            this.rotation = NBTHelper.getFloat(tag, "Rotation", this.rotation);
            this.type = NBTHelper.getEnum(tag, ElementType.class, "Type", this.type);
            this.color = NBTHelper.getInt(tag, "Color", this.color);
            this.emission = NBTHelper.getInt(tag, "Emission", 0);
            this.material = new Material(tag.method_10562("Material"));
            this.particleEmitter = new ParticleEmitter(tag.method_10562("ParticleEmitter"));
            this.soundEmitter = new SoundEmitter(tag.method_10562("SoundEmitter"));
            this.playerPose = new PlayerPose(tag.method_10562("PlayerPose"));
            this.sprite = new Sprite(tag.method_10562("Sprite"));
            this.mask = NBTHelper.getInt(tag, "Mask", this.mask);
            this.bakedTextures = new ElementBakedTextures(tag.method_10562("BakedTexture"), tag.method_10562("BakedTextures"));
        }

        public Element(Element element) {
            this.from = new Vector3f((Vector3fc)element.from);
            this.to = new Vector3f((Vector3fc)element.to);
            this.axis = element.axis;
            this.rotation = element.rotation;
            this.type = element.type;
            this.color = element.color;
            this.emission = element.emission;
            this.mask = element.mask;
            this.material = new Material(element.material);
            this.particleEmitter = new ParticleEmitter(element.particleEmitter);
            this.soundEmitter = new SoundEmitter(element.soundEmitter);
            this.playerPose = new PlayerPose(element.playerPose);
            this.sprite = new Sprite(element.sprite);
            this.bakedTextures = new ElementBakedTextures();
            this.rotationAxes = null;
        }

        public class_2487 toTag() {
            class_2487 tag = new class_2487();
            tag.method_10566("From", (class_2520)NBTHelper.getFloatList(this.from));
            tag.method_10566("To", (class_2520)NBTHelper.getFloatList(this.to));
            tag.method_10582("Axis", this.axis.method_15434());
            tag.method_10548("Rotation", this.rotation);
            tag.method_10582("Type", this.type.name().toLowerCase());
            tag.method_10569("Color", this.color);
            tag.method_10569("Emission", this.emission);
            tag.method_10569("Mask", this.mask);
            if (this.type == ElementType.ELEMENT) {
                tag.method_10566("Material", (class_2520)this.material.toTag());
                this.bakedTextures.save(tag);
            } else if (this.type == ElementType.PARTICLE_EMITTER) {
                tag.method_10566("ParticleEmitter", (class_2520)this.particleEmitter.toTag());
            } else if (this.type == ElementType.SOUND_EMITTER) {
                tag.method_10566("SoundEmitter", (class_2520)this.soundEmitter.toTag());
            } else if (this.type == ElementType.PLAYER_POSE) {
                tag.method_10566("PlayerPose", (class_2520)this.playerPose.toTag());
            } else if (this.type == ElementType.SPRITE) {
                tag.method_10566("Sprite", (class_2520)this.sprite.toTag());
            }
            return tag;
        }

        public Vector3i getSize() {
            return new Vector3i(Math.abs((int)(this.to.x - this.from.x)), Math.abs((int)(this.to.y - this.from.y)), Math.abs((int)(this.to.z - this.from.z)));
        }

        public float getVolume() {
            Vector3i size = this.getSize();
            return size.x * size.y * size.z;
        }

        public Vector3f getCenter() {
            return new Vector3f((this.from.x + this.to.x) / 2.0f, (this.from.y + this.to.y) / 2.0f, (this.from.z + this.to.z) / 2.0f);
        }

        public ElementRotation getRotation() {
            return new ElementRotation(this.getOrigin(), this.axis, this.rotation, false);
        }

        public Vector3f getOrigin() {
            return new Vector3f((this.from.x + this.to.x) / 32.0f, (this.from.y + this.to.y) / 32.0f, (this.from.z + this.to.z) / 32.0f);
        }

        public void sanityCheck() {
            if (this.sprite.item) {
                this.sprite.tiled = false;
                this.sprite.sprite = new class_2960("minecraft:item/bread");
            }
            if (this.type == ElementType.PLAYER_POSE) {
                Vector3f center = this.getCenter();
                this.from.x = center.x - 4.0f;
                this.from.y = center.y - 1.0f;
                this.from.z = center.z - (this.playerPose.pose == class_4050.field_18078 ? 14.0f : 4.0f);
                this.to.x = center.x + 4.0f;
                this.to.y = center.y + 1.0f;
                this.to.z = center.z + (this.playerPose.pose == class_4050.field_18078 ? 14.0f : 4.0f);
                this.axis = class_2350.class_2351.field_11052;
            } else if (this.type == ElementType.SPRITE) {
                Vector3f center = this.getCenter();
                if (!this.sprite.tiled) {
                    this.from.x = center.x - 8.0f * this.sprite.size;
                    this.from.y = center.y - 8.0f * this.sprite.size;
                    this.to.x = center.x + 8.0f * this.sprite.size;
                    this.to.y = center.y + 8.0f * this.sprite.size;
                }
                this.to.z = this.from.z;
            } else if (this.type == ElementType.ELEMENT) {
                this.color = -1;
            }
            this.from.x = (float)Math.round(this.from.x * 64.0f) / 64.0f;
            this.from.y = (float)Math.round(this.from.y * 64.0f) / 64.0f;
            this.from.z = (float)Math.round(this.from.z * 64.0f) / 64.0f;
            this.to.x = (float)Math.round(this.to.x - this.from.x) + this.from.x;
            this.to.y = (float)Math.round(this.to.y - this.from.y) + this.from.y;
            this.to.z = (float)Math.round(this.to.z - this.from.z) + this.from.z;
        }

        public boolean contains(Vector3f pos) {
            return this.contains(pos, 1.0E-4f);
        }

        public boolean contains(Vector3f pos, float margin) {
            return pos.x >= this.from.x - margin && pos.x <= this.to.x + margin && pos.y >= this.from.y - margin && pos.y <= this.to.y + margin && pos.z >= this.from.z - margin && pos.z <= this.to.z + margin;
        }

        public void move(float x, float y, float z) {
            this.from.add(x, y, z);
            this.to.add(x, y, z);
        }

        public ElementRotationAxes getRotationAxes() {
            if (this.rotationAxes == null) {
                this.rotationAxes = new ElementRotationAxes(this.getCenter(), this.getSize());
                ElementRotation elementRotation = this.getRotation();
                Quaternionf quaternion = ModelUtils.getElementRotation(elementRotation);
                quaternion.transform(this.rotationAxes.up);
                quaternion.transform(this.rotationAxes.right);
                quaternion.transform(this.rotationAxes.forward);
                ModelUtils.applyElementRotation(this.rotationAxes.center, elementRotation);
            }
            return this.rotationAxes;
        }

        public Vector3f sampleRandomPosition(class_5819 random, class_2350 direction) {
            ElementRotationAxes axes = this.getRotationAxes();
            float x = random.method_43057() - 0.5f;
            float y = random.method_43057() - 0.5f;
            float z = random.method_43057() - 0.5f;
            Vector3f pos = new Vector3f(axes.center.x + x * axes.right.x + y * axes.up.x + z * axes.forward.x, axes.center.y + x * axes.right.y + y * axes.up.y + z * axes.forward.y, axes.center.z + x * axes.right.z + y * axes.up.z + z * axes.forward.z);
            if (direction != null) {
                return FurnitureData.rotate(pos, direction);
            }
            return pos;
        }

        public Vector3f getGlobalDirectionNormal(class_2350 direction) {
            return ModelUtils.rotate(direction.method_23955(), this.axis, this.rotation);
        }

        public boolean isFlat() {
            return this.from.x == this.to.x || this.from.y == this.to.y || this.from.z == this.to.z;
        }

        public boolean isMasked(int state) {
            return (this.mask & 1 << state) != 0;
        }
    }

    public static enum ElementType {
        ELEMENT,
        PARTICLE_EMITTER,
        SOUND_EMITTER,
        PLAYER_POSE,
        SPRITE;

    }

    public record ElementRotationAxes(Vector3f center, Vector3f right, Vector3f up, Vector3f forward) {
        public ElementRotationAxes(Vector3f center, Vector3i size) {
            this(center, new Vector3f((float)size.x(), 0.0f, 0.0f), new Vector3f(0.0f, (float)size.y(), 0.0f), new Vector3f(0.0f, 0.0f, (float)size.z()));
        }
    }

    public static class ElementBakedTextures {
        public Map<class_2350, Map<Integer, int[]>> textures = new ConcurrentHashMap<class_2350, Map<Integer, int[]>>();

        public ElementBakedTextures() {
        }

        public ElementBakedTextures(class_2487 primary, class_2487 secondary) {
            this.loadTextures(primary);
            this.loadTextures(secondary);
        }

        private void loadTextures(class_2487 secondary) {
            for (String key : secondary.method_10541()) {
                String[] split = key.split(":");
                class_2350 direction = (class_2350)class_2350.field_29502.method_42633(split[0]);
                int state = split.length == 1 ? 0 : Integer.parseInt(split[1]);
                this.put(direction, state, secondary.method_10561(key));
            }
        }

        public void save(class_2487 tag) {
            class_2487 primary = new class_2487();
            class_2487 secondary = new class_2487();
            for (Map.Entry<class_2350, Map<Integer, int[]>> directionMapEntry : this.textures.entrySet()) {
                class_2350 direction = directionMapEntry.getKey();
                Map<Integer, int[]> stateMap = directionMapEntry.getValue();
                for (Map.Entry<Integer, int[]> stateEntry : stateMap.entrySet()) {
                    int state = stateEntry.getKey();
                    int[] texture = stateEntry.getValue();
                    if (state == 0) {
                        primary.method_10539(direction.method_15434(), texture);
                        continue;
                    }
                    secondary.method_10539(direction.method_15434() + ":" + state, texture);
                }
            }
            tag.method_10566("BakedTexture", (class_2520)primary);
            tag.method_10566("BakedTextures", (class_2520)secondary);
        }

        public void clear() {
            this.textures.clear();
        }

        public int[] get(class_2350 direction, int state) {
            Map<Integer, int[]> states = this.textures.get(direction);
            return states == null ? null : states.getOrDefault(state, states.get(0));
        }

        public void put(class_2350 direction, int state, int[] baked) {
            Map states = this.textures.computeIfAbsent(direction, k -> new HashMap());
            if (state == 0 || !states.containsKey(0) || !Arrays.equals((int[])states.get(0), baked)) {
                states.put(state, baked);
            }
        }
    }

    public static class SoundEmitter {
        public class_2960 sound = new class_2960("minecraft:entity.item.pickup");
        public float volume = 1.0f;
        public float pitch = 1.0f;
        public float frequency = 0.1f;
        public boolean onInteract = false;

        public SoundEmitter() {
        }

        public SoundEmitter(class_2487 tag) {
            this.sound = NBTHelper.getResourceLocation(tag, "Sound", this.sound);
            this.volume = NBTHelper.getFloat(tag, "Volume", this.volume);
            this.pitch = NBTHelper.getFloat(tag, "Pitch", this.pitch);
            this.frequency = NBTHelper.getFloat(tag, "Frequency", this.frequency);
            this.onInteract = NBTHelper.getBoolean(tag, "OnInteract", this.onInteract);
        }

        public SoundEmitter(SoundEmitter soundEmitter) {
            this.sound = soundEmitter.sound;
            this.volume = soundEmitter.volume;
            this.pitch = soundEmitter.pitch;
            this.frequency = soundEmitter.frequency;
            this.onInteract = soundEmitter.onInteract;
        }

        public class_2487 toTag() {
            class_2487 tag = new class_2487();
            tag.method_10582("Sound", this.sound.toString());
            tag.method_10548("Volume", this.volume);
            tag.method_10548("Pitch", this.pitch);
            tag.method_10548("Frequency", this.frequency);
            tag.method_10556("OnInteract", this.onInteract);
            return tag;
        }

        public class_3414 getSoundEvent() {
            return (class_3414)class_7923.field_41172.method_10223(this.sound);
        }
    }

    public static class ParticleEmitter {
        public class_2960 particle = new class_2960("minecraft:smoke");
        public float velocityDirectional = 0.0f;
        public float velocityRandom = 0.1f;
        public float amount = 0.5f;
        public boolean onInteract = false;

        public ParticleEmitter() {
        }

        public ParticleEmitter(class_2487 tag) {
            this.particle = NBTHelper.getResourceLocation(tag, "Particle", this.particle);
            this.velocityDirectional = NBTHelper.getFloat(tag, "VelocityDirectional", this.velocityDirectional);
            this.velocityRandom = NBTHelper.getFloat(tag, "VelocityRandom", this.velocityRandom);
            this.amount = NBTHelper.getFloat(tag, "Amount", this.amount);
            this.onInteract = NBTHelper.getBoolean(tag, "OnInteract", this.onInteract);
        }

        public ParticleEmitter(ParticleEmitter particleEmitter) {
            this.particle = particleEmitter.particle;
            this.velocityDirectional = particleEmitter.velocityDirectional;
            this.velocityRandom = particleEmitter.velocityRandom;
            this.amount = particleEmitter.amount;
            this.onInteract = particleEmitter.onInteract;
        }

        public class_2487 toTag() {
            class_2487 tag = new class_2487();
            tag.method_10582("Particle", this.particle.toString());
            tag.method_10548("VelocityDirectional", this.velocityDirectional);
            tag.method_10548("VelocityRandom", this.velocityRandom);
            tag.method_10548("Amount", this.amount);
            tag.method_10556("OnInteract", this.onInteract);
            return tag;
        }

        public class_2400 getParticle() {
            Object object = class_7923.field_41180.method_10223(this.particle);
            if (object instanceof class_2400) {
                class_2400 simpleParticleType = (class_2400)object;
                return simpleParticleType;
            }
            return null;
        }
    }

    public static interface ParticleConsumer {
        public void addParticle(class_2400 var1, float var2, float var3, float var4, float var5, float var6, float var7);
    }

    public static class PlayerPose {
        public class_4050 pose = class_4050.field_40118;

        public PlayerPose() {
        }

        public PlayerPose(class_2487 tag) {
            this.pose = NBTHelper.getEnum(tag, class_4050.class, "Pose", this.pose);
        }

        public PlayerPose(PlayerPose playerPose) {
            this.pose = playerPose.pose;
        }

        public class_2487 toTag() {
            class_2487 tag = new class_2487();
            tag.method_10582("Pose", this.pose.name());
            return tag;
        }
    }

    public record PoseOffset(Vector3f offset, class_4050 pose, float rotation) {
    }

    public static class Sprite {
        public class_2960 sprite = new class_2960("minecraft:block/soul_fire_1");
        public int rotation = 0;
        public float size = 1.0f;
        public boolean tiled = false;
        public boolean item = false;
        public boolean align = false;

        public Sprite() {
        }

        public Sprite(class_2487 tag) {
            this.sprite = NBTHelper.getResourceLocation(tag, "Sprite", this.sprite);
            this.rotation = NBTHelper.getInt(tag, "Rotation", this.rotation);
            this.size = NBTHelper.getFloat(tag, "Size", this.size);
            this.tiled = NBTHelper.getBoolean(tag, "Tiled", this.tiled);
            this.item = NBTHelper.getBoolean(tag, "Item", this.item);
            this.align = NBTHelper.getBoolean(tag, "Align", this.align);
        }

        public Sprite(Sprite sprite) {
            this.sprite = sprite.sprite;
            this.rotation = sprite.rotation;
            this.size = sprite.size;
            this.tiled = sprite.tiled;
            this.item = sprite.item;
            this.align = sprite.align;
        }

        public class_2487 toTag() {
            class_2487 tag = new class_2487();
            tag.method_10582("Sprite", this.sprite.toString());
            tag.method_10569("Rotation", this.rotation);
            tag.method_10548("Size", this.size);
            tag.method_10556("Tiled", this.tiled);
            tag.method_10556("Item", this.item);
            tag.method_10556("Align", this.align);
            return tag;
        }
    }

    public static class LightMaterialEffect {
        public float roundness = 0.0f;
        public float brightness = 0.0f;
        public float contrast = 0.0f;
        public float hue = 0.0f;
        public float saturation = 0.0f;
        public float value = 0.0f;

        public LightMaterialEffect() {
        }

        public LightMaterialEffect(LightMaterialEffect lightEffect) {
            this.roundness = lightEffect.roundness;
            this.brightness = lightEffect.brightness;
            this.contrast = lightEffect.contrast;
            this.hue = lightEffect.hue;
            this.saturation = lightEffect.saturation;
            this.value = lightEffect.value;
        }

        public void load(class_2487 tag) {
            this.roundness = NBTHelper.getFloat(tag, "Roundness", this.roundness);
            this.brightness = NBTHelper.getFloat(tag, "Brightness", this.brightness);
            this.contrast = NBTHelper.getFloat(tag, "Contrast", this.contrast);
            this.hue = NBTHelper.getFloat(tag, "Hue", this.hue);
            this.saturation = NBTHelper.getFloat(tag, "Saturation", this.saturation);
            this.value = NBTHelper.getFloat(tag, "Value", this.value);
        }

        public class_2487 save() {
            class_2487 tag = new class_2487();
            tag.method_10548("Roundness", this.roundness);
            tag.method_10548("Brightness", this.brightness);
            tag.method_10548("Contrast", this.contrast);
            tag.method_10548("Hue", this.hue);
            tag.method_10548("Saturation", this.saturation);
            tag.method_10548("Value", this.value);
            return tag;
        }
    }

    public static class Material {
        public class_2960 source = new class_2960("minecraft:oak_log");
        public int margin = 4;
        public WrapMode wrap = WrapMode.EXPAND;
        public MaterialAxis axis = MaterialAxis.X;
        public TransparencyType transparency = TransparencyType.SOLID;
        public LightMaterialEffect lightEffect = new LightMaterialEffect();

        public Material() {
        }

        public Material(class_2487 tag) {
            this.source = NBTHelper.getResourceLocation(tag, "Source", this.source);
            this.margin = NBTHelper.getInt(tag, "Margin", this.margin);
            this.wrap = NBTHelper.getEnum(tag, WrapMode.class, "Wrap", this.wrap);
            this.axis = NBTHelper.getEnum(tag, MaterialAxis.class, "Axis", this.axis);
            this.transparency = NBTHelper.getEnum(tag, TransparencyType.class, "Transparency", this.transparency);
            this.lightEffect.load(tag.method_10562("LightEffect"));
        }

        public Material(Material material) {
            this.source = material.source;
            this.margin = material.margin;
            this.wrap = material.wrap;
            this.axis = material.axis;
            this.transparency = material.transparency;
            this.lightEffect = new LightMaterialEffect(material.lightEffect);
        }

        public class_2487 toTag() {
            class_2487 tag = new class_2487();
            tag.method_10582("Source", this.source.toString());
            tag.method_10569("Margin", this.margin);
            tag.method_10582("Wrap", this.wrap.name());
            tag.method_10582("Axis", this.axis.name());
            tag.method_10582("Transparency", this.transparency.name());
            tag.method_10566("LightEffect", (class_2520)this.lightEffect.save());
            return tag;
        }
    }

    public static enum MaterialAxis {
        X,
        Y,
        Z;

    }

    public static enum WrapMode {
        EXPAND,
        REPEAT;

    }
}

