/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.data;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import net.conczin.immersive_furniture.Common;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.api.API;
import net.conczin.immersive_furniture.data.api.responses.ContentResponse;
import net.conczin.immersive_furniture.data.api.responses.Response;
import net.conczin.immersive_furniture.network.Network;
import net.conczin.immersive_furniture.network.c2s.FurnitureDataRequest;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2960;

public class FurnitureDataManager {
    public static final Path gameRoot = Path.of("./immersive_furniture", new String[0]);
    public static Path worldRoot = Path.of("./immersive_furniture", new String[0]);
    public static final Map<class_2960, FurnitureData> DATA = new ConcurrentHashMap<class_2960, FurnitureData>();
    public static final Set<class_2960> REQUESTED_DATA = ConcurrentHashMap.newKeySet();
    private static final Set<String> alreadySaved = new ConcurrentSkipListSet<String>();

    public static void setWorldRoot(Path worldPath) {
        worldRoot = worldPath.resolve("immersive_furniture").normalize();
        alreadySaved.clear();
    }

    public static void setWorldRoot() {
        worldRoot = gameRoot;
        alreadySaved.clear();
    }

    private static File getFile(class_2960 id) {
        String path = id.method_12836() + "/" + id.method_12832() + ".nbt";
        File oldFile = gameRoot.resolve(path).toFile();
        if (oldFile.exists()) {
            return oldFile;
        }
        File file = oldFile;
        if (id.method_12836().equals("hash")) {
            file = worldRoot.resolve(path).toFile();
        }
        file.getParentFile().mkdirs();
        return file;
    }

    private static void delete(File file) {
        file.delete();
    }

    public static String toSafeName(String input) {
        String safe = input.replaceAll("[^a-z0-9_\\-.]", "_");
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(input.getBytes());
            StringBuilder hex = new StringBuilder();
            for (byte b : hash) {
                hex.append(String.format("%02x", b));
            }
            return safe + "_" + String.valueOf(hex);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<class_2960> getLocalFiles() {
        File cache = new File("./immersive_furniture/local");
        File[] files = cache.listFiles();
        if (files == null) {
            return List.of();
        }
        return Arrays.stream(files).filter(p -> p.getPath().endsWith(".nbt")).sorted((a, b) -> Long.compare(b.lastModified(), a.lastModified())).map(p -> new class_2960("local", p.getName().replace(".nbt", ""))).toList();
    }

    public static class_2960 getSafeLocalLocation(FurnitureData data) {
        return new class_2960("local", FurnitureDataManager.toSafeName(data.name.toLowerCase(Locale.ROOT)));
    }

    public static boolean localFileExists(FurnitureData data) {
        return FurnitureDataManager.getFile(FurnitureDataManager.getSafeLocalLocation(data)).exists();
    }

    public static void deleteLocalFile(class_2960 location) {
        FurnitureDataManager.delete(FurnitureDataManager.getFile(location));
    }

    public static void saveLocalFile(FurnitureData data) {
        FurnitureDataManager.save(data, FurnitureDataManager.getSafeLocalLocation(data));
    }

    public static void save(FurnitureData data, class_2960 id) {
        File cache = FurnitureDataManager.getFile(id);
        try {
            class_2507.method_30614((class_2487)data.toTag(), (File)cache);
            DATA.put(id, data);
        }
        catch (IOException e) {
            Common.logger.error("Failed to save local file: {}", (Object)cache.getPath(), (Object)e);
        }
    }

    public static void saveHashData(FurnitureData data) {
        String hash = data.getHash();
        if (alreadySaved.contains(hash)) {
            return;
        }
        alreadySaved.add(hash);
        FurnitureDataManager.save(data, new class_2960("hash", data.getHash()));
    }

    public static FurnitureData getData(String hash) {
        class_2960 cachedLocation = new class_2960("cache", hash);
        if (DATA.containsKey(cachedLocation)) {
            return DATA.get(cachedLocation);
        }
        return FurnitureDataManager.getHashData(hash);
    }

    public static FurnitureData getCachedData(String hash) {
        return FurnitureDataManager.getData(new class_2960("cache", hash));
    }

    public static FurnitureData getHashData(String hash) {
        return FurnitureDataManager.getData(new class_2960("hash", hash));
    }

    public static FurnitureData getData(class_2960 id) {
        if (!DATA.containsKey(id) && !REQUESTED_DATA.contains(id)) {
            REQUESTED_DATA.add(id);
            File cache = FurnitureDataManager.getFile(id);
            if (cache.exists()) {
                try {
                    class_2487 tag = class_2507.method_30613((File)cache);
                    FurnitureData data = new FurnitureData(tag);
                    DATA.put(id, data);
                }
                catch (IOException e) {
                    FurnitureDataManager.delete(cache);
                    Common.logger.error("Failed to read file: {}", (Object)cache, (Object)e);
                }
            }
            if (id.method_12836().equals("library")) {
                int version;
                int contentid;
                try {
                    String[] split = id.method_12832().split("\\.");
                    contentid = Integer.parseInt(split[0]);
                    version = Integer.parseInt(split[1]);
                }
                catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                    Common.logger.error("Failed to parse content id and version from: {}", (Object)id, (Object)e);
                    return null;
                }
                CompletableFuture.runAsync(() -> {
                    Response response = API.request(API.HttpMethod.GET, ContentResponse::new, "content/furniture/" + contentid, Map.of("version", String.valueOf(version)));
                    if (response instanceof ContentResponse) {
                        ContentResponse contentResponse = (ContentResponse)response;
                        ByteArrayInputStream in = new ByteArrayInputStream(Base64.getDecoder().decode(contentResponse.content().data()));
                        try {
                            FurnitureData data = new FurnitureData(class_2507.method_10629((InputStream)in));
                            data.contentid = contentid;
                            data.author = contentResponse.content().username();
                            class_2507.method_30614((class_2487)data.toTag(), (File)FurnitureDataManager.getFile(id));
                            DATA.put(id, data);
                        }
                        catch (Exception e) {
                            Common.logger.error("Failed to read content response: {}", (Object)contentResponse, (Object)e);
                        }
                    }
                });
            } else if (id.method_12836().equals("cache")) {
                Network.sendToServer(new FurnitureDataRequest(id.method_12832()));
            }
        }
        return DATA.get(id);
    }
}

