/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.data.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import net.conczin.immersive_furniture.Common;
import net.conczin.immersive_furniture.config.Config;
import net.conczin.immersive_furniture.data.api.Auth;
import net.conczin.immersive_furniture.data.api.responses.ErrorResponse;
import net.conczin.immersive_furniture.data.api.responses.Response;
import net.conczin.immersive_furniture.data.api.responses.SuccessResponse;
import org.apache.commons.io.IOUtils;

public class API {
    private static final Gson gson = new GsonBuilder().create();

    public static Response request(HttpMethod httpMethod, String url) {
        return API.request(httpMethod, SuccessResponse::new, url, null, null);
    }

    public static <T extends Response> Response request(HttpMethod httpMethod, Function<JsonObject, T> decoder, String url) {
        return API.request(httpMethod, decoder, url, null, null);
    }

    public static <T extends Response> Response request(HttpMethod httpMethod, Function<JsonObject, T> decoder, String url, Map<String, String> queryParams) {
        return API.request(httpMethod, decoder, url, queryParams, null);
    }

    public static <T extends Response> Response request(HttpMethod httpMethod, Function<JsonObject, T> decoder, String url, Map<String, String> queryParams, Map<String, Object> body) {
        try {
            Object fullUrl = Config.getInstance().immersiveLibraryUrl + (url.contains("v2") ? "/" : "/v1/") + url;
            if (queryParams != null) {
                fullUrl = queryParams.keySet().stream().map(key -> key + "=" + URLEncoder.encode((String)queryParams.get(key), StandardCharsets.UTF_8)).collect(Collectors.joining("&", (String)fullUrl + "?", ""));
            }
            HttpURLConnection con = (HttpURLConnection)new URL((String)fullUrl).openConnection();
            con.setRequestMethod(httpMethod.name());
            con.setRequestProperty("Content-Type", "application/json");
            con.setRequestProperty("Accept-Encoding", "gzip");
            con.setRequestProperty("Accept", "application/json");
            if (Auth.hasToken()) {
                con.setRequestProperty("Authorization", "Bearer " + Auth.getToken());
            }
            if (body != null && !body.isEmpty()) {
                con.setDoOutput(true);
                Gson gson = new Gson();
                String jsonBody = gson.toJson(body);
                con.getOutputStream().write(jsonBody.getBytes(StandardCharsets.UTF_8));
            }
            if (con.getErrorStream() != null) {
                int responseCode = con.getResponseCode();
                String error = IOUtils.toString((InputStream)con.getErrorStream(), (Charset)StandardCharsets.UTF_8);
                JsonObject object = (JsonObject)gson.fromJson(error, JsonObject.class);
                return new ErrorResponse(responseCode, object.get("message").getAsString());
            }
            String response = "gzip".equals(con.getContentEncoding()) ? IOUtils.toString((InputStream)new GZIPInputStream(con.getInputStream()), (Charset)StandardCharsets.UTF_8) : IOUtils.toString((InputStream)con.getInputStream(), (Charset)StandardCharsets.UTF_8);
            JsonObject object = (JsonObject)gson.fromJson(response, JsonObject.class);
            return (Response)decoder.apply(object);
        }
        catch (IOException e) {
            Common.logger.warn((Object)e, (Throwable)e);
            return new ErrorResponse(-1, e.toString());
        }
        catch (Exception e) {
            Common.logger.error((Object)e, (Throwable)e);
            return new ErrorResponse(-1, e.toString());
        }
    }

    public static enum HttpMethod {
        POST,
        GET,
        DELETE,
        PUT;

    }
}

