/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.fabric;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.conczin.immersive_furniture.Common;
import net.conczin.immersive_furniture.Sounds;
import net.conczin.immersive_furniture.block.Blocks;
import net.conczin.immersive_furniture.block.entity.BlockEntityTypes;
import net.conczin.immersive_furniture.data.FurnitureDataManager;
import net.conczin.immersive_furniture.data.ServerFurnitureRegistry;
import net.conczin.immersive_furniture.entity.Entities;
import net.conczin.immersive_furniture.item.Items;
import net.conczin.immersive_furniture.network.ImmersivePayload;
import net.conczin.immersive_furniture.network.Network;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

public final class CommonFabric
implements ModInitializer {
    FabricRegistrar fabricRegistrar = new FabricRegistrar();

    private static <T> void registerHelper(class_2378<T> register, Consumer<Common.RegisterHelper<T>> consumer) {
        consumer.accept((name, value) -> class_2378.method_10230((class_2378)register, (class_2960)name, (Object)value));
    }

    public void onInitialize() {
        CommonFabric.registerHelper(class_7923.field_41178, Items::registerItems);
        CommonFabric.registerHelper(class_7923.field_41175, Blocks::registerBlocks);
        CommonFabric.registerHelper(class_7923.field_41172, Sounds::registerSounds);
        CommonFabric.registerHelper(class_7923.field_41177, Entities::registerEntities);
        BlockEntityTypes.register((name, factory, block) -> (class_2591)class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)name, (Object)class_2591.class_2592.method_20528(factory::create, (class_2248[])new class_2248[]{block}).method_11034(null)));
        Network.register(this.fabricRegistrar);
        Network.registerSender((payload, player) -> {
            class_2540 buf = new class_2540(Unpooled.buffer());
            payload.encode(buf);
            ServerPlayNetworking.send((class_3222)player, (class_2960)this.fabricRegistrar.getMessageIdentifier(payload), (class_2540)buf);
        });
        Network.registerClientSender(payload -> {
            class_2540 buf = new class_2540(Unpooled.buffer());
            payload.encode(buf);
            ClientPlayNetworking.send((class_2960)this.fabricRegistrar.getMessageIdentifier(payload), (class_2540)buf);
        });
        ServerPlayConnectionEvents.JOIN.register((player, handler, sender) -> ServerFurnitureRegistry.syncWithPlayer(player.field_14140));
        ServerLifecycleEvents.SERVER_STARTING.register(server -> FurnitureDataManager.setWorldRoot(server.method_27050(class_5218.field_24188)));
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40197).register(itemGroup -> itemGroup.method_45421((class_1935)Items.ARTISANS_WORKSTATION));
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41062).register(itemGroup -> itemGroup.method_45421((class_1935)Items.CRAFTING_MATERIAL));
    }

    public static class FabricRegistrar
    implements Network.Registrar {
        private final Map<Class<?>, class_2960> identifiers = new HashMap();
        private int id = 0;

        private <T> class_2960 createMessageIdentifier(Class<T> msg) {
            return Common.locate(msg.getSimpleName().toLowerCase(Locale.ROOT).substring(0, 8) + this.id++);
        }

        private class_2960 getMessageIdentifier(ImmersivePayload msg) {
            return Objects.requireNonNull(this.identifiers.get(msg.getClass()), "Used unregistered message!");
        }

        @Override
        public <T extends ImmersivePayload> void register(Class<T> msg, Function<class_2540, T> constructor) {
            class_2960 identifier = this.createMessageIdentifier(msg);
            this.identifiers.put(msg, identifier);
            ServerPlayNetworking.registerGlobalReceiver((class_2960)identifier, (server, player, handler, buffer, responder) -> {
                ImmersivePayload m = (ImmersivePayload)constructor.apply(buffer);
                server.execute(() -> m.handle((class_1657)player));
            });
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                ClientProxy.register(identifier, constructor);
            }
        }
    }

    private static final class ClientProxy {
        private ClientProxy() {
        }

        public static <T extends ImmersivePayload> void register(class_2960 id, Function<class_2540, T> constructor) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)id, (client, ignore1, buffer, ignore2) -> {
                ImmersivePayload m = (ImmersivePayload)constructor.apply(buffer);
                client.execute(() -> m.handle((class_1657)client.field_1724));
            });
        }
    }
}

