/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.item;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.conczin.immersive_furniture.block.BaseFurnitureBlock;
import net.conczin.immersive_furniture.block.Blocks;
import net.conczin.immersive_furniture.block.EntityFurnitureBlock;
import net.conczin.immersive_furniture.block.FurnitureBlock;
import net.conczin.immersive_furniture.block.FurnitureProxyBlock;
import net.conczin.immersive_furniture.block.LightFurnitureBlock;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.FurnitureDataManager;
import net.conczin.immersive_furniture.data.ServerFurnitureRegistry;
import net.minecraft.class_1269;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_437;

public class FurnitureItem
extends class_1747 {
    public static final String FURNITURE = "Furniture";
    public static final String FURNITURE_HASH = "FurnitureHash";
    private static final Map<Integer, FurnitureData> cache = new LinkedHashMap<Integer, FurnitureData>(100, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, FurnitureData> eldest) {
            return this.size() > 100;
        }
    };

    public FurnitureItem(class_1792.class_1793 settings) {
        super(Blocks.FURNITURE, settings);
    }

    public class_2561 method_7864(class_1799 stack) {
        return class_2561.method_43470((String)FurnitureItem.getData((class_1799)stack).name);
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        FurnitureData data = FurnitureItem.getData(stack);
        tooltip.addAll(data.getTooltip(class_437.method_25442()));
        super.method_7851(stack, world, tooltip, context);
    }

    public static FurnitureData getData(class_1799 stack) {
        class_2487 tag = stack.method_7941("BlockEntityTag");
        if (tag == null) {
            return FurnitureData.EMPTY;
        }
        int hash = System.identityHashCode(tag = tag.method_10562(FURNITURE));
        if (!cache.containsKey(hash)) {
            cache.put(hash, new FurnitureData(tag));
        }
        return cache.get(hash);
    }

    public static void setData(class_1799 stack, FurnitureData data) {
        class_2487 tag = stack.method_7911("BlockEntityTag");
        tag.method_10566(FURNITURE, (class_2520)data.toTag());
    }

    public class_1269 method_7884(class_1838 context) {
        if (context.method_8045().field_9236) {
            return class_1269.field_5812;
        }
        return super.method_7884(context);
    }

    protected boolean method_7709(class_1750 context, class_2680 state) {
        if (!super.method_7709(context, state)) {
            return false;
        }
        FurnitureData data = FurnitureItem.getData(context.method_8041());
        class_1937 level = context.method_8045();
        class_2338 basePos = context.method_8037();
        class_2350 facing = (class_2350)state.method_11654((class_2769)FurnitureBlock.FACING);
        for (int x = 0; x < data.size.x; ++x) {
            for (int y = 0; y < data.size.y; ++y) {
                for (int z = 0; z < data.size.z; ++z) {
                    class_2338 proxyPos;
                    if (x == 0 && y == 0 && z == 0 || level.method_8320(proxyPos = BaseFurnitureBlock.getProxyPosition(basePos, facing, x, y, z)).method_26166(context)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean method_7708(class_1750 context, class_2680 state) {
        if (!super.method_7708(context, state)) {
            return false;
        }
        FurnitureData data = FurnitureItem.getData(context.method_8041());
        class_1937 level = context.method_8045();
        class_2338 basePos = context.method_8037();
        class_2350 facing = (class_2350)state.method_11654((class_2769)FurnitureBlock.FACING);
        for (int x = 0; x < data.size.x; ++x) {
            for (int y = 0; y < data.size.y; ++y) {
                for (int z = 0; z < data.size.z; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    class_2338 proxyPos = BaseFurnitureBlock.getProxyPosition(basePos, facing, x, y, z);
                    class_3610 fluidstate = context.method_8045().method_8316(proxyPos);
                    boolean waterlogged = fluidstate.method_15772() == class_3612.field_15910;
                    class_2680 proxyState = (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)Blocks.FURNITURE_PROXY.method_9564().method_11657((class_2769)FurnitureProxyBlock.OFFSET_X, (Comparable)Integer.valueOf(x))).method_11657((class_2769)FurnitureProxyBlock.OFFSET_Y, (Comparable)Integer.valueOf(y))).method_11657((class_2769)FurnitureProxyBlock.OFFSET_Z, (Comparable)Integer.valueOf(z))).method_11657((class_2769)FurnitureProxyBlock.FACING, (Comparable)facing)).method_11657((class_2769)FurnitureProxyBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
                    level.method_8652(proxyPos, proxyState, 3);
                }
            }
        }
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            ServerFurnitureRegistry.increase(serverLevel, FurnitureItem.getData(context.method_8041()));
        }
        FurnitureDataManager.saveHashData(data);
        return true;
    }

    protected class_2680 method_7707(class_1750 context) {
        class_1937 class_19372;
        int identifier = -1;
        class_1799 stack = context.method_8041();
        FurnitureData data = FurnitureItem.getData(stack);
        if (!data.requiresBlockEntity() && (class_19372 = context.method_8045()) instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            int from = data.lightLevel > 0 ? 65536 : 0;
            int size = data.lightLevel > 0 ? 256 : 1024;
            identifier = ServerFurnitureRegistry.registerIdentifier(level, data, from, from + size - 1);
        }
        class_2680 state = identifier < 0 ? (class_2680)Objects.requireNonNull(Blocks.FURNITURE_ENTITY.method_9605(context)).method_11657((class_2769)EntityFurnitureBlock.LIGHT, (Comparable)Integer.valueOf(data.lightLevel)) : (data.lightLevel > 0 ? (class_2680)((class_2680)Objects.requireNonNull(Blocks.FURNITURE_LIGHT.method_9605(context)).method_11657((class_2769)LightFurnitureBlock.IDENTIFIER, (Comparable)Integer.valueOf(identifier - 65536))).method_11657((class_2769)LightFurnitureBlock.LIGHT, (Comparable)Integer.valueOf((int)Math.ceil((float)data.lightLevel / 3.0f))) : (class_2680)Objects.requireNonNull(Blocks.FURNITURE.method_9605(context)).method_11657((class_2769)FurnitureBlock.IDENTIFIER, (Comparable)Integer.valueOf(identifier)));
        return this.method_7709(context, state) ? state : null;
    }
}

