/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob;

import baguchan.enchantwithmob.EnchantConfig;
import baguchan.enchantwithmob.EnchantWithMob;
import baguchan.enchantwithmob.api.IEnchantCap;
import baguchan.enchantwithmob.api.IEnchantVisual;
import baguchan.enchantwithmob.capability.MobEnchantHandler;
import baguchan.enchantwithmob.message.MobEnchantedMessage;
import baguchan.enchantwithmob.mobenchant.MobEnchant;
import baguchan.enchantwithmob.registry.MobEnchants;
import baguchan.enchantwithmob.registry.ModItems;
import baguchan.enchantwithmob.utils.MobEnchantCombatRules;
import baguchan.enchantwithmob.utils.MobEnchantUtils;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="enchantwithmob")
public class CommonEventHandler {
    @SubscribeEvent
    public static void onTraceableEntitySpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof IEnchantVisual) {
            TraceableEntity traceableEntity;
            Entity entity2;
            IEnchantVisual enchantVisual = (IEnchantVisual)entity;
            entity = event.getEntity();
            if (entity instanceof TraceableEntity && (entity2 = (traceableEntity = (TraceableEntity)entity).m_19749_()) instanceof IEnchantCap) {
                IEnchantCap enchantCap = (IEnchantCap)entity2;
                enchantVisual.setEnchantVisual(enchantCap.getEnchantCap().hasEnchant());
            }
        }
    }

    @SubscribeEvent
    public static void onEnderDragonSpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)entity;
            entity = event.getEntity();
            if (entity instanceof EnderDragon) {
                EnderDragon livingEntity = (EnderDragon)entity;
                Level world = event.getLevel();
                if (!world.m_5776_() && !cap.getEnchantCap().hasEnchant()) {
                    float difficultScale;
                    int i;
                    if (CommonEventHandler.isSpawnAlwayEnchantableAncientEntity((Entity)livingEntity)) {
                        i = 0;
                        difficultScale = world.m_6436_(livingEntity.m_20183_()).m_19056_() - 0.2f;
                        switch (world.m_46791_()) {
                            case EASY: {
                                i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(10)) * difficultScale), (float)1.0f, (float)30.0f);
                                MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, false, true);
                                break;
                            }
                            case NORMAL: {
                                i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(15)) * difficultScale), (float)1.0f, (float)60.0f);
                                MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, false, true);
                                break;
                            }
                            case HARD: {
                                i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(20)) * difficultScale), (float)1.0f, (float)100.0f);
                                MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, false, true);
                            }
                        }
                        livingEntity.m_21153_(livingEntity.m_21233_());
                    }
                    if (CommonEventHandler.isSpawnAlwayEnchantableEntity((Entity)livingEntity)) {
                        i = 0;
                        difficultScale = world.m_6436_(livingEntity.m_20183_()).m_19056_() - 0.2f;
                        switch (world.m_46791_()) {
                            case EASY: {
                                i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(5)) * difficultScale), (float)1.0f, (float)20.0f);
                                MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, false, false);
                                break;
                            }
                            case NORMAL: {
                                i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(5)) * difficultScale), (float)1.0f, (float)40.0f);
                                MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, false, false);
                                break;
                            }
                            case HARD: {
                                i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(10)) * difficultScale), (float)1.0f, (float)50.0f);
                                MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, false, false);
                            }
                        }
                        livingEntity.m_21153_(livingEntity.m_21233_());
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onSpawnEntity(MobSpawnEvent.FinalizeSpawn event) {
        Mob mob = event.getEntity();
        if (mob instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)mob;
            ServerLevelAccessor world = event.getLevel();
            if (!world.m_5776_()) {
                float difficultScale;
                int i;
                Mob livingEntity = event.getEntity();
                if (CommonEventHandler.isSpawnAlwayEnchantableAncientEntity((Entity)livingEntity)) {
                    i = 0;
                    difficultScale = world.m_6436_(livingEntity.m_20183_()).m_19056_() - 0.2f;
                    switch (world.m_46791_()) {
                        case EASY: {
                            i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(10)) * difficultScale), (float)1.0f, (float)30.0f);
                            MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, false, true);
                            break;
                        }
                        case NORMAL: {
                            i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(15)) * difficultScale), (float)1.0f, (float)60.0f);
                            MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, false, true);
                            break;
                        }
                        case HARD: {
                            i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(20)) * difficultScale), (float)1.0f, (float)100.0f);
                            MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, false, true);
                        }
                    }
                    livingEntity.m_21153_(livingEntity.m_21233_());
                }
                if (CommonEventHandler.isSpawnAlwayEnchantableEntity((Entity)livingEntity)) {
                    i = 0;
                    difficultScale = world.m_6436_(livingEntity.m_20183_()).m_19056_() - 0.2f;
                    switch (world.m_46791_()) {
                        case EASY: {
                            i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(5)) * difficultScale), (float)1.0f, (float)20.0f);
                            MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, false, false);
                            break;
                        }
                        case NORMAL: {
                            i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(5)) * difficultScale), (float)1.0f, (float)40.0f);
                            MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, false, false);
                            break;
                        }
                        case HARD: {
                            i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(10)) * difficultScale), (float)1.0f, (float)50.0f);
                            MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, false, false);
                        }
                    }
                    livingEntity.m_21153_(livingEntity.m_21233_());
                }
                if (((Boolean)EnchantConfig.COMMON.naturalSpawnEnchantedMob.get()).booleanValue() && CommonEventHandler.isSpawnEnchantableEntity((Entity)event.getEntity()) && (!(livingEntity instanceof Animal) && !(livingEntity instanceof WaterAnimal) || ((Boolean)EnchantConfig.COMMON.spawnEnchantedAnimal.get()).booleanValue()) && event.getSpawnType() != MobSpawnType.BREEDING && event.getSpawnType() != MobSpawnType.CONVERSION && event.getSpawnType() != MobSpawnType.STRUCTURE && event.getSpawnType() != MobSpawnType.MOB_SUMMONED && (double)world.m_213780_().m_188501_() < (Double)EnchantConfig.COMMON.difficultyBasePercent.get() * (double)world.m_46791_().m_19028_() + (double)world.m_6436_(livingEntity.m_20183_()).m_19056_() * (Double)EnchantConfig.COMMON.effectiveBasePercent.get() && !world.m_5776_()) {
                    i = 0;
                    difficultScale = world.m_6436_(livingEntity.m_20183_()).m_19056_() - 0.2f;
                    switch (world.m_46791_()) {
                        case EASY: {
                            i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(5)) * difficultScale), (float)1.0f, (float)20.0f);
                            MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, true, false);
                            break;
                        }
                        case NORMAL: {
                            i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(5)) * difficultScale), (float)1.0f, (float)40.0f);
                            MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, true, false);
                            break;
                        }
                        case HARD: {
                            i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(10)) * difficultScale), (float)1.0f, (float)50.0f);
                            MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, true, false);
                        }
                    }
                    livingEntity.m_21153_(livingEntity.m_21233_());
                }
            }
        }
    }

    private static boolean isSpawnAlwayEnchantableEntity(Entity entity) {
        return !(entity instanceof Player) && !(entity instanceof ArmorStand) && !(entity instanceof Boat) && !(entity instanceof Minecart) && ((List)EnchantConfig.COMMON.ALWAY_ENCHANTABLE_MOBS.get()).contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString());
    }

    private static boolean isSpawnAlwayEnchantableAncientEntity(Entity entity) {
        return !(entity instanceof Player) && !(entity instanceof ArmorStand) && !(entity instanceof Boat) && !(entity instanceof Minecart) && ((List)EnchantConfig.COMMON.ALWAY_ENCHANTABLE_ANCIENT_MOBS.get()).contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString());
    }

    private static boolean isSpawnEnchantableEntity(Entity entity) {
        return !(entity instanceof Player) && !(entity instanceof ArmorStand) && !(entity instanceof Boat) && !(entity instanceof Minecart) && !((List)EnchantConfig.COMMON.ENCHANT_ON_SPAWN_EXCLUSION_MOBS.get()).contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString());
    }

    @SubscribeEvent
    public static void onUpdateEnchanted(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)livingEntity;
            for (MobEnchantHandler enchantHandler : cap.getEnchantCap().getMobEnchants()) {
                enchantHandler.getMobEnchant().tick(livingEntity, enchantHandler.getEnchantLevel());
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        LivingEntity attacker;
        LivingEntity livingEntity = event.getEntity();
        if (event.getSource().m_7639_() instanceof LivingEntity && (attacker = (LivingEntity)event.getSource().m_7639_()) instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)attacker;
            if (cap.getEnchantCap().hasEnchant()) {
                int mobEnchantLevel = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getEnchantCap().getMobEnchants(), (MobEnchant)MobEnchants.STRONG.get());
                int mobEnchantSize = cap.getEnchantCap().getMobEnchants().size();
                if (!livingEntity.m_21275_(event.getSource()) && event.getAmount() == 0.0f) {
                    event.setAmount(MobEnchantCombatRules.getDamageAddition(1.0f, mobEnchantLevel, mobEnchantSize));
                } else if (event.getAmount() > 0.0f) {
                    event.setAmount(MobEnchantCombatRules.getDamageAddition(event.getAmount(), mobEnchantLevel, mobEnchantSize));
                }
            }
            if (cap.getEnchantCap().hasEnchant() && MobEnchantUtils.findMobEnchantFromHandler(cap.getEnchantCap().getMobEnchants(), (MobEnchant)MobEnchants.POISON.get())) {
                int i = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getEnchantCap().getMobEnchants(), (MobEnchant)MobEnchants.POISON.get());
                if (event.getAmount() > 0.0f && attacker.m_217043_().m_188501_() < (float)i * 0.125f) {
                    livingEntity.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 60 * i, 0), (Entity)attacker);
                }
            }
        }
        if (livingEntity instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)livingEntity;
            if (!event.getSource().m_269533_(DamageTypeTags.f_268437_) && cap.getEnchantCap().hasEnchant()) {
                int mobEnchantLevel = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getEnchantCap().getMobEnchants(), (MobEnchant)MobEnchants.PROTECTION.get());
                float f = CombatRules.m_19269_((float)event.getAmount(), (float)Mth.m_14143_((float)((float)(6 + mobEnchantLevel) * 1.5f / 3.0f)));
                event.setAmount(f);
            }
            if (event.getSource().m_7640_() != null && cap.getEnchantCap().hasEnchant()) {
                int i = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getEnchantCap().getMobEnchants(), (MobEnchant)MobEnchants.THORN.get());
                if (event.getSource().m_7640_() instanceof LivingEntity && !event.getSource().m_269533_(DamageTypeTags.f_268524_) && !event.getSource().m_276093_(DamageTypes.f_268440_) && livingEntity.m_217043_().m_188501_() < (float)i * 0.1f) {
                    LivingEntity attacker2 = (LivingEntity)event.getSource().m_7640_();
                    attacker2.m_6469_(livingEntity.m_269291_().m_269374_((Entity)livingEntity), MobEnchantCombatRules.getThornDamage(event.getAmount(), cap.getEnchantCap()));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.EntityInteract event) {
        IEnchantCap cap;
        LivingEntity target;
        ItemStack stack = event.getItemStack();
        Entity entityTarget = event.getTarget();
        if (stack.m_41720_() == ModItems.MOB_ENCHANT_BOOK.get() && !event.getEntity().m_36335_().m_41519_(stack.m_41720_()) && entityTarget instanceof LivingEntity) {
            target = (LivingEntity)entityTarget;
            if (MobEnchantUtils.hasMobEnchant(stack) && target instanceof IEnchantCap) {
                cap = (IEnchantCap)target;
                boolean flag = MobEnchantUtils.addItemMobEnchantToEntity(stack, target, (LivingEntity)event.getEntity(), cap);
                if (flag) {
                    event.getEntity().m_5496_(SoundEvents.f_11887_, 1.0f, 1.0f);
                    stack.m_41622_(1, (LivingEntity)event.getEntity(), entity -> entity.m_21190_(event.getHand()));
                    event.getEntity().m_36335_().m_41524_(stack.m_41720_(), 60);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                } else {
                    event.getEntity().m_5661_((Component)Component.m_237115_((String)"enchantwithmob.cannot.enchant"), true);
                    event.getEntity().m_36335_().m_41524_(stack.m_41720_(), 20);
                    event.setCancellationResult(InteractionResult.FAIL);
                    event.setCanceled(true);
                }
            }
        }
        if (stack.m_41720_() == ModItems.MOB_UNENCHANT_BOOK.get() && !event.getEntity().m_36335_().m_41519_(stack.m_41720_()) && entityTarget instanceof LivingEntity && (target = (LivingEntity)entityTarget) instanceof IEnchantCap) {
            cap = (IEnchantCap)target;
            MobEnchantUtils.removeMobEnchantToEntity(target, cap);
            event.getEntity().m_5496_(SoundEvents.f_11887_, 1.0f, 1.0f);
            stack.m_41622_(1, (LivingEntity)event.getEntity(), entity -> entity.m_21190_(event.getHand()));
            event.getEntity().m_36335_().m_41524_(stack.m_41720_(), 80);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack stack1 = event.getLeft();
        ItemStack stack2 = event.getRight();
        if (stack1.m_41720_() == ModItems.MOB_ENCHANT_BOOK.get() && stack2.m_41720_() == ModItems.MOB_ENCHANT_BOOK.get()) {
            Map<MobEnchant, Integer> map = MobEnchantUtils.getEnchantments(stack1);
            Map<MobEnchant, Integer> map1 = MobEnchantUtils.getEnchantments(stack2);
            boolean flag2 = false;
            boolean flag3 = false;
            for (MobEnchant enchantment1 : map1.keySet()) {
                int j2;
                if (enchantment1 == null) continue;
                int i2 = map.getOrDefault(enchantment1, 0);
                j2 = i2 == (j2 = map1.get(enchantment1).intValue()) ? j2 + 1 : Math.max(j2, i2);
                boolean flag1 = true;
                for (MobEnchant enchantment : map.keySet()) {
                    if (enchantment == enchantment1 || enchantment1.isCompatibleWith(enchantment)) continue;
                    flag1 = false;
                }
                if (!flag1) {
                    flag3 = true;
                    continue;
                }
                flag2 = true;
                if (j2 > enchantment1.getMaxLevel()) {
                    j2 = enchantment1.getMaxLevel();
                }
                map.put(enchantment1, j2);
                int k3 = 0;
                switch (enchantment1.getRarity()) {
                    case COMMON: {
                        k3 = 1;
                        break;
                    }
                    case UNCOMMON: {
                        k3 = 2;
                        break;
                    }
                    case RARE: {
                        k3 = 4;
                        break;
                    }
                    case VERY_RARE: {
                        k3 = 8;
                    }
                }
            }
            if (!stack1.m_41619_()) {
                int k2 = stack1.m_41610_();
                if (!stack2.m_41619_() && k2 < stack2.m_41610_()) {
                    k2 = stack2.m_41610_();
                }
                ItemStack stack3 = new ItemStack((ItemLike)stack1.m_41720_());
                MobEnchantUtils.setEnchantments(map, stack3);
                stack3.m_41742_(4 + k2);
                event.setOutput(stack3);
                event.setCost(4 + k2);
                event.setMaterialCost(1);
            }
        }
    }

    @SubscribeEvent
    public static void onExpDropped(LivingExperienceDropEvent event) {
        IEnchantCap cap;
        LivingEntity entity = event.getEntity();
        if (entity instanceof IEnchantCap && (cap = (IEnchantCap)entity).getEnchantCap().hasEnchant()) {
            if (cap.getEnchantCap().isAncient()) {
                event.setDroppedExperience(event.getDroppedExperience() + MobEnchantUtils.getExperienceFromMob(cap) * 5);
            } else {
                event.setDroppedExperience(event.getDroppedExperience() + MobEnchantUtils.getExperienceFromMob(cap));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer && player instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)player;
            for (int i = 0; i < cap.getEnchantCap().getMobEnchants().size(); ++i) {
                EnchantWithMob.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MobEnchantedMessage((Entity)player, cap.getEnchantCap().getMobEnchants().get(i)));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player playerEntity = event.getEntity();
        if (playerEntity instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)playerEntity;
            if (!playerEntity.m_9236_().m_5776_()) {
                for (int i = 0; i < cap.getEnchantCap().getMobEnchants().size(); ++i) {
                    EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> playerEntity), (Object)new MobEnchantedMessage((Entity)playerEntity, cap.getEnchantCap().getMobEnchants().get(i)));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        Player newPlayer = event.getEntity();
        if (!event.isWasDeath()) {
            ((IEnchantCap)oldPlayer).getEnchantCap().getMobEnchants().forEach(mobEnchantHandler -> ((IEnchantCap)newPlayer).getEnchantCap().addMobEnchant((LivingEntity)newPlayer, mobEnchantHandler.getMobEnchant(), mobEnchantHandler.getEnchantLevel()));
        }
    }
}

