/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.client;

import baguchan.enchantwithmob.api.IEnchantCap;
import baguchan.enchantwithmob.capability.MobEnchantCapability;
import baguchan.enchantwithmob.client.render.layer.EnchantLayer;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="enchantwithmob", value={Dist.CLIENT})
public class ClientEventHandler {
    protected static final RenderStateShard.LightmapStateShard LIGHTMAP = new RenderStateShard.LightmapStateShard(true);
    protected static final RenderStateShard.TransparencyStateShard ADDITIVE_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("additive_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final RenderStateShard.ShaderStateShard RENDERTYPE_ENTITY_GLINT_SHADER = new RenderStateShard.ShaderStateShard(GameRenderer::m_172747_);
    protected static final RenderStateShard.ShaderStateShard RENDERTYPE_ENERGY_SWIRL_SHADER = new RenderStateShard.ShaderStateShard(GameRenderer::m_172703_);
    protected static final RenderStateShard.CullStateShard NO_CULL = new RenderStateShard.CullStateShard(false);
    protected static final RenderStateShard.TexturingStateShard ENTITY_GLINT_TEXTURING = new RenderStateShard.TexturingStateShard("entity_glint_texturing", () -> ClientEventHandler.setupGlintTexturing(0.16f), () -> RenderSystem.resetTextureMatrix());

    @SubscribeEvent
    public static void renderEnchantBeam(RenderLivingEvent.Post<LivingEntity, EntityModel<LivingEntity>> event) {
        LivingEntity entity;
        IEnchantCap cap;
        PoseStack matrixStack = event.getPoseStack();
        MultiBufferSource bufferBuilder = event.getMultiBufferSource();
        float particalTick = event.getPartialTick();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof IEnchantCap && (cap = (IEnchantCap)livingEntity).getEnchantCap().getEnchantOwner() != null && (entity = cap.getEnchantCap().getEnchantOwner()) != null) {
            ClientEventHandler.renderBeam(cap.getEnchantCap(), event.getEntity(), particalTick, matrixStack, bufferBuilder, (Entity)entity, (LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>>)event.getRenderer());
        }
    }

    public static Vec3 getPosition(Entity p_114803_, double p_114804_, float p_114805_) {
        double d0 = Mth.m_14139_((double)p_114805_, (double)p_114803_.f_19790_, (double)p_114803_.m_20185_());
        double d1 = Mth.m_14139_((double)p_114805_, (double)p_114803_.f_19791_, (double)p_114803_.m_20186_()) + p_114804_;
        double d2 = Mth.m_14139_((double)p_114805_, (double)p_114803_.f_19792_, (double)p_114803_.m_20189_());
        return new Vec3(d0, d1, d2);
    }

    protected static float getXRotD(LivingEntity livingEntity, Entity target, float totalTick) {
        double d0 = target.m_20318_((float)totalTick).f_82479_ - livingEntity.m_20318_((float)totalTick).f_82479_;
        double d1 = target.m_20318_((float)totalTick).f_82480_ - livingEntity.m_20318_((float)totalTick).f_82480_;
        double d2 = target.m_20318_((float)totalTick).f_82481_ - livingEntity.m_20318_((float)totalTick).f_82481_;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        return (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875));
    }

    protected static float getYRotD(LivingEntity livingEntity, Entity target, float totalTick) {
        double d0 = target.m_20318_((float)totalTick).f_82479_ - livingEntity.m_20318_((float)totalTick).f_82479_;
        double d1 = target.m_20318_((float)totalTick).f_82481_ - livingEntity.m_20318_((float)totalTick).f_82481_;
        return (float)(Mth.m_14136_((double)d1, (double)d0) * 57.2957763671875) - 90.0f;
    }

    private static void renderBeam(@NotNull MobEnchantCapability cap, LivingEntity livingEntity, float totalTickTime, PoseStack poseStack, MultiBufferSource multiBufferSource, Entity target, LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>> renderer) {
        poseStack.m_85836_();
        double d3 = Mth.m_14139_((double)totalTickTime, (double)livingEntity.f_19854_, (double)livingEntity.m_20185_());
        double d4 = Mth.m_14139_((double)totalTickTime, (double)livingEntity.f_19855_, (double)livingEntity.m_20186_()) + (double)(livingEntity.m_20206_() * 0.5f);
        double d5 = Mth.m_14139_((double)totalTickTime, (double)livingEntity.f_19856_, (double)livingEntity.m_20189_());
        Vec3 vector3d = target.m_20299_(totalTickTime);
        Vec3 vec31 = new Vec3(d3, d4, d5);
        Vec3 vec32 = vector3d.m_82546_(vec31);
        float q = -0.0f;
        float v = 0.2f;
        float w2 = 0.5f;
        float length = (float)vec32.m_82553_();
        float uv2 = -1.0f;
        float uv1 = length * 2.5f + uv2;
        float x1 = Mth.m_14089_((float)(q + (float)Math.PI)) * v;
        float z1 = Mth.m_14031_((float)(q + (float)Math.PI)) * v;
        float x2 = Mth.m_14089_((float)(q + 0.0f)) * v;
        float z2 = Mth.m_14031_((float)(q + 0.0f)) * v;
        float x3 = Mth.m_14089_((float)(q + 1.5707964f)) * v;
        float z3 = Mth.m_14031_((float)(q + 1.5707964f)) * v;
        float x4 = Mth.m_14089_((float)(q + 4.712389f)) * v;
        float z4 = Mth.m_14031_((float)(q + 4.712389f)) * v;
        float y1 = length;
        float y2 = 0.0f;
        float ux1 = 0.4999f;
        float ux2 = 0.0f;
        poseStack.m_252880_(0.0f, livingEntity.m_20206_() * 0.5f, 0.0f);
        VertexConsumer consumer = multiBufferSource.m_6299_(EnchantLayer.enchantBeamSwirl(cap.isAncient() ? EnchantLayer.ANCIENT_GLINT : ItemRenderer.f_273897_));
        float xRot = ClientEventHandler.getXRotD(livingEntity, target, totalTickTime);
        float yRot = ClientEventHandler.getYRotD(livingEntity, target, totalTickTime);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-yRot));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(xRot));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
        float intensity = cap.getMobEnchants().size() < 3 ? (float)cap.getMobEnchants().size() / 3.0f : 3.0f;
        int intensityCacl = (int)(intensity / 3.0f * 255.0f);
        ClientEventHandler.vertex(consumer, matrix4f, matrix3f, x1, y1, z1, 255, 255, 255, intensityCacl, ux1, uv1);
        ClientEventHandler.vertex(consumer, matrix4f, matrix3f, x1, y2, z1, 255, 255, 255, intensityCacl, ux1, uv2);
        ClientEventHandler.vertex(consumer, matrix4f, matrix3f, x2, y2, z2, 255, 255, 255, intensityCacl, ux2, uv2);
        ClientEventHandler.vertex(consumer, matrix4f, matrix3f, x2, y1, z2, 255, 255, 255, intensityCacl, ux2, uv1);
        ClientEventHandler.vertex(consumer, matrix4f, matrix3f, x3, y1, z3, 255, 255, 255, intensityCacl, ux1, uv1);
        ClientEventHandler.vertex(consumer, matrix4f, matrix3f, x3, y2, z3, 255, 255, 255, intensityCacl, ux1, uv2);
        ClientEventHandler.vertex(consumer, matrix4f, matrix3f, x4, y2, z4, 255, 255, 255, intensityCacl, ux2, uv2);
        ClientEventHandler.vertex(consumer, matrix4f, matrix3f, x4, y1, z4, 255, 255, 255, intensityCacl, ux2, uv1);
        poseStack.m_85849_();
    }

    private static void vertex(VertexConsumer vertexConsumer, Matrix4f matrix4f, Matrix3f matrix3f, float x, float y, float z, int red, int green, int blue, int alpha, float ux, float uz) {
        vertexConsumer.m_252986_(matrix4f, x, y, z).m_6122_(red, green, blue, 255).m_7421_(ux, uz).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void setupGlintTexturing(float p_110187_) {
        long i = Util.m_137550_() * 8L;
        float f = (float)(i % 110000L) / 110000.0f;
        float f1 = (float)(i % 30000L) / 30000.0f;
        Matrix4f matrix4f = new Matrix4f().translation(-f, f1, 0.0f);
        matrix4f.rotateZ(0.17453292f).scale(p_110187_);
        RenderSystem.setTextureMatrix((Matrix4f)matrix4f);
    }
}

