/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.config;

import me.myogoo.extendedterminal.api.config.IETTerminalConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public final class TerminalConfigEntry {
    private final ModConfigSpec.BooleanValue enable;
    private final ModConfigSpec.BooleanValue craftOnlyPowered;
    private final ModConfigSpec.DoubleValue passiveDrain;

    private TerminalConfigEntry(ModConfigSpec.Builder builder, String commentName, double defaultDrain, boolean pop) {
        builder.comment(commentName).push(commentName);
        this.enable = builder.comment("Enable this terminal").define("Enable", true);
        this.craftOnlyPowered = builder.comment("AE system must be online & powered to craft").define("Craftable when Active", false);
        this.passiveDrain = builder.comment("Passive AE/t drain").defineInRange("Passive drain AE", defaultDrain, 0.0, Double.MAX_VALUE);
        if (pop) {
            builder.pop();
        }
    }

    public static TerminalConfigEntry instantCreate(ModConfigSpec.Builder builder, String name, double defaultDrain) {
        return new TerminalConfigEntry(builder, name, defaultDrain, true);
    }

    public static TerminalConfigEntry instantCreate(ModConfigSpec.Builder builder, String name, double defaultDrain, boolean pop) {
        return new TerminalConfigEntry(builder, name, defaultDrain, pop);
    }

    public IETTerminalConfig bake() {
        return new TerminalConfigData((Boolean)this.enable.get(), (Boolean)this.craftOnlyPowered.get(), (Double)this.passiveDrain.get());
    }

    private record TerminalConfigData(boolean enableTerminal, boolean enableCraftOnlyPowered, double passiveDrainAE) implements IETTerminalConfig
    {
    }
}

