/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.init;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import me.myogoo.extendedterminal.config.ExtendedTerminalConfig;
import me.myogoo.extendedterminal.config.avaritiaNeo.AvaritiaNeoConfig;
import me.myogoo.extendedterminal.config.avaritiaRe.AvaritiaReConfig;
import me.myogoo.extendedterminal.config.extendedcrafting.ExtendedCraftingConfig;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="extendedterminal", bus=EventBusSubscriber.Bus.MOD)
public class ETConfig {
    private static final Map<Object, Runnable> BAKERS;

    public static void init(ModContainer container) {
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ExtendedTerminalConfig.COMMON, "extendedterminal/ExtendedTerminal-common.toml");
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AvaritiaReConfig.COMMON, "extendedterminal/addons/ReAvaritia.toml");
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AvaritiaNeoConfig.COMMON, "extendedterminal/addons/AvaritiaNeo.toml");
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ExtendedCraftingConfig.COMMON, "extendedterminal/addons/ExtendedCrafting.toml");
    }

    @SubscribeEvent
    static void bake(ModConfigEvent event) {
        Runnable baker = BAKERS.get(event.getConfig().getSpec());
        if (baker != null) {
            baker.run();
        }
    }

    static {
        IdentityHashMap<ModConfigSpec, Runnable> m = new IdentityHashMap<ModConfigSpec, Runnable>();
        m.put(ExtendedTerminalConfig.COMMON, ExtendedTerminalConfig.INSTANCE::bake);
        m.put(AvaritiaReConfig.COMMON, AvaritiaReConfig.INSTANCE::bake);
        m.put(AvaritiaNeoConfig.COMMON, AvaritiaNeoConfig.INSTANCE::bake);
        m.put(ExtendedCraftingConfig.COMMON, ExtendedCraftingConfig.INSTANCE::bake);
        BAKERS = Collections.unmodifiableMap(m);
    }
}

